/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.graphs.tensor;

import de.jstacs.algorithms.graphs.tensor.AsymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.utils.SafeOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class Tensor {
    protected int[] powers;
    protected int L;
    protected byte order;
    private static final double NOT_USED = Double.NaN;

    public Tensor(int n, byte k) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("The number of nodes n has to be positive.");
        }
        if (k < 1) {
            throw new IllegalArgumentException("The order k has to be at least 1.");
        }
        this.L = n - 1;
        this.order = k;
        this.powers = new int[k + 2];
        this.powers[0] = 1;
        int j = 1;
        while (j <= k + 1) {
            this.powers[j] = this.powers[j - 1] * n;
            ++j;
        }
    }

    public abstract int[] getMaximalEdgeFor(byte var1, int var2, int ... var3);

    public int getNumberOfNodes() {
        return this.L + 1;
    }

    public byte getOrder() {
        return this.order;
    }

    public abstract double getRootValue(int var1);

    public abstract double getValue(byte var1, int var2, int ... var3);

    public abstract void setRootValue(int var1, double var2);

    public abstract void setValue(byte var1, double var2, int var4, int ... var5);

    public abstract void resetValue(byte var1, int var2, int ... var3);

    public void writeTensorToFile(String fname, OutputStream desc) throws IOException {
        int phase = this.getNumberOfNodes();
        byte k = 1;
        BufferedWriter writer = new BufferedWriter(new FileWriter(fname));
        writer.write(String.valueOf(phase));
        writer.newLine();
        SafeOutputStream description = SafeOutputStream.getSafeOutputStream(desc);
        description.writeln("number of nodes");
        writer.write("E 0");
        writer.newLine();
        description.writeln("E 0");
        int i = 0;
        while (i < phase) {
            writer.write("" + this.getRootValue(i));
            writer.newLine();
            description.writeln("v(" + i + ") = value for node " + i);
            ++i;
        }
        while (k <= this.order) {
            writer.write("E " + k);
            writer.newLine();
            description.writeln("E " + k);
            int[] parents = new int[k];
            int anz = (int)Math.pow(phase, k);
            i = 0;
            while (i < phase) {
                int j = 0;
                while (j < anz) {
                    int help = j;
                    int l = 0;
                    while (l < k) {
                        parents[l] = help % phase;
                        help /= phase;
                        ++l;
                    }
                    if (Tensor.check(i, (int[])parents.clone())) {
                        writer.write("" + this.getValue(k, i, parents));
                        writer.newLine();
                        description.writeln("v(" + i + ", " + Arrays.toString(parents) + ") = value for edge " + i + " <- " + this.toString(parents));
                    }
                    ++j;
                }
                ++i;
            }
            k = (byte)(k + 1);
        }
        description.flush();
        description.close();
        writer.flush();
        writer.close();
    }

    private String toString(int[] array) {
        if (array != null && array.length > 0) {
            String res = "";
            int i = 0;
            int l = array.length - 1;
            while (i < l) {
                res = String.valueOf(res) + array[i] + "<-";
                ++i;
            }
            return "[" + res + array[i] + "]";
        }
        return "[]";
    }

    public static Tensor readTensorFromFile(String fname, boolean asym) throws NumberFormatException, IOException {
        String s;
        BufferedReader reader = new BufferedReader(new FileReader(fname));
        int anz = 1;
        int parents = 0;
        int phase = Integer.parseInt(reader.readLine());
        ArrayList<double[][]> list = new ArrayList<double[][]>();
        while ((s = reader.readLine()) != null && s.equals("E " + parents)) {
            int n;
            double[][] values = new double[phase][anz];
            if (parents == 0) {
                n = 0;
                while (n < phase) {
                    values[n][0] = Double.parseDouble(reader.readLine());
                    ++n;
                }
            } else {
                int[] par = new int[parents];
                n = 0;
                while (n < phase) {
                    int i = 0;
                    while (i < anz) {
                        int help = i;
                        int l = 0;
                        while (l < parents) {
                            par[l] = help % phase;
                            help /= phase;
                            ++l;
                        }
                        values[n][i] = Tensor.check(n, (int[])par.clone()) ? Double.parseDouble(reader.readLine()) : Double.NaN;
                        ++i;
                    }
                    ++n;
                }
            }
            anz *= phase;
            ++parents;
            list.add(values);
        }
        reader.close();
        double[][][] ten = (double[][][])list.toArray((T[])new double[0][0][0]);
        if (asym) {
            return new AsymmetricTensor(ten, phase, (byte)(ten.length - 1));
        }
        return new SymmetricTensor(ten, phase, (byte)(ten.length - 1));
    }

    public double[][][] toDouble3DArray() {
        int phase = this.getNumberOfNodes();
        byte k = 1;
        double[][][] erg = new double[this.order + 1][phase][];
        int i = 0;
        while (i < phase) {
            erg[0][i] = new double[]{this.getRootValue(i)};
            ++i;
        }
        while (k <= this.order) {
            int[] parents = new int[k];
            int anz = (int)Math.pow(phase, k);
            i = 0;
            while (i < phase) {
                erg[k][i] = new double[anz];
                int j = 0;
                while (j < anz) {
                    int help = j;
                    int l = 0;
                    while (l < k) {
                        parents[l] = help % phase;
                        help /= phase;
                        ++l;
                    }
                    erg[k][i][j] = Tensor.check(i, (int[])parents.clone()) ? this.getValue(k, i, parents) : Double.NaN;
                    ++j;
                }
                ++i;
            }
            k = (byte)(k + 1);
        }
        return erg;
    }

    private static boolean check(int current, int[] array) {
        Arrays.sort(array);
        boolean erg = array[0] != current;
        int i = 1;
        while (i < array.length && (erg &= array[i] != current && array[i] != array[i - 1])) {
            ++i;
        }
        return erg;
    }

    protected int getAsymIndex(int child, int[] parents, byte k) {
        int erg = 0;
        int j = 0;
        while (j < k) {
            erg += this.powers[j] * parents[j];
            ++j;
        }
        return erg;
    }
}

