/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.elements;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.elements.BasicTransitionElement;

public class BasicPluginTransitionElement
extends BasicTransitionElement {
    private double[] probs;
    private static final String XML_TAG = "BasicPluginTransitionElement";

    public BasicPluginTransitionElement(int[] context, int[] states, double[] probs, double[] hyperParameters) {
        this(context, states, probs, hyperParameters, null);
    }

    public BasicPluginTransitionElement(int[] context, int[] states, double[] probs, double[] hyperParameters, double[] weight) {
        super(context, states, hyperParameters, weight);
        this.probs = (double[])probs.clone();
        this.initializeRandomly();
    }

    public BasicPluginTransitionElement(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public void initializeRandomly() {
        int i = 0;
        while (i < this.probs.length) {
            this.parameters[i] = Math.log(this.probs[i]);
            ++i;
        }
        this.logNorm = 0.0;
    }

    @Override
    protected void appendFurtherInformation(StringBuffer xml) {
        XMLParser.appendObjectWithTags(xml, this.probs, "InitialProbabilities");
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.probs = (double[])XMLParser.extractObjectForTags(xml, "InitialProbabilities");
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }
}

