/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.graphics;

import de.jstacs.utils.graphics.GraphicsAdaptor;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class RasterizedAdaptor
extends GraphicsAdaptor {
    private BufferedImage img;
    protected Graphics2D graphics;
    private String type;

    public RasterizedAdaptor(String type) {
        this.type = type;
    }

    @Override
    public Graphics2D getGraphics(int width, int height) {
        this.img = new BufferedImage(width, height, 1);
        this.graphics = (Graphics2D)this.img.getGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return this.graphics;
    }

    @Override
    public void generateOutput(File file) throws IOException {
        ImageIO.write((RenderedImage)this.img, this.type, file);
    }

    @Override
    public String getGraphicsExtension() {
        return this.type;
    }

    public BufferedImage getImage() {
        return this.img;
    }
}

