/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.graphics;

import de.jstacs.utils.graphics.GraphicsAdaptor;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGAdaptor
extends GraphicsAdaptor {
    protected SVGGraphics2D graphics;
    protected Document document;

    public SVGAdaptor() {
        DOMImplementation domImpl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        this.document = domImpl.createDocument(svgNS, "svg", null);
        this.graphics = new SVGGraphics2D(this.document);
    }

    @Override
    public Graphics2D getGraphics(int width, int height) {
        return this.graphics;
    }

    @Override
    public void generateOutput(File file) throws IOException {
        boolean useCSS = true;
        FileWriter out = new FileWriter(file);
        this.graphics.stream(out, useCSS);
        ((Writer)out).close();
    }

    @Override
    public String getGraphicsExtension() {
        return "svg";
    }
}

