/*
 * Decompiled with CFR 0.152.
 */
package projects.dimont;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.NormalizedDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import javax.naming.OperationNotSupportedException;
import projects.dimont.AbstractSingleMotifChIPper;

public class ThresholdedNoStrandChIPper
extends AbstractSingleMotifChIPper {
    private double[] scoreProfile;
    private double[] normedProfile;
    private double[] temp;
    private IntList tempPos;
    private IntList end;
    private double threshold;
    private HashMap<Sequence, IntList> toBeUsedHash;

    public ThresholdedNoStrandChIPper(int starts, double t, DifferentiableStatisticalModel motif) throws CloneNotSupportedException {
        super(starts, motif);
        if (t <= 0.0 || t > 1.0) {
            throw new IllegalArgumentException();
        }
        this.threshold = t;
        this.init();
    }

    public ThresholdedNoStrandChIPper(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.init();
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.threshold = (Double)XMLParser.extractObjectForTags(xml, "threshold");
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer extra = new StringBuffer(100);
        XMLParser.appendObjectWithTags(extra, this.threshold, "threshold");
        return extra;
    }

    @Override
    protected void init() {
        super.init();
        this.end = new IntList();
        this.tempPos = new IntList();
        this.toBeUsedHash = new HashMap();
    }

    @Override
    public ThresholdedNoStrandChIPper clone() throws CloneNotSupportedException {
        ThresholdedNoStrandChIPper clone = (ThresholdedNoStrandChIPper)super.clone();
        if (this.scoreProfile != null) {
            clone.scoreProfile = (double[])this.scoreProfile.clone();
        }
        if (this.normedProfile != null) {
            clone.normedProfile = (double[])this.normedProfile.clone();
        }
        if (this.temp != null) {
            clone.temp = (double[])this.temp.clone();
        }
        clone.end = this.end.clone();
        clone.tempPos = this.tempPos.clone();
        clone.toBeUsedHash = new HashMap();
        for (Sequence s : this.toBeUsedHash.keySet()) {
            clone.toBeUsedHash.put(s, this.toBeUsedHash.get(s).clone());
        }
        return clone;
    }

    @Override
    protected int fillMotifComponentScoreOf(double[] array, Sequence sequence, int startpos) {
        int end = this.fillComponentScoreOf(array, sequence, startpos, null, false);
        return end;
    }

    protected int fillComponentScoreOf(Sequence seq, int start, IntList b, boolean usePosition) {
        int m = this.function[0].getLength();
        int end = seq.getLength() - start - m + 1;
        if (this.scoreProfile == null || this.scoreProfile.length < 2 * end) {
            this.scoreProfile = new double[seq.getLength() * 2];
        }
        return this.fillComponentScoreOf(this.scoreProfile, seq, start, b, usePosition);
    }

    protected int fillComponentScoreOf(double[] array, Sequence seq, int start, IntList b, boolean usePosition) {
        int m = this.function[0].getLength();
        int end = seq.getLength() - start - m + 1;
        double pos = 0.0;
        float[] position = null;
        if (usePosition && (position = this.getPosition(seq, false)) == null) {
            pos = -Math.log(end);
        }
        int j = 0;
        int curr = -1;
        int n = b == null ? end : b.length();
        int l = 0;
        while (l < n) {
            if (b != null) {
                curr = b.get(l);
                boolean rc = false;
                if (curr < 0) {
                    rc = true;
                    curr = -curr - 1;
                }
                if (curr >= start && curr <= seq.getLength() - m) {
                    if (position != null) {
                        pos = position[curr];
                    }
                    if (rc) {
                        try {
                            array[j++] = pos + this.function[0].getLogScoreFor(seq.reverseComplement(), seq.getLength() - curr - m) - (double)m * this.logP;
                        }
                        catch (OperationNotSupportedException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        array[j++] = pos + this.function[0].getLogScoreFor(seq, curr) - (double)m * this.logP;
                    }
                }
            } else {
                curr = start + l;
                if (curr >= start && curr <= seq.getLength() - m) {
                    if (position != null) {
                        pos = position[curr];
                    }
                    array[j++] = Normalisation.getLogSum(pos + this.function[0].getLogScoreFor(seq, curr) - (double)m * this.logP);
                }
            }
            ++l;
        }
        return j;
    }

    @Override
    public double[] getStrandProfileOfScoresFor(Sequence seq, boolean forwardStrand) throws OperationNotSupportedException {
        int m = this.function[0].getLength();
        int end = seq.getLength() - m + 1;
        double[] res = new double[end];
        double offset = this.logHiddenPotential[0] - Math.log(end) + (double)end * this.logP;
        if (forwardStrand) {
            int i = 0;
            while (i < end) {
                res[i] = offset + this.function[0].getLogScoreFor(seq, i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < end) {
                res[i] = offset + this.function[0].getLogScoreFor(seq.reverseComplement(), end - i - 1);
                ++i;
            }
        }
        return res;
    }

    @Override
    protected void fillComponentScores(Sequence seq, int start) {
        double h = (double)(seq.getLength() - start) * this.logP;
        IntList b = this.toBeUsedHash.get(seq);
        int j = this.fillComponentScoreOf(seq, start, b == null ? null : b, true);
        this.componentScore[0] = h + this.logHiddenPotential[0] + Normalisation.getLogSum(0, j, this.scoreProfile);
        this.componentScore[this.function.length] = h + this.logHiddenPotential[this.function.length];
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        boolean add;
        int startIndex = partialDer.length();
        double pos = Double.NaN;
        IntList b = this.toBeUsedHash.get(seq);
        boolean bl = add = b == null;
        if (add) {
            b = new IntList();
        } else {
            b.clear();
        }
        int m = this.function[0].getLength();
        int stop = seq.getLength() - start - m + 1;
        if (stop > 0) {
            float[] position = this.getPosition(seq, true);
            if (position == null) {
                pos = -Math.log(stop);
            }
            if (this.scoreProfile == null || this.scoreProfile.length < 2 * stop) {
                this.scoreProfile = new double[seq.getLength() * 2];
            }
            if (this.normedProfile == null || this.normedProfile.length < 2 * stop) {
                this.normedProfile = new double[seq.getLength() * 2];
            }
            if (this.temp == null || this.temp.length < 2 * stop) {
                this.temp = new double[seq.getLength() * 2];
            }
            int n = 0;
            int l = start;
            while (n < stop) {
                if (position != null) {
                    pos = position[l];
                }
                this.scoreProfile[n] = pos + this.function[0].getLogScoreFor(seq, l) - (double)m * this.logP;
                this.scoreProfile[n + stop] = Double.NEGATIVE_INFINITY;
                ++l;
                ++n;
            }
            Normalisation.logSumNormalisation(this.scoreProfile, 0, 2 * stop, this.normedProfile, 0);
            System.arraycopy(this.normedProfile, 0, this.temp, 0, 2 * stop);
            Arrays.sort(this.temp, 0, 2 * stop);
            int e = 2 * stop - 1;
            double s = 0.0;
            while (e > 0 && (s += this.temp[e]) < this.threshold) {
                --e;
            }
            double t = this.temp[e];
            int k = 0;
            this.iList[0].clear();
            this.dList[0].clear();
            this.end.clear();
            this.tempPos.clear();
            e = 0;
            while (e < stop) {
                if (this.normedProfile[e] >= t) {
                    this.normedProfile[k++] = this.scoreProfile[e];
                    this.function[0].getLogScoreAndPartialDerivation(seq, start + e, this.iList[0], this.dList[0]);
                    b.add(e);
                    this.end.add(this.iList[0].length());
                }
                ++e;
            }
            if (add && start == 0) {
                this.toBeUsedHash.put(seq, b);
            }
            this.componentScore[0] = this.logHiddenPotential[0] + Normalisation.logSumNormalisation(this.normedProfile, 0, k);
            k = 0;
            int counter = 0;
            while (k < b.length()) {
                e = this.end.get(k);
                while (counter < e) {
                    indices.add(this.iList[0].get(counter) + this.paramRef[0]);
                    partialDer.add(this.dList[0].get(counter++) * this.normedProfile[k]);
                }
                ++k;
            }
        } else {
            this.componentScore[0] = Double.NEGATIVE_INFINITY;
        }
        this.componentScore[this.function.length] = this.logHiddenPotential[this.function.length];
        double logScore = Normalisation.logSumNormalisation(this.componentScore, 0, this.componentScore.length, this.componentScore, 0);
        partialDer.multiply(startIndex, partialDer.length(), this.componentScore[0]);
        int j = 0;
        while (j < 2) {
            indices.add(this.paramRef[1] + j);
            partialDer.add(this.componentScore[j] - (this.isNormalized() ? this.hiddenPotential[j] : 0.0));
            ++j;
        }
        return logScore + this.logP * (double)(seq.getLength() - start);
    }

    @Override
    public String getInstanceName() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.function[0].getInstanceName() + ")";
    }

    @Override
    public double[] getStrandProbabilitiesFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        if (motif > 0 || component > this.function.length) {
            throw new IndexOutOfBoundsException();
        }
        DifferentiableStatisticalModel m = this.function[component];
        while (m instanceof NormalizedDiffSM) {
            m = ((NormalizedDiffSM)m).getFunction();
        }
        Sequence ts = sequence.getSubSequence(startpos, m.getLength());
        double[] temp = new double[]{m.getLogScoreFor(ts), m.getLogScoreFor(ts.reverseComplement())};
        Normalisation.logSumNormalisation(temp);
        return temp;
    }

    @Override
    public void reset() {
        this.toBeUsedHash.clear();
    }

    public void setMotifModel(DifferentiableStatisticalModel bn) {
        this.function[0] = bn;
        this.init(false);
    }

    public DifferentiableStatisticalModel getMotifModel() {
        return this.function[0];
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer buf = new StringBuffer();
        this.precomputeNorm();
        buf.append("motif probability:" + nf.format(Math.exp(this.partNorm[0] - this.norm)) + "\n");
        buf.append(this.function[0].toString());
        return buf.toString();
    }

    public String toHtml(NumberFormat nf) {
        StringBuffer buf = new StringBuffer();
        this.precomputeNorm();
        buf.append("<p><strong>motif probability:</strong> " + nf.format(Math.exp(this.partNorm[0] - this.norm)) + "</p>");
        if (this.function[0] instanceof BayesianNetworkDiffSM) {
            buf.append(((BayesianNetworkDiffSM)this.function[0]).toHtml(nf));
        } else {
            buf.append(this.function[0].toString());
        }
        return buf.toString();
    }
}

