/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.results.Result;
import projects.tals.RVDSequence;

public class RVDReferenceSequenceAnnotationParser
extends SplitSequenceAnnotationParser {
    private String key;
    private AlphabetContainer alphabet12;
    private AlphabetContainer alphabet13;

    public RVDReferenceSequenceAnnotationParser(String key, String keyValueDelimiter, String annotationDelimiter, AlphabetContainer alphabet12, AlphabetContainer alphabet13) throws IllegalArgumentException {
        super(keyValueDelimiter, annotationDelimiter);
        this.key = key;
        this.alphabet12 = alphabet12;
        this.alphabet13 = alphabet13;
    }

    protected ReferenceSequenceAnnotation getSequenceAnnotation(String seqString) throws IllegalArgumentException, WrongAlphabetException, WrongSequenceTypeException, DoubleSymbolException {
        return new ReferenceSequenceAnnotation(this.key, new RVDSequence(this.alphabet12, this.alphabet13, seqString), new Result[0]);
    }

    @Override
    protected void add(String type, String identifier) {
        if (type.equalsIgnoreCase(this.key)) {
            try {
                this.annot.add(this.getSequenceAnnotation(identifier));
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
        } else {
            super.add(type, identifier);
        }
    }

    @Override
    public String parseAnnotationToComment(char commentChar, SequenceAnnotation ... annotations) {
        StringBuffer res = new StringBuffer();
        res.append(commentChar);
        if (annotations != null && annotations.length > 0) {
            if (annotations[0] instanceof ReferenceSequenceAnnotation) {
                Sequence rs = ((ReferenceSequenceAnnotation)annotations[0]).getReferenceSequence();
                res.append(String.valueOf(annotations[0].getIdentifier()) + this.keyValueDelimiter + rs.toString(rs.getAlphabetContainer().getDelim(), 0, rs.getLength()));
            } else {
                res.append(String.valueOf(annotations[0].getType()) + this.keyValueDelimiter + annotations[0].getIdentifier());
            }
            int i = 1;
            while (i < annotations.length) {
                if (annotations[i] instanceof ReferenceSequenceAnnotation) {
                    Sequence rs = ((ReferenceSequenceAnnotation)annotations[i]).getReferenceSequence();
                    res.append(String.valueOf(this.annotationDelimiter) + " " + annotations[i].getIdentifier() + this.keyValueDelimiter + rs.toString(rs.getAlphabetContainer().getDelim(), 0, rs.getLength()));
                } else {
                    res.append(String.valueOf(this.annotationDelimiter) + " " + annotations[i].getType() + this.keyValueDelimiter + annotations[i].getIdentifier());
                }
                ++i;
            }
        }
        return res.toString();
    }
}

