/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.clustering.distances;

import de.jstacs.clustering.distances.DeBruijnMotifComparison;
import de.jstacs.clustering.distances.DistanceMetric;
import de.jstacs.data.DeBruijnGraphSequenceGenerator;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.CyclicSequenceAdaptor;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.sequenceScores.statisticalModels.StatisticalModel;
import de.jstacs.utils.Pair;
import de.jstacs.utils.RealTime;
import java.util.LinkedList;

public class SequenceScoreDistance
extends DistanceMetric<StatisticalModel> {
    protected CyclicSequenceAdaptor[] seqs;
    protected boolean exp;

    public SequenceScoreDistance(DiscreteAlphabet alphabet, int n, boolean exp) throws WrongAlphabetException, WrongSequenceTypeException {
        this(DeBruijnGraphSequenceGenerator.generate(alphabet, n), exp);
    }

    protected SequenceScoreDistance(CyclicSequenceAdaptor[] seqs, boolean exp) {
        this.seqs = seqs;
        this.exp = exp;
    }

    public double[][] getProfile(StatisticalModel o, boolean rc) throws Exception {
        return DeBruijnMotifComparison.getProfilesForMotif(this.seqs, o, rc, this.exp);
    }

    public double getDistance(double[][] profiles1, double[][] profiles1Rc, double[][] profiles2, int maxShift) throws Exception {
        Pair<Integer, Double> newFwd = DeBruijnMotifComparison.compare(profiles1[0], profiles2[0], maxShift);
        Pair<Integer, Double> newRc = DeBruijnMotifComparison.compare(profiles1Rc[0], profiles2[0], maxShift);
        return 1.0 - Math.max(newFwd.getSecondElement(), newRc.getSecondElement());
    }

    public double getDistance(double[][] profiles1, double[][] profiles1Rc, StatisticalModel o2, int motif1Length) throws Exception {
        int maxShift = (int)Math.ceil((double)Math.min(o2.getLength(), motif1Length) * 2.0 / 3.0);
        double[][] profiles2 = this.getProfile(o2, false);
        return this.getDistance(profiles1, profiles1Rc, profiles2, maxShift);
    }

    @Override
    public double getDistance(StatisticalModel o1, StatisticalModel o2) throws Exception {
        int motif1Length = o1.getLength();
        double[][] profiles1 = this.getProfile(o1, false);
        double[][] profiles1Rc = this.getProfile(o1, true);
        return this.getDistance(profiles1, profiles1Rc, o2, motif1Length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] getPairwiseDistanceMatrix(int numThreads, StatisticalModel ... objects) throws Exception {
        Object prof1;
        if (numThreads == 1) {
            double[][] matrix = new double[objects.length][];
            int i = 0;
            while (i < matrix.length) {
                matrix[i] = new double[i];
                double[][] prof12 = this.getProfile(objects[i], false);
                double[][] prof1Rc = this.getProfile(objects[i], true);
                SequenceScoreDistance.fillDistanceRow(i, matrix[i], prof12, prof1Rc, this, objects);
                ++i;
            }
            return matrix;
        }
        LinkedList<Worker> available = new LinkedList<Worker>();
        Worker[] workers = new Worker[numThreads - 1];
        int i = 0;
        while (i < workers.length) {
            workers[i] = new Worker(objects, available, i);
            available.add(workers[i]);
            new Thread(workers[i]).start();
            ++i;
        }
        RealTime rt = new RealTime();
        double[][] matrix = new double[objects.length][];
        int i2 = 0;
        while (i2 < matrix.length) {
            System.out.println("main in row " + i2 + " " + rt.getElapsedTime());
            matrix[i2] = new double[i2];
            prof1 = null;
            double[][] prof1Rc = null;
            int length = 0;
            StatisticalModel statisticalModel = objects[i2];
            synchronized (statisticalModel) {
                prof1 = this.getProfile(objects[i2], false);
                length = objects[i2].getLength();
                prof1Rc = this.getProfile(objects[i2], true);
            }
            int a = 0;
            while (a == 0) {
                Object object = available;
                synchronized (object) {
                    a = available.size();
                }
                if (a != 0) continue;
                object = this;
                synchronized (object) {
                    this.wait(1000L);
                }
            }
            Worker curr = null;
            LinkedList<Worker> linkedList = available;
            synchronized (linkedList) {
                curr = (Worker)available.pop();
            }
            curr.setRow(matrix[i2], (double[][])prof1, prof1Rc, length);
            ++i2;
        }
        int a = 0;
        while (a < workers.length) {
            prof1 = available;
            synchronized (prof1) {
                a = available.size();
            }
            if (a != workers.length) continue;
            prof1 = this;
            synchronized (prof1) {
                this.wait(100L);
            }
        }
        int i3 = 0;
        while (i3 < workers.length) {
            workers[i3].stop();
            ++i3;
        }
        return matrix;
    }

    private static void fillDistanceRow(int i, double[] row, double[][] prof1, double[][] prof1Rc, SequenceScoreDistance metric, StatisticalModel ... objects) throws Exception {
        int j = 0;
        while (j < i) {
            row[j] = metric.getDistance(prof1, prof1Rc, objects[j], objects[i].getLength());
            ++j;
        }
    }

    private class Worker
    implements Runnable {
        private int index;
        private boolean stop;
        private double[] row;
        private double[][] prof1;
        private double[][] prof1Rc;
        private SequenceScoreDistance metric;
        private StatisticalModel[] objects;
        private LinkedList<Worker> available;
        private int length;

        private Worker(StatisticalModel[] objects, LinkedList<Worker> available, int index) {
            this.objects = objects;
            this.metric = SequenceScoreDistance.this;
            this.available = available;
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setRow(double[] row, double[][] prof1, double[][] prof1Rc, int length) {
            Worker worker = this;
            synchronized (worker) {
                this.row = row;
                this.prof1 = prof1;
                this.prof1Rc = prof1Rc;
                this.length = length;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            this.stop = true;
            Worker worker = this;
            synchronized (worker) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = this;
            synchronized (var1_1) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (true) ** GOTO lbl50
            }
            do {
                if (this.row == null) continue;
                try {
                    this.fillDistanceRow();
                    var1_1 = this;
                    synchronized (var1_1) {
                        this.row = null;
                        e = this.available;
                        synchronized (e) {
                            this.available.add(this);
                        }
                        e = this.metric;
                        synchronized (e) {
                            this.metric.notify();
                        }
                        if (this.stop) {
                            return;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.stop = true;
                    throw new RuntimeException();
                }
lbl50:
                // 4 sources

            } while (!this.stop);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillDistanceRow() throws Exception {
            int j = 0;
            while (j < this.row.length) {
                StatisticalModel statisticalModel = this.objects[j];
                synchronized (statisticalModel) {
                    this.row[j] = this.metric.getDistance(this.prof1, this.prof1Rc, this.objects[j], this.length);
                }
                ++j;
            }
        }
    }
}

