/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class OboParser {
    private HashMap<String, GONode> map;

    public OboParser(String filename) throws IOException {
        BufferedReader read = new BufferedReader(new FileReader(filename));
        String str = null;
        String go = null;
        String name = null;
        this.map = new HashMap();
        LinkedList<GONode> isas = new LinkedList<GONode>();
        while ((str = read.readLine()) != null) {
            if ((str = str.trim()).length() == 0) {
                if (go != null && go.startsWith("GO:")) {
                    if (this.map.containsKey(go)) {
                        this.map.get(go).setName(name);
                        this.map.get(go).setParents(isas.toArray(new GONode[0]));
                    } else {
                        this.map.put(go, new GONode(go, name, isas.toArray(new GONode[0])));
                    }
                }
                go = null;
                name = null;
                isas.clear();
                continue;
            }
            if (str.startsWith("id:")) {
                go = str.substring(4);
                continue;
            }
            if (str.startsWith("name:")) {
                name = str.substring(6);
                continue;
            }
            if (str.startsWith("is_a:")) {
                String temp = str.substring(6);
                if (this.map.containsKey(temp = temp.substring(0, temp.indexOf(32)))) {
                    isas.add(this.map.get(temp));
                    continue;
                }
                GONode node = new GONode(temp);
                isas.add(node);
                this.map.put(temp, node);
                continue;
            }
            if (!str.startsWith("is_obsolete: true")) continue;
            go = null;
            name = null;
            isas.clear();
        }
        read.close();
        Iterator<String> it = this.map.keySet().iterator();
        int i = 1;
        while (it.hasNext()) {
            GONode node = this.map.get(it.next());
            if (!node.isRoot()) continue;
            System.out.println(node.go);
            node.propagateIds(String.valueOf(i), String.valueOf(i));
            ++i;
        }
    }

    public GONode getNodeFor(String string) {
        return this.map.get(string);
    }

    public static class GONode {
        private final String go;
        private String name;
        private HashSet<String> ids;
        private GONode[] parents;
        private HashSet<GONode> children;
        private LinkedList<String> lastIdPart;

        public GONode(String go) {
            this.go = go;
            this.children = new HashSet();
            this.ids = new HashSet();
            this.lastIdPart = new LinkedList();
        }

        public GONode(String go, String name, GONode[] parents) {
            this(go);
            this.name = name;
            this.setParents(parents);
        }

        public String toString() {
            return String.valueOf(this.go) + "\n" + this.name + "\n" + Arrays.toString(this.ids.toArray(new String[0]));
        }

        public String getGO() {
            return this.go;
        }

        public String[] getHierarchyNames() {
            if (this.parents == null || this.parents.length == 0) {
                if (this.name == null) {
                    System.out.println("null: " + this.go);
                }
                return new String[]{this.name};
            }
            LinkedList<String> names = new LinkedList<String>();
            int i = 0;
            while (i < this.parents.length) {
                String[] par = this.parents[i].getHierarchyNames();
                int j = 0;
                while (j < par.length) {
                    names.add(String.valueOf(par[j]) + "." + this.name);
                    ++j;
                }
                ++i;
            }
            return names.toArray(new String[0]);
        }

        public void propagateIds(String id, String last) {
            this.lastIdPart.add(last);
            this.ids.add(id);
            Iterator<GONode> it = this.children.iterator();
            int i = 1;
            while (it.hasNext()) {
                GONode curr = it.next();
                curr.propagateIds(String.valueOf(id) + "." + i, String.valueOf(i));
                ++i;
            }
        }

        public LinkedList<String> getLastIDPart() {
            return this.lastIdPart;
        }

        public String[] getIDs() {
            return this.ids.toArray(new String[0]);
        }

        public String[] getMajorIDAndName() {
            String[][] ids = new String[this.ids.size()][];
            Iterator<String> it = this.ids.iterator();
            int i = 0;
            while (it.hasNext()) {
                String curr = it.next();
                String[] parts = curr.split("\\.");
                ids[i] = parts;
                ++i;
            }
            String[] dom = GONode.findDominant(ids, 0);
            String ret = dom[0];
            i = 1;
            while (i < dom.length) {
                ret = String.valueOf(ret) + "." + dom[i];
                ++i;
            }
            int lv = dom.length - 1;
            String name = this.getNameFor(dom, lv);
            return new String[]{ret, name};
        }

        public String getNameFor(String[] dom, int lv) {
            String name = this.name;
            if (lv <= 0 || this.parents == null || this.parents.length == 0) {
                return name;
            }
            String partDom = dom[0];
            int i = 1;
            while (i < lv) {
                partDom = String.valueOf(partDom) + "." + dom[i];
                ++i;
            }
            i = 0;
            while (i < this.parents.length) {
                if (this.parents[i].ids.contains(partDom)) {
                    return String.valueOf(this.parents[i].getNameFor(dom, lv - 1)) + "." + name;
                }
                ++i;
            }
            throw new RuntimeException(String.valueOf(dom[lv - 1]) + " " + lv + " " + Arrays.toString(dom) + " <-> " + this.ids + " " + partDom);
        }

        private static String[] findDominant(String[][] ids2, int level) {
            HashMap<String, Integer> counters = new HashMap<String, Integer>();
            int max = 0;
            int i = 0;
            while (i < ids2.length) {
                if (level < ids2[i].length) {
                    if (counters.containsKey(ids2[i][level])) {
                        counters.put(ids2[i][level], (Integer)counters.get(ids2[i][level]) + 1);
                    } else {
                        counters.put(ids2[i][level], 1);
                    }
                    if ((Integer)counters.get(ids2[i][level]) > max) {
                        max = (Integer)counters.get(ids2[i][level]);
                    }
                }
                ++i;
            }
            if (counters.size() == 0) {
                return new String[0];
            }
            Iterator it = counters.keySet().iterator();
            String best = null;
            while (it.hasNext()) {
                String key = (String)it.next();
                if ((Integer)counters.get(key) != max) continue;
                best = key;
                break;
            }
            LinkedList<String[]> lili = new LinkedList<String[]>();
            int i2 = 0;
            while (i2 < ids2.length) {
                if (level < ids2[i2].length && best.equals(ids2[i2][level])) {
                    lili.add(ids2[i2]);
                }
                ++i2;
            }
            String[] temp = GONode.findDominant((String[][])lili.toArray((T[])new String[0][0]), level + 1);
            String[] next = new String[temp.length + 1];
            next[0] = best;
            System.arraycopy(temp, 0, next, 1, temp.length);
            return next;
        }

        public boolean isRoot() {
            return this.parents == null || this.parents.length == 0;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public GONode[] getParents() {
            return this.parents;
        }

        public void setParents(GONode[] parents) {
            this.parents = parents;
            if (parents != null) {
                int i = 0;
                while (i < this.parents.length) {
                    this.parents[i].addChild(this);
                    ++i;
                }
            }
        }

        private void addChild(GONode goNode) {
            this.children.add(goNode);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.go == null ? 0 : this.go.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GONode other = (GONode)obj;
            return !(this.go == null ? other.go != null : !this.go.equals(other.go));
        }
    }
}

