/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.MultiDimensionalSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.ArrayHandler;

public class MultiDimensionalArbitrarySequence
extends MultiDimensionalSequence<double[]> {
    public MultiDimensionalArbitrarySequence(SequenceAnnotation[] seqAn, ArbitrarySequence ... sequence) throws WrongLengthException, WrongAlphabetException {
        super(seqAn, sequence);
    }

    @Override
    public void fillContainer(double[] container, int pos) {
        int s = 0;
        while (s < this.content.length) {
            container[s] = this.content[s].continuousVal(pos);
            ++s;
        }
    }

    @Override
    public double[] getEmptyContainer() {
        return new double[this.content.length];
    }

    protected MultiDimensionalArbitrarySequence getInstance(SequenceAnnotation[] seqAn, Sequence ... seqs) throws WrongLengthException, WrongAlphabetException {
        return new MultiDimensionalArbitrarySequence(seqAn, ArrayHandler.cast(ArbitrarySequence.class, seqs));
    }

    @Override
    public int compareTo(double[] t1, double[] t2) {
        if (t1.length == t2.length) {
            int i = 0;
            while (i < t1.length) {
                if (t1[i] != t2[i]) {
                    return (int)Math.signum(t1[i] - t2[i]);
                }
                ++i;
            }
            return 0;
        }
        return t1.length - t2.length;
    }
}

