/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels;

import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.NotTrainedException;
import de.jstacs.algorithms.graphs.TopSort;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.ParameterSetParser;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BNDiffSMParameter;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BNDiffSMParameterTree;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.FixedStructure;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.Measure;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class BayesianNetworkDiffSM
extends AbstractDifferentiableStatisticalModel
implements InstantiableFromParameterSet {
    protected BNDiffSMParameter[] parameters;
    protected BNDiffSMParameterTree[] trees;
    protected boolean isTrained;
    protected double ess;
    protected Integer numFreePars;
    protected int[] nums;
    protected Measure structureMeasure;
    protected boolean plugInParameters;
    protected int[][] order;
    protected Double logNormalizationConstant;
    private int[] roots;
    private boolean freeParams;
    private Double gammaNorm;
    private BayesianNetworkDiffSMParameterSet parameterSet;

    public BayesianNetworkDiffSM(AlphabetContainer alphabet, int length, double ess, boolean plugInParameters, Measure structureMeasure) throws Exception {
        super(alphabet, length);
        if (!alphabet.isDiscrete()) {
            throw new Exception("Only defined on discrete alphabets.");
        }
        if (length <= 0) {
            throw new Exception("Inconsistent length (" + length + ").");
        }
        this.isTrained = false;
        this.ess = ess;
        this.plugInParameters = plugInParameters;
        this.structureMeasure = structureMeasure;
        this.logNormalizationConstant = null;
    }

    public BayesianNetworkDiffSM(BayesianNetworkDiffSMParameterSet parameters) throws ParameterSetParser.NotInstantiableException, Exception {
        this(parameters.getAlphabetContainer(), parameters.getLength(), parameters.getEss(), parameters.getPlugInParameters(), parameters.getMeasure());
        this.parameterSet = parameters;
    }

    public BayesianNetworkDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.logNormalizationConstant = null;
        this.gammaNorm = null;
    }

    @Override
    public BayesianNetworkDiffSM clone() throws CloneNotSupportedException {
        BayesianNetworkDiffSM clone = (BayesianNetworkDiffSM)super.clone();
        if (this.trees != null) {
            clone.trees = new BNDiffSMParameterTree[this.trees.length];
            int i = 0;
            while (i < this.trees.length) {
                clone.trees[i] = this.trees[i].clone();
                ++i;
            }
            LinkedList[] parTemp = new LinkedList[this.trees.length];
            int num = 0;
            int i2 = 0;
            while (i2 < clone.trees.length) {
                parTemp[i2] = clone.trees[i2].linearizeParameters();
                num += parTemp[i2].size();
                ++i2;
            }
            clone.parameters = new BNDiffSMParameter[num];
            num = 0;
            Iterator it = null;
            int i3 = 0;
            while (i3 < parTemp.length) {
                it = parTemp[i3].iterator();
                while (it.hasNext()) {
                    clone.parameters[num++] = (BNDiffSMParameter)it.next();
                }
                ++i3;
            }
            clone.nums = (int[])this.nums.clone();
        } else {
            clone.trees = null;
            clone.nums = null;
            clone.parameters = null;
        }
        clone.structureMeasure = this.structureMeasure.clone();
        clone.logNormalizationConstant = null;
        return clone;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        if (this.logNormalizationConstant == null) {
            this.precomputeNormalization();
        }
        if (parameterIndex < this.nums.length) {
            BNDiffSMParameter p = this.parameters[this.nums[parameterIndex]];
            int pos = p.getPosition();
            boolean[] notRoot = new boolean[this.trees.length];
            int i = 0;
            while (i < this.trees.length) {
                if (this.trees[i].getNumberOfParents() > 0) {
                    notRoot[i] = true;
                }
                ++i;
            }
            double val = p.getLogPartialNormalizer();
            int i2 = 0;
            while (i2 < notRoot.length) {
                if (!notRoot[i2] && i2 != this.roots[pos]) {
                    val += this.trees[i2].forward(this.trees);
                }
                ++i2;
            }
            return val;
        }
        throw new Exception("BNDiffSMParameter index out of bounds");
    }

    private int[][] getFirstChildrenAndFirstParents(int[][] parents) throws Exception {
        int j;
        LinkedList[] fc = new LinkedList[parents.length];
        boolean test = false;
        int i = 0;
        while (i < fc.length) {
            fc[i++] = new LinkedList();
        }
        int[][] erg = new int[parents.length + 1][];
        erg[parents.length] = new int[parents.length];
        Arrays.fill(erg[parents.length], -1);
        int i2 = 0;
        while (i2 < parents.length) {
            test = parents[i2].length < 2;
            j = 0;
            while (j < parents[i2].length - 1) {
                if (this.testInclude(parents[i2], parents[parents[i2][j]])) {
                    fc[parents[i2][j]].add(i2);
                    erg[parents.length][i2] = parents[i2][j];
                    test = true;
                }
                ++j;
            }
            if (!test) {
                throw new Exception("Structure is no moral graph!");
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < fc.length) {
            erg[i2] = new int[fc[i2].size()];
            j = 0;
            while (j < erg[i2].length) {
                erg[i2][j] = (Integer)fc[i2].poll();
                ++j;
            }
            ++i2;
        }
        return erg;
    }

    private boolean testInclude(int[] parentsOfChild, int[] parentsOfParent) {
        int i = 0;
        while (i < parentsOfChild.length - 1) {
            boolean found = false;
            int j = 0;
            while (j < parentsOfParent.length) {
                if (parentsOfChild[i] == parentsOfParent[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        if (data[index] != null && data[index].getElementLength() != this.length) {
            throw new Exception("Data has wrong length.");
        }
        this.freeParams = freeParams;
        if (weights == null) {
            weights = new double[data.length][];
            int i = 0;
            while (i < data.length) {
                weights[i] = new double[data[i].getNumberOfElements()];
                Arrays.fill(weights[i], 1.0);
                ++i;
            }
        }
        DataSet[] data2 = data;
        Object weights2 = weights;
        if (data.length != 2) {
            data2 = new DataSet[2];
            weights2 = new double[2][];
            data2[0] = data[index];
            weights2[0] = weights[index];
            boolean[] in = new boolean[data.length];
            Arrays.fill(in, true);
            in[index] = false;
            data2[1] = DataSet.union(data, in);
            if (data2[1] != null) {
                weights2[1] = new double[data2[1].getNumberOfElements()];
                int off = 0;
                int i = 0;
                while (i < ((double[][])weights).length) {
                    if (in[i]) {
                        System.arraycopy(weights[i], 0, weights2[1], off, weights[i].length);
                        off += weights[i].length;
                    }
                    ++i;
                }
            } else {
                weights2[1] = null;
            }
        }
        this.createTrees(data2, (double[][])weights2);
        if (this.plugInParameters) {
            this.setPlugInParameters(index, freeParams, data, (double[][])weights);
        } else {
            int i = 0;
            while (i < this.parameters.length) {
                if (freeParams) {
                    this.parameters[i].setValue(0.0);
                } else {
                    this.parameters[i].setValue(-Math.log(this.alphabets.getAlphabetLengthAt(this.parameters[i].position)));
                }
                ++i;
            }
        }
        this.isTrained = true;
        this.logNormalizationConstant = null;
    }

    protected void createTrees(DataSet[] data2, double[][] weights2) throws Exception {
        int[][] parents = this.structureMeasure.getParents(data2[0], data2[1], weights2[0], weights2[1], this.getLength());
        this.order = TopSort.getTopologicalOrder(parents);
        int[][] firstChildrenAndFirstParents = this.getFirstChildrenAndFirstParents(parents);
        this.numFreePars = 0;
        int numPars = 0;
        int[] numContextsPos = new int[this.getLength()];
        this.trees = new BNDiffSMParameterTree[this.getLength()];
        int numContexts = 0;
        int[] contextPoss = null;
        int i = 0;
        while (i < parents.length) {
            numContextsPos[i] = 1;
            int j = 0;
            while (j < parents[i].length - 1) {
                int n = i;
                numContextsPos[n] = (int)((double)numContextsPos[n] * this.alphabets.getAlphabetLengthAt(parents[i][j]));
                ++j;
            }
            this.numFreePars = this.numFreePars + numContextsPos[i] * ((int)this.getAlphabetContainer().getAlphabetLengthAt(i) - 1);
            numPars = (int)((double)numPars + (double)numContextsPos[i] * this.getAlphabetContainer().getAlphabetLengthAt(i));
            numContexts += numContextsPos[i];
            contextPoss = new int[parents[i].length - 1];
            j = 0;
            while (j < contextPoss.length) {
                contextPoss[j] = parents[i][parents[i].length - j - 2];
                ++j;
            }
            this.trees[i] = new BNDiffSMParameterTree(i, contextPoss, this.getAlphabetContainer(), firstChildrenAndFirstParents[parents.length][i], firstChildrenAndFirstParents[i]);
            ++i;
        }
        this.parameters = new BNDiffSMParameter[numPars];
        if (!this.freeParams) {
            this.numFreePars = numPars;
        }
        this.nums = new int[this.numFreePars.intValue()];
        int curr = 0;
        int free = 0;
        int[][][][] contexts = new int[this.getLength()][][][];
        int i2 = 0;
        while (i2 < parents.length) {
            contexts[i2] = new int[numContextsPos[i2]][parents[i2].length - 1][];
            this.fillContexts(0, contexts[i2], 0, parents[i2]);
            int j = 0;
            while (j < contexts[i2].length) {
                int all = 1;
                int act = 1;
                int k = 0;
                while (k < contexts[i2][j].length) {
                    all = (int)((double)all * this.getAlphabetContainer().getAlphabetLengthAt(contexts[i2][j][k][0]));
                    act *= contexts[i2][j][k].length - 1;
                    ++k;
                }
                byte a = 0;
                while ((double)a < this.getAlphabetContainer().getAlphabetLengthAt(i2)) {
                    this.parameters[curr] = (double)a < this.getAlphabetContainer().getAlphabetLengthAt(i2) - 1.0 || !this.freeParams ? new BNDiffSMParameter(free, a, i2, contexts[i2][j], (double)act * this.ess / ((double)all * this.getAlphabetContainer().getAlphabetLengthAt(i2)), true) : new BNDiffSMParameter(-1, a, i2, contexts[i2][j], (double)act * this.ess / ((double)all * this.getAlphabetContainer().getAlphabetLengthAt(i2)), false);
                    this.trees[i2].setParameterFor(a, contexts[i2][j], this.parameters[curr]);
                    if (this.parameters[curr].isFree()) {
                        this.nums[free++] = curr;
                    }
                    ++curr;
                    a = (byte)(a + 1);
                }
                ++j;
            }
            ++i2;
        }
        this.roots = new int[this.trees.length];
        i2 = 0;
        while (i2 < this.trees.length) {
            int fp = i2;
            while (this.trees[fp].getFirstParent() != -1) {
                fp = this.trees[fp].getFirstParent();
            }
            this.roots[i2] = fp;
            ++i2;
        }
        this.logNormalizationConstant = null;
        this.gammaNorm = null;
    }

    protected void setPlugInParameters(int index, boolean freeParameters, DataSet[] data, double[][] weights) {
        if (data[index] != null) {
            int i = 0;
            while (i < data[index].getNumberOfElements()) {
                int j = 0;
                while (j < this.trees.length) {
                    this.trees[j].addCount(data[index].getElementAt(i), 0, weights[index][i]);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.trees.length) {
                this.trees[i].normalizePlugInParameters();
                if (freeParameters) {
                    this.trees[i].divideByUnfree();
                }
                ++i;
            }
        }
    }

    private int fillContexts(int offset, int[][][] contexts, int depth, int[] parents) {
        int tempOffset = offset;
        if (depth < parents.length - 1) {
            int i = 0;
            while ((double)i < this.alphabets.getAlphabetLengthAt(parents[parents.length - depth - 2])) {
                offset = tempOffset;
                tempOffset = this.fillContexts(offset, contexts, depth + 1, parents);
                int j = offset;
                while (j < tempOffset) {
                    contexts[j][depth] = new int[]{parents[parents.length - depth - 2], i};
                    ++j;
                }
                ++i;
            }
            return tempOffset;
        }
        return offset + 1;
    }

    @Override
    protected void fromXML(StringBuffer source) throws NonParsableException {
        source = XMLParser.extractForTag(source, "bayesianNetworkSF");
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(source, "alphabets");
        this.length = XMLParser.extractObjectForTags(source, "length", Integer.TYPE);
        this.trees = XMLParser.extractObjectForTags(source, "trees", BNDiffSMParameterTree[].class);
        if (this.trees.length == 0) {
            this.trees = null;
            this.parameters = null;
        } else {
            LinkedList[] parTemp = new LinkedList[this.trees.length];
            int num = 0;
            int i = 0;
            while (i < this.trees.length) {
                this.trees[i].setAlphabet(this.alphabets);
                parTemp[i] = this.trees[i].linearizeParameters();
                num += parTemp[i].size();
                ++i;
            }
            this.parameters = new BNDiffSMParameter[num];
            num = 0;
            Iterator it = null;
            int i2 = 0;
            while (i2 < parTemp.length) {
                it = parTemp[i2].iterator();
                while (it.hasNext()) {
                    this.parameters[num++] = (BNDiffSMParameter)it.next();
                }
                ++i2;
            }
        }
        this.isTrained = XMLParser.extractObjectForTags(source, "isTrained", Boolean.TYPE);
        this.ess = XMLParser.extractObjectForTags(source, "ess", Double.TYPE);
        this.numFreePars = XMLParser.extractObjectForTags(source, "numFreePars", Integer.class);
        this.nums = XMLParser.extractObjectForTags(source, "nums", int[].class);
        if (this.nums.length == 0) {
            this.nums = null;
        }
        this.structureMeasure = XMLParser.extractObjectForTags(source, "structureMeasure", Measure.class);
        this.order = XMLParser.extractObjectForTags(source, "order", int[][].class);
        if (this.order.length == 0) {
            this.order = null;
        }
        this.plugInParameters = XMLParser.extractObjectForTags(source, "plugInParameters", Boolean.TYPE);
        this.roots = XMLParser.extractObjectForTags(source, "roots", int[].class);
        if (this.roots.length == 0) {
            this.roots = null;
        }
        this.freeParams = XMLParser.extractObjectForTags(source, "freeParams", Boolean.TYPE);
    }

    @Override
    public String toString(NumberFormat nf) {
        if (this.trees != null) {
            if (this.logNormalizationConstant == null) {
                this.precomputeNormalization();
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.trees.length) {
                buf.append(this.trees[i].toString(nf));
                buf.append("\n");
                ++i;
            }
            return buf.toString();
        }
        return String.valueOf(this.getClass().getSimpleName()) + " of length " + this.length + ": not initialized";
    }

    @Override
    public String getInstanceName() {
        return this.structureMeasure.getInstanceName();
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        double prob = 0.0;
        int i = 0;
        while (i < this.trees.length) {
            prob += this.trees[i].getParameterFor(seq, start).getValue();
            ++i;
        }
        return prob;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double logScore = 0.0;
        int i = 0;
        while (i < this.trees.length) {
            BNDiffSMParameter par = this.trees[i].getParameterFor(seq, start);
            if (par.isFree()) {
                indices.add(par.getIndex());
                partialDer.add(1.0);
            }
            logScore += par.getValue();
            ++i;
        }
        return logScore;
    }

    @Override
    public double getLogNormalizationConstant() throws RuntimeException {
        if (this.logNormalizationConstant == null) {
            this.precomputeNormalization();
        }
        return this.logNormalizationConstant;
    }

    @Override
    public int getNumberOfParameters() {
        if (this.nums == null) {
            return -1;
        }
        return this.nums.length;
    }

    @Override
    public void setParameters(double[] params, int start) {
        int i = 0;
        while (i < this.nums.length) {
            this.parameters[this.nums[i]].setValue(params[i + start]);
            ++i;
        }
        this.logNormalizationConstant = null;
    }

    protected void precomputeNormalization() {
        boolean[] notRoot = new boolean[this.trees.length];
        int i = 0;
        while (i < this.trees.length) {
            this.trees[i].invalidateNormalizers();
            ++i;
        }
        i = 0;
        while (i < this.trees.length) {
            if (this.trees[i].getNumberOfParents() > 0) {
                notRoot[i] = true;
            }
            if (this.trees[i].isLeaf()) {
                this.trees[i].backward(this.trees, this.order);
            }
            ++i;
        }
        double val = 0.0;
        int i2 = 0;
        while (i2 < notRoot.length) {
            if (!notRoot[i2]) {
                val += this.trees[i2].forward(this.trees);
            }
            ++i2;
        }
        this.logNormalizationConstant = val;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        double[] pars = new double[this.nums.length];
        int i = 0;
        while (i < pars.length) {
            pars[i] = this.parameters[this.nums[i]].getValue();
            ++i;
        }
        return pars;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer source = new StringBuffer();
        XMLParser.appendObjectWithTags(source, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(source, this.length, "length");
        XMLParser.appendObjectWithTags(source, this.trees, "trees");
        XMLParser.appendObjectWithTags(source, this.isTrained, "isTrained");
        XMLParser.appendObjectWithTags(source, this.ess, "ess");
        XMLParser.appendObjectWithTags(source, this.numFreePars, "numFreePars");
        if (this.nums == null) {
            XMLParser.appendObjectWithTags(source, new int[0], "nums");
        } else {
            XMLParser.appendObjectWithTags(source, this.nums, "nums");
        }
        XMLParser.appendObjectWithTags(source, this.structureMeasure, "structureMeasure");
        XMLParser.appendObjectWithTags(source, this.plugInParameters, "plugInParameters");
        if (this.order == null) {
            XMLParser.appendObjectWithTags(source, new int[0][0], "order");
        } else {
            XMLParser.appendObjectWithTags(source, this.order, "order");
        }
        if (this.roots == null) {
            XMLParser.appendObjectWithTags(source, new int[0], "roots");
        } else {
            XMLParser.appendObjectWithTags(source, this.roots, "roots");
        }
        XMLParser.appendObjectWithTags(source, this.freeParams, "freeParams");
        XMLParser.addTags(source, "bayesianNetworkSF");
        return source;
    }

    @Override
    public double getLogPriorTerm() {
        if (this.gammaNorm == null) {
            this.computeGammaNorm();
        }
        double val = 0.0;
        int i = 0;
        while (i < this.nums.length) {
            val += this.parameters[this.nums[i]].getValue() * this.parameters[this.nums[i]].getPseudoCount();
            ++i;
        }
        return val + this.gammaNorm;
    }

    private void computeGammaNorm() {
        this.gammaNorm = 0.0;
        int i = 0;
        while (i < this.trees.length) {
            this.gammaNorm = this.gammaNorm + this.trees[i].computeGammaNorm();
            ++i;
        }
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) {
        int i = 0;
        while (i < this.nums.length) {
            int n = i + start;
            grad[n] = grad[n] + this.parameters[this.nums[i]].getPseudoCount();
            ++i;
        }
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    public int getPositionForParameter(int index) {
        return this.parameters[this.nums[index]].getPosition();
    }

    public double[] getPositionDependentKMerProb(Sequence kmer) throws Exception {
        if (!(this.structureMeasure instanceof InhomogeneousMarkov)) {
            throw new Exception("Only implemented for IMMs");
        }
        this.precomputeNormalization();
        int i = 0;
        while (i < this.trees.length) {
            this.trees[i].normalizeParameters();
            ++i;
        }
        this.precomputeNormalization();
        double[] prof = new double[this.trees.length - kmer.getLength() + 1];
        Arrays.fill(prof, 1.0);
        int i2 = 0;
        while (i2 < this.trees.length - kmer.getLength() + 1) {
            int n = i2;
            prof[n] = prof[n] * this.trees[i2 + kmer.getLength() - 1].getProbFor(kmer);
            ++i2;
        }
        return prof;
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        BNDiffSMParameter par = this.parameters[this.nums[index]];
        int size = (int)this.alphabets.getAlphabetLengthAt(par.getPosition());
        int[][] cont = par.context;
        int i = 0;
        while (i < cont.length) {
            size = (int)((double)size * this.alphabets.getAlphabetLengthAt(cont[i][0]));
            ++i;
        }
        return size;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        if (!(this.structureMeasure instanceof InhomogeneousMarkov) && !(this.structureMeasure instanceof FixedStructure)) {
            throw new Exception("Not implemented");
        }
        this.freeParams = freeParams;
        boolean temp = this.plugInParameters;
        this.plugInParameters = false;
        this.initializeFunction(0, freeParams, new DataSet[2], new double[2][]);
        this.plugInParameters = temp;
        int i = 0;
        while (i < this.trees.length) {
            this.trees[i].initializeRandomly(this.ess);
            ++i;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.trees != null;
    }

    public double[][] getPWM() throws Exception {
        if (this.logNormalizationConstant == null) {
            this.precomputeNormalization();
        }
        double[][] pwm = new double[this.trees.length][];
        int i = 0;
        while (i < this.trees.length) {
            pwm[i] = new double[(int)this.alphabets.getAlphabetLengthAt(i)];
            this.trees[i].insertProbs(pwm[i]);
            ++i;
        }
        return pwm;
    }

    @Override
    public byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        byte max = 0;
        byte temp = 0;
        int i = 0;
        while (i < this.trees.length) {
            temp = this.trees[i].getMaximalMarkovOrder();
            if (temp > max) {
                max = temp;
            }
            ++i;
        }
        return max;
    }

    public double getMaximumScore() throws Exception {
        if (this.getMaximalMarkovOrder() > 0) {
            throw new Exception();
        }
        if (this.logNormalizationConstant == null) {
            this.precomputeNormalization();
        }
        double score = 0.0;
        int i = 0;
        while (i < this.trees.length) {
            score += this.trees[i].getMaximumScore();
            ++i;
        }
        return score;
    }

    public InstanceParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameterSet != null) {
            return this.parameterSet;
        }
        return new BayesianNetworkDiffSMParameterSet(this.getAlphabetContainer(), this.getLength(), this.ess, this.plugInParameters, this.structureMeasure);
    }

    @Override
    public DataSet emitDataSet(int numberOfSequences, int ... seqLength) throws NotTrainedException, Exception {
        if (seqLength != null && seqLength.length > 0) {
            throw new IllegalArgumentException("You cannot set sequence lengths for a model of a fixed length of " + this.length + ".");
        }
        if (!this.isInitialized()) {
            throw new NotTrainedException();
        }
        this.precomputeNormalization();
        Sequence[] seqs = new IntSequence[numberOfSequences];
        int i = 0;
        while (i < numberOfSequences) {
            int[] content = new int[this.length];
            int j = 0;
            while (j < this.order.length) {
                this.trees[this.order[j][0]].emitSymbol(content);
                ++j;
            }
            seqs[i] = new IntSequence(this.alphabets, content);
            ++i;
        }
        return new DataSet("", seqs);
    }

    public String toHtml(NumberFormat nf) {
        if (this.trees != null) {
            if (this.logNormalizationConstant == null) {
                this.precomputeNormalization();
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.trees.length) {
                buf.append(this.trees[i].toHtml(nf));
                ++i;
            }
            return buf.toString();
        }
        return String.valueOf(this.getClass().getSimpleName()) + " of length " + this.length + ": not initialized";
    }
}

