/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.BasicHigherOrderTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.DifferentiableTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.SamplingTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.elements.TransitionElement;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.TreeMap;

public class HigherOrderTransition
extends BasicHigherOrderTransition
implements DifferentiableTransition,
SamplingTransition {
    private static final String PREFIX = "samplingHOTransition-";
    private int offset;
    protected File[] paramsFile;
    protected int[] counter;
    protected int samplingIndex;
    protected BufferedWriter writer;
    protected BufferedReader reader;
    private double[] params;
    private static final String XML_TAG = "HigherOrderTransition";

    public HigherOrderTransition(boolean[] isSilent, TransitionElement ... transitions) throws Exception {
        super(isSilent, transitions);
        this.init();
    }

    public HigherOrderTransition(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.setParameterOffset();
    }

    private void init() {
        int n = 0;
        int t = 0;
        while (t < this.transitions.length) {
            n += this.transitions[t].getNumberOfParameters();
            ++t;
        }
        this.params = new double[n];
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }

    @Override
    protected void appendFurtherInformation(StringBuffer xml) {
        if (this.writer != null) {
            throw new RuntimeException("could not parse the model to XML while sampling");
        }
        XMLParser.appendObjectWithTags(xml, this.offset, "offset");
        if (this.paramsFile != null) {
            try {
                XMLParser.appendObjectWithTags(xml, this.counter, "counter");
                int i = 0;
                while (i < this.paramsFile.length) {
                    String content = this.paramsFile[i] != null ? FileManager.readFile(this.paramsFile[i]).toString() : "";
                    XMLParser.appendObjectWithTagsAndAttributes(xml, content, "fileContent", "pos=\"" + i + "\"");
                    ++i;
                }
            }
            catch (IOException e) {
                RuntimeException r = new RuntimeException(e.getMessage());
                r.setStackTrace(e.getStackTrace());
                throw r;
            }
        }
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.offset = (Integer)XMLParser.extractObjectForTags(xml, "offset");
        if (XMLParser.hasTag(xml, "counter", null, null)) {
            this.counter = (int[])XMLParser.extractObjectForTags(xml, "counter");
            this.paramsFile = new File[this.counter.length];
            try {
                TreeMap<String, String> filter = new TreeMap<String, String>();
                int i = 0;
                while (i < this.paramsFile.length) {
                    filter.clear();
                    filter.put("pos", "" + i);
                    String content = XMLParser.extractObjectAndAttributesForTags(xml, "fileContent", null, filter, String.class);
                    if (!content.equalsIgnoreCase("")) {
                        this.paramsFile[i] = File.createTempFile(PREFIX, ".dat", null);
                        FileManager.writeFile(this.paramsFile[i], (CharSequence)new StringBuffer(content));
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                NonParsableException n = new NonParsableException(e.getMessage());
                n.setStackTrace(e.getStackTrace());
                throw n;
            }
        } else {
            this.counter = null;
            this.paramsFile = null;
        }
        this.writer = null;
        this.reader = null;
        this.init();
    }

    @Override
    public HigherOrderTransition clone() throws CloneNotSupportedException {
        HigherOrderTransition clone = (HigherOrderTransition)super.clone();
        if (this.writer != null) {
            throw new CloneNotSupportedException("sampling was not stopped before");
        }
        clone.writer = null;
        clone.reader = null;
        clone.params = (double[])this.params.clone();
        if (this.paramsFile != null) {
            try {
                clone.paramsFile = new File[this.paramsFile.length];
                clone.counter = new int[this.paramsFile.length];
                int i = 0;
                while (i < this.paramsFile.length) {
                    if (this.paramsFile[i] != null) {
                        clone.paramsFile[i] = File.createTempFile(PREFIX, ".dat", null);
                        FileManager.copy(this.paramsFile[i].getAbsolutePath(), clone.paramsFile[i].getAbsolutePath());
                        clone.counter[i] = this.counter[i];
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                CloneNotSupportedException c = new CloneNotSupportedException(e.getMessage());
                c.setStackTrace(e.getStackTrace());
                throw c;
            }
        }
        return clone;
    }

    @Override
    public void fillParameters(double[] params) {
        this.fillParameters(params, this.offset);
    }

    protected void fillParameters(double[] params, int offset) {
        int o = offset;
        int t = 0;
        while (t < this.transitions.length) {
            o = ((TransitionElement)this.transitions[t]).fillParameters(params, o);
            ++t;
        }
    }

    @Override
    public int setParameterOffset(int offset) {
        this.offset = offset;
        return this.setParameterOffset();
    }

    protected int setParameterOffset() {
        int o = this.offset;
        int t = 0;
        while (t < this.transitions.length) {
            o = ((TransitionElement)this.transitions[t]).setParameterOffset(o);
            ++t;
        }
        return o;
    }

    @Override
    public void setParameters(double[] params, int start) {
        this.setParams(params, start + this.offset);
    }

    protected void setParams(double[] params, int start) {
        int s = start;
        int t = 0;
        while (t < this.transitions.length) {
            s = ((TransitionElement)this.transitions[t]).setParameters(params, s);
            ++t;
        }
    }

    @Override
    public void addGradientForLogPriorTerm(double[] gradient, int start) {
        int t = 0;
        while (t < this.transitions.length) {
            ((TransitionElement)this.transitions[t]).addGradientForLogPriorTerm(gradient, start);
            ++t;
        }
    }

    @Override
    public double getLogScoreAndPartialDerivation(int layer, int index, int childIdx, IntList indices, DoubleList partDer, Sequence sequence, int sequencePosition) {
        return ((TransitionElement)this.transitions[this.getTransitionElementIndex(layer, index)]).getLogScoreAndPartialDerivation(childIdx, indices, partDer, sequence, sequencePosition);
    }

    @Override
    public void initForSampling(int starts) throws IOException {
        int t = 0;
        while (t < this.transitions.length) {
            if (((TransitionElement)this.transitions[t]).getMinimalHyperparameter() <= 0.0) {
                throw new IllegalArgumentException("All hyper-parameters must have a value > 0.");
            }
            ++t;
        }
        if (this.paramsFile != null && this.paramsFile.length == starts) {
            int i = 0;
            while (i < starts) {
                if (this.paramsFile[i] != null) {
                    FileOutputStream o = new FileOutputStream(this.paramsFile[i]);
                    o.close();
                }
                this.counter[i] = 0;
                ++i;
            }
        } else {
            this.deleteParameterFiles();
            this.paramsFile = new File[starts];
            this.counter = new int[starts];
        }
    }

    private void deleteParameterFiles() {
        if (this.paramsFile != null) {
            int i = 0;
            while (i < this.paramsFile.length) {
                if (this.paramsFile[i] != null) {
                    this.paramsFile[i].delete();
                }
                ++i;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
        this.deleteParameterFiles();
        super.finalize();
    }

    @Override
    public void extendSampling(int sampling, boolean append) throws IOException {
        if (this.paramsFile[sampling] == null) {
            this.paramsFile[sampling] = File.createTempFile(PREFIX, ".dat", null);
        } else if (append) {
            this.parseParameterSet(sampling, this.counter[sampling] - 1);
            this.reader.close();
            this.reader = null;
        } else {
            this.counter[sampling] = 0;
        }
        this.writer = new BufferedWriter(new FileWriter(this.paramsFile[sampling], append));
        this.samplingIndex = sampling;
    }

    @Override
    public boolean isInSamplingMode() {
        return this.writer != null;
    }

    @Override
    public boolean parseNextParameterSet() {
        String str;
        block9: {
            if (this.writer != null) {
                return false;
            }
            str = null;
            try {
                try {
                    str = this.reader.readLine();
                }
                catch (IOException iOException) {
                    if (str == null) {
                        return false;
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (str == null) {
                    return false;
                }
                throw throwable;
            }
            if (str == null) {
                return false;
            }
        }
        this.parse(str);
        return true;
    }

    @Override
    public boolean parseParameterSet(int sampling, int n) throws IOException {
        String str;
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = new BufferedReader(new FileReader(this.paramsFile[sampling]));
        while ((str = this.reader.readLine()) != null) {
            if (Integer.parseInt(str.substring(0, str.indexOf("\t"))) != n) continue;
            this.parse(str);
            return true;
        }
        return false;
    }

    private void parse(String str) {
        String[] strArray = str.split("\t");
        int offset = 1;
        int p = 0;
        while (p < this.params.length) {
            this.params[p] = Double.parseDouble(strArray[offset++]);
            ++p;
        }
        this.setParams(this.params, 0);
    }

    @Override
    public void samplingStopped() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public void acceptParameters() throws IOException {
        int n = this.samplingIndex;
        int n2 = this.counter[n];
        this.counter[n] = n2 + 1;
        this.writer.write("" + n2);
        this.fillParameters(this.params, 0);
        int p = 0;
        while (p < this.params.length) {
            this.writer.write("\t" + this.params[p]);
            ++p;
        }
        this.writer.newLine();
        this.writer.flush();
    }

    @Override
    public double getLogPosteriorFromStatistic() {
        double logPost = 0.0;
        int t = 0;
        while (t < this.transitions.length) {
            logPost += ((TransitionElement)this.transitions[t]).getLogPosteriorFromStatistic();
            ++t;
        }
        return logPost;
    }

    @Override
    public int getSizeOfEventSpace(int index) {
        int off = this.offset;
        int i = 0;
        while (i < this.transitions.length) {
            int num = ((TransitionElement)this.transitions[i]).getNumberOfParameters();
            if (index >= off && index < off + num) {
                return num;
            }
            off += num;
            ++i;
        }
        return 0;
    }

    @Override
    public void fillSamplingGroups(int parameterOffset, LinkedList<int[]> list) {
        int off = this.offset;
        int i = 0;
        while (i < this.transitions.length) {
            int[] idxs = new int[((TransitionElement)this.transitions[i]).getNumberOfParameters()];
            int j = 0;
            while (j < idxs.length) {
                idxs[j] = j + off + parameterOffset;
                ++j;
            }
            list.add(idxs);
            off += idxs.length;
            ++i;
        }
    }

    public TransitionElement[] getTransisionElements() throws CloneNotSupportedException {
        return (TransitionElement[])ArrayHandler.cast(ArrayHandler.clone((Cloneable[])this.transitions));
    }
}

