/*
 * Decompiled with CFR 0.152.
 */
package projects.dispom;

import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.classifiers.differentiableSequenceScoreBased.DiffSSBasedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LogGenDisMixFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.DataSetKMerEnumerator;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.RecyclableSequenceEnumerator;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.PermutedSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.KMereStatistic;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscovererToolbox;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.motifDiscovery.history.CappedHistory;
import de.jstacs.motifDiscovery.history.NoRevertHistory;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.NormalizedDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.MarkovModelDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.UniformHomogeneousDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.StrandDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.DurationDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.ExtendedZOOPSDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.MixtureDurationDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.SkewNormalLikeDurationDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.UniformDurationDiffSM;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.SafeOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import projects.dispom.DispomParameterSet;
import projects.dispom.PositionDistribution;

public class Dispom {
    private static final String[] PREFIX = new String[]{"home", "ignore", "fg", "bg", "position", "mean", "sd", "motifs", "length", "flankOrder", "motifOrder", "forwardStrand", "init", "adjust", "maxPos", "learning", "threads", "starts", "xml", "p-val"};

    private static HomogeneousDiffSM getHomSF(AlphabetContainer con, int order, double ess, int length) throws Exception {
        if (order >= 0) {
            return new HomogeneousMMDiffSM(con, order, ess, length);
        }
        return new UniformHomogeneousDiffSM(con, ess);
    }

    private static void doHeuristic(DataSet[] data, double[][] dataWeights, double aprioriMean, int length, boolean bothStrands, int maximalMismatches, int candidates, OptimizableFunction f, double weight, DifferentiableStatisticalModel[] score, SafeOutputStream out, int motifID) throws Exception {
        double d1;
        BitSet[] b;
        DataSet[] selected;
        out.writeln("heuristic:");
        int start = (int)Math.max(aprioriMean - 250.0, 0.0);
        int end = (int)Math.min(aprioriMean + 250.0, (double)data[0].getElementLength());
        if (start == 0 && end == data[0].getElementLength()) {
            selected = data;
        } else {
            selected = new DataSet[data.length];
            int i = 0;
            while (i < data.length) {
                selected[i] = data[i].getInfixDataSet(start, end - start);
                ++i;
            }
        }
        Hashtable<Sequence, BitSet[]> hash = KMereStatistic.getKmereSequenceStatistic(length, bothStrands, 1, data);
        out.writeln("found " + hash.size() + " " + length + "-mers");
        double nFg = data[0].getNumberOfElements();
        double nBg = data[1].getNumberOfElements();
        hash = KMereStatistic.removeBackground(hash, 0, 1, 1.0 / nFg, 1.0 / nBg);
        out.writeln("judged " + hash.size() + " " + length + "-mers as interesting");
        Hashtable<Sequence, BitSet[]> merged = KMereStatistic.merge(hash, maximalMismatches, true);
        ArrayList<ComparableElement<Map.Entry<Sequence, BitSet[]>, Double>> list = new ArrayList<ComparableElement<Map.Entry<Sequence, BitSet[]>, Double>>(merged.size());
        for (Map.Entry<Sequence, BitSet[]> entry : merged.entrySet()) {
            b = entry.getValue();
            d1 = (double)b[0].cardinality() / nFg - (double)b[1].cardinality() / nBg;
            if (!(d1 > 0.0)) continue;
            list.add(new ComparableElement<Map.Entry<Sequence, BitSet[]>, Double>(entry, d1));
        }
        Object[] ce = list.toArray(new ComparableElement[0]);
        Arrays.sort(ce);
        ArrayList<Sequence> currentSeqs = new ArrayList<Sequence>();
        ArrayList<Sequence> ignore = new ArrayList<Sequence>();
        DoubleList weights = new DoubleList();
        DataSet[] bestSample = new DataSet[1];
        DataSet[] currentSample = new DataSet[1];
        double[][] bestWeights = new double[1][];
        double[][] currentWeights = new double[1][];
        double bestVal = Double.NEGATIVE_INFINITY;
        int[] classIndex = new int[1];
        int[] motifIndex = new int[]{motifID};
        boolean[] adjust = new boolean[]{true};
        MutableMotifDiscoverer[] mmd = new MutableMotifDiscoverer[]{(MutableMotifDiscoverer)((Object)score[0])};
        int[] len = new int[]{mmd[0].getMotifLength(0)};
        int anz = 0;
        int idx = ce.length - 1;
        while (anz < candidates && idx >= 0) {
            double d2;
            Sequence rc;
            Sequence cand;
            Object current = ce[idx];
            Sequence seq = (Sequence)((Map.Entry)((ComparableElement)current).getElement()).getKey();
            double s = 0.0;
            int j = 0;
            while (j < ignore.size()) {
                cand = (Sequence)ignore.get(j);
                rc = cand.reverseComplement();
                d1 = seq.getHammingDistance(cand);
                if (bothStrands) {
                    d2 = seq.getHammingDistance(rc);
                    d1 = Math.min(d1, d2);
                }
                if (d1 <= (double)(maximalMismatches + 1)) break;
                ++j;
            }
            if (j == ignore.size()) {
                currentSeqs.clear();
                weights.clear();
                j = 0;
                while (j < list.size()) {
                    Map.Entry entry = (Map.Entry)((ComparableElement)list.get(j)).getElement();
                    cand = (Sequence)entry.getKey();
                    rc = cand.reverseComplement();
                    d1 = seq.getHammingDistance(cand);
                    if (bothStrands && d1 > (d2 = (double)seq.getHammingDistance(rc))) {
                        cand = rc;
                        d1 = d2;
                    }
                    if (d1 <= (double)maximalMismatches) {
                        b = (BitSet[])entry.getValue();
                        weights.add((double)b[0].cardinality() / nFg - (double)b[1].cardinality() / nBg);
                        s += (double)b[0].cardinality() / nFg - (double)b[1].cardinality() / nBg;
                        currentSeqs.add(cand);
                    }
                    ++j;
                }
                currentSample[0] = new DataSet("heuristc sample " + anz, currentSeqs.toArray(new Sequence[0]));
                weights.multiply(0, weights.length(), weight / s);
                currentWeights[0] = weights.toArray();
                MutableMotifDiscovererToolbox.initMotif(0, classIndex, motifIndex, currentSample, currentWeights, adjust, mmd, len, data, dataWeights);
                f.reset();
                double val = f.evaluateFunction(f.getParameters(OptimizableFunction.KindOfParameter.PLUGIN));
                out.writeln(String.valueOf(anz) + "\t" + idx + "\t" + seq + "\t" + ((ComparableElement)current).getWeight() + "\t" + val);
                if (val > bestVal) {
                    bestVal = val;
                    bestSample[0] = currentSample[0];
                    bestWeights[0] = currentWeights[0];
                }
                ignore.add(seq);
                ++anz;
            }
            --idx;
        }
        MutableMotifDiscovererToolbox.initMotif(0, classIndex, classIndex, bestSample, bestWeights, adjust, mmd, len, data, dataWeights);
        out.writeln("best=" + bestVal);
    }

    private static DataSet getSample(AlphabetContainer con, String fileName, char ignore) throws FileNotFoundException, WrongAlphabetException, EmptyDataSetException, WrongLengthException, IOException {
        return new DataSet(con, new SparseStringExtractor(fileName, ignore));
    }

    public static void main(String[] args) throws Exception {
        boolean bothStrands;
        int anz;
        ParameterSetTagger params = new ParameterSetTagger(PREFIX, new DispomParameterSet());
        params.fillParameters("=", args);
        System.out.println("parameters:");
        System.out.println(params);
        System.out.println("_________________________________");
        if (!params.hasDefaultOrIsSet()) {
            System.out.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        String home = params.getValueFromTag("home", String.class);
        char ignore = params.getValueFromTag("ignore", Character.class).charValue();
        LearningPrinciple key = params.getValueFromTag("learning", LearningPrinciple.class);
        int n = anz = key == LearningPrinciple.MAP || key == LearningPrinciple.ML ? 1 : 2;
        if (params.isSet("bg")) {
            anz = 2;
        }
        DataSet[] data = new DataSet[anz];
        data[0] = Dispom.getSample(con, String.valueOf(home) + File.separatorChar + params.getValueFromTag("fg", String.class), ignore);
        if (anz > 1) {
            if (params.isSet("bg")) {
                data[1] = Dispom.getSample(con, String.valueOf(home) + File.separatorChar + params.getValueFromTag("bg", String.class), ignore);
            } else {
                Sequence[] seqs = data[0].getAllElements();
                int n2 = 0;
                while (n2 < seqs.length) {
                    seqs[n2] = new PermutedSequence(seqs[n2]);
                    ++n2;
                }
                data[1] = new DataSet("permuted foreground sequences", seqs);
            }
            DataSet s = DataSet.diff(data[1], data[0]);
            if (s.getNumberOfElements() < data[1].getNumberOfElements()) {
                System.out.println("removed " + (data[1].getNumberOfElements() - s.getNumberOfElements()) + " sequences from background file");
                data[1] = s;
            }
        }
        double[][] weights = new double[anz][];
        int i = 0;
        while (i < data.length) {
            weights[i] = new double[data[i].getNumberOfElements()];
            Arrays.fill(weights[i], 1.0);
            System.out.println(String.valueOf(i) + "\t# = " + data[i].getNumberOfElements() + "\tlength = " + data[i].getElementLength() + "\t" + data[i].getAnnotation());
            ++i;
        }
        int sl = data[0].getElementLength();
        int starts = 1;
        int flOrder = params.getValueFromTag("flankOrder", Integer.class);
        int fgOrder = params.getValueFromTag("motifOrder", Integer.class);
        int motifL = params.getValueFromTag("length", Integer.class);
        int motifs = params.getValueFromTag("motifs", Integer.class);
        double essMotif = 4.0;
        double essNonMotif = 1.0;
        boolean free = false;
        Cloneable[] score = new DifferentiableStatisticalModel[anz];
        if (anz > 1) {
            int n1;
            int n0 = data[0].getNumberOfElements();
            double f = n0 >= (n1 = data[1].getNumberOfElements()) ? (double)Math.round((double)n0 / (double)n1) : (double)Math.round((double)n1 / (double)n0);
            score[1] = Dispom.getHomSF(con, flOrder, f * (essMotif + (double)motifs * essNonMotif), sl);
        }
        HomogeneousDiffSM flanking = Dispom.getHomSF(con, flOrder, essNonMotif, sl);
        int threads = params.getValueFromTag("threads", Integer.class);
        double epsilon = 1.0E-7;
        double lineps = 1.0E-10;
        double startD = 1.0;
        SmallDifferenceOfFunctionEvaluationsCondition eps = new SmallDifferenceOfFunctionEvaluationsCondition(epsilon);
        byte algo = 20;
        SafeOutputStream stream = SafeOutputStream.getSafeOutputStream(System.out);
        double[] beta = LearningPrinciple.getBeta(key);
        boolean adjust = params.getValueFromTag("adjust", Boolean.class);
        SkewNormalLikeDurationDiffSM motifPenalty = new SkewNormalLikeDurationDiffSM(1, 50, -1.5, -2.5, 4.2);
        System.out.println();
        AbstractDifferentiableStatisticalModel motif = new MarkovModelDiffSM((AlphabetContainer)con, motifL, essMotif, true, new InhomogeneousMarkov(fgOrder), (DurationDiffSM)motifPenalty);
        Double forwardStrand = params.getValueFromTag("forwardStrand", Double.class);
        boolean bl = bothStrands = forwardStrand == null || forwardStrand < 1.0;
        if (bothStrands) {
            motif = forwardStrand == null ? new StrandDiffSM((DifferentiableStatisticalModel)motif, 0.5, starts, true, StrandDiffSM.InitMethod.INIT_FORWARD_STRAND) : new StrandDiffSM((DifferentiableStatisticalModel)motif, starts, true, StrandDiffSM.InitMethod.INIT_FORWARD_STRAND, forwardStrand);
        }
        motif.initializeFunctionRandomly(free);
        motif = new NormalizedDiffSM(motif, 1);
        DurationDiffSM pos = null;
        double seqs = 1.0;
        double sd = params.getValueFromTag("sd", Double.class);
        double skewSd = 1.0;
        double mu = params.getValueFromTag("mean", Double.class);
        switch (params.getValueFromTag("position", PositionDistribution.class)) {
            case UNIFORM: {
                pos = new UniformDurationDiffSM(0, sl - motifL, essMotif);
                break;
            }
            case SKEW_NORMAL: {
                pos = new SkewNormalLikeDurationDiffSM(0, sl - motifL, true, mu, 500.0, true, seqs / 2.0, seqs / 2.0 * (sd * sd), true, 0.0, skewSd, starts);
                break;
            }
            case MIXTURE: {
                pos = new MixtureDurationDiffSM(starts, new UniformDurationDiffSM(0, sl - motifL, essMotif - seqs), new SkewNormalLikeDurationDiffSM(0, sl - motifL, true, mu, 500.0, true, seqs / 2.0, seqs / 2.0 * (sd * sd), true, 0.0, skewSd, starts));
            }
        }
        ExtendedZOOPSDiffSM fg = motifs > 1 ? new ExtendedZOOPSDiffSM(false, sl, starts, true, flanking, (DifferentiableStatisticalModel[])ArrayHandler.createArrayOf((Cloneable)motif, (int)motifs), (DurationDiffSM[])ArrayHandler.createArrayOf((Cloneable)pos, (int)motifs), true) : new ExtendedZOOPSDiffSM(false, sl, starts, true, flanking, (DifferentiableStatisticalModel)motif, pos, true);
        score[0] = fg;
        LearningPrinciple initKey = beta[0] > 0.0 ? LearningPrinciple.MCL : LearningPrinciple.ML;
        String initMethod = params.getValueFromTag("init", String.class);
        int restarts = params.getValueFromTag("starts", Integer.class);
        if (restarts > 1 && !initMethod.startsWith("best-random")) {
            System.out.println("WARNING: set number of starts to 1, since init-method is \"best-random\"");
            restarts = 1;
        }
        String v = initMethod.substring(initMethod.indexOf(61) + 1);
        double defaultWeight = 6.0;
        double[][] best = null;
        LogGenDisMixFunction initObjective = new LogGenDisMixFunction(threads, (DifferentiableSequenceScore[])score, data, weights, new CompositeLogPrior(), LearningPrinciple.getBeta(initKey), true, free);
        LogGenDisMixFunction objective = new LogGenDisMixFunction(threads, (DifferentiableSequenceScore[])score, data, weights, new CompositeLogPrior(), beta, true, free);
        DifferentiableSequenceScore[] bestNSF = null;
        int r = 0;
        while (r < restarts) {
            System.out.println("start " + r + " -------------------------------------------------");
            DifferentiableSequenceScore[] current = (DifferentiableStatisticalModel[])ArrayHandler.clone((Cloneable[])score);
            objective.reset(current);
            initObjective.reset(current);
            if (initMethod.startsWith("best-random")) {
                MutableMotifDiscovererToolbox.InitMethodForDiffSM[] initMeth = new MutableMotifDiscovererToolbox.InitMethodForDiffSM[]{MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING, MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING};
                if (initMethod.startsWith("best-random=")) {
                    initMeth[0] = MutableMotifDiscovererToolbox.InitMethodForDiffSM.RANDOMLY;
                } else if (initMethod.startsWith("best-random-plugin=")) {
                    initMeth[0] = MutableMotifDiscovererToolbox.InitMethodForDiffSM.PLUG_IN;
                } else if (initMethod.startsWith("best-random-motif=")) {
                    initMeth[0] = MutableMotifDiscovererToolbox.InitMethodForDiffSM.MOTIF_RANDOMLY;
                }
                if (initMeth[0] == MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING) {
                    throw new IllegalArgumentException("Initialization method not correctly set.");
                }
                ComparableElement<double[], Double>[] pars = MutableMotifDiscovererToolbox.getSortedInitialParameters(current, initMeth, initObjective, Integer.parseInt(v), stream, 0);
                objective.setParams(pars[pars.length - 1].getElement());
            } else if (initMethod.startsWith("specific=")) {
                DataSet[] spec = new DataSet[1];
                double[][] w = new double[1][];
                if (new File(v).exists()) {
                    spec[0] = new DataSet(con, new SparseStringExtractor(v, ignore));
                } else {
                    spec[0] = new DataSet("one sequence", Sequence.create(con, v.trim()));
                    w[0] = new double[]{defaultWeight};
                }
                MutableMotifDiscovererToolbox.initMotif(0, new int[1], new int[1], spec, w, new boolean[]{true}, new MutableMotifDiscoverer[]{(MutableMotifDiscoverer)((Object)current[0])}, new int[]{motifL}, data, weights);
            } else {
                int i2 = 0;
                while (i2 < fg.getNumberOfMotifs()) {
                    if (initMethod.startsWith("enum")) {
                        RecyclableSequenceEnumerator enumeration;
                        int k = Integer.parseInt(v);
                        if (initMethod.startsWith("enum-all=")) {
                            enumeration = new DiscreteSequenceEnumerator(con, k, bothStrands);
                        } else if (initMethod.startsWith("enum-data=")) {
                            enumeration = new DataSetKMerEnumerator(data[0], k, bothStrands);
                        } else {
                            throw new IllegalArgumentException("Initialization method not correctly set.");
                        }
                        System.out.println("best seed: " + MutableMotifDiscovererToolbox.enumerate(current, 0, i2, enumeration, defaultWeight, (DiffSSBasedOptimizableFunction)initObjective, (OutputStream)System.out));
                    } else if (initMethod.startsWith("heuristic")) {
                        Dispom.doHeuristic(data, weights, mu, (int)(0.7 * (double)motifL), bothStrands, 1, Integer.parseInt(v), initObjective, defaultWeight, (DifferentiableStatisticalModel[])current, stream, i2);
                    } else {
                        throw new IllegalArgumentException("Initialization method unknown.");
                    }
                    ++i2;
                }
            }
            System.out.println(current[0]);
            System.out.println("_________________________________");
            objective.reset(current);
            double[][] res = MutableMotifDiscovererToolbox.optimize(current, objective, algo, eps, lineps, new ConstantStartDistance(startD), stream, false, new CappedHistory(15, new NoRevertHistory(true, adjust, adjust)), OptimizableFunction.KindOfParameter.PLUGIN, params.getValueFromTag("maxPos", Boolean.class));
            if (best == null || res[0][0] > best[0][0]) {
                bestNSF = current;
                best = res;
            }
            ++r;
        }
        GenDisMixClassifierParameterSet cps = new GenDisMixClassifierParameterSet(con, sl, algo, epsilon, lineps, startD, free, OptimizableFunction.KindOfParameter.PLUGIN, true, threads);
        GenDisMixClassifier cl = new GenDisMixClassifier(cps, (LogPrior)new CompositeLogPrior(), (double)best[0][0], beta, (DifferentiableStatisticalModel[])bestNSF);
        cl.setClassWeights(false, (double[])best[1]);
        StringBuffer sb = new StringBuffer(100000);
        XMLParser.appendObjectWithTags(sb, cl, "classifier");
        String fName = params.getValueFromTag("xml", String.class);
        if (!fName.endsWith(".xml")) {
            fName = String.valueOf(fName) + ".xml";
        }
        FileManager.writeFile(new File(fName), (CharSequence)sb);
        initObjective.stopThreads();
        objective.stopThreads();
        System.out.println("_________________________________");
        System.out.println(bestNSF[0]);
        System.out.println("result: " + (double)best[0][0]);
        if (params.isSet("p-val")) {
            System.out.println("_________________________________");
            SignificantMotifOccurrencesFinder smof = anz > 1 ? new SignificantMotifOccurrencesFinder((MotifDiscoverer)((Object)bestNSF[0]), data[1], weights[1], params.getValueFromTag("p-val", Double.class)) : new SignificantMotifOccurrencesFinder((MotifDiscoverer)((Object)bestNSF[0]), SignificantMotifOccurrencesFinder.RandomSeqType.PERMUTED, true, 1000, (double)params.getValueFromTag("p-val", Double.class));
            System.out.println("prediction");
            System.out.println();
            System.out.println("sequence\tposition\tstrand\tbinding site\tadjusted binding site\tp-value");
            System.out.println("------------------------------------------------------------------------");
            LinkedList<Sequence> list = new LinkedList<Sequence>();
            int i3 = 0;
            while (i3 < data[0].getNumberOfElements()) {
                Sequence seq = data[0].getElementAt(i3);
                MotifAnnotation[] ma = smof.findSignificantMotifOccurrences(0, seq, 0);
                if (ma != null && ma.length != 0) {
                    int j = 0;
                    while (j < ma.length) {
                        Sequence site = seq.getSubSequence(ma[j].getPosition(), ma[j].getLength());
                        Sequence adjusted = ma[j].getStrandedness() == StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE ? site.reverseComplement() : site;
                        System.out.println(String.valueOf(i3) + "\t" + ma[j].getPosition() + "\t" + (Object)((Object)ma[j].getStrandedness()) + "\t" + site + "\t" + adjusted + "\t" + ma[j].getAnnotations()[1].getValue());
                        list.add(adjusted);
                        ++j;
                    }
                }
                ++i3;
            }
            double[][] pfm = null;
            if (list.size() > 0) {
                System.out.println();
                System.out.println("PFM:");
                pfm = PFMComparator.getPFM(new DataSet("sites", list.toArray(new Sequence[0])));
                int l = 0;
                while (l < pfm.length) {
                    System.out.print(l);
                    int a = 0;
                    while (a < pfm[l].length) {
                        System.out.print("\t" + pfm[l][a]);
                        ++a;
                    }
                    System.out.println();
                    ++l;
                }
            }
            String transfac = "./transfac.dat";
            if (pfm != null && new File(transfac).exists()) {
                System.out.println();
                System.out.println("comparing with TRANSFAC:");
                ArrayList<AbstractMap.SimpleEntry<String, double[][]>> library = PFMComparator.readPFMsFromEMBL(transfac, Integer.MAX_VALUE);
                PFMComparator.NormalizedEuclideanDistance dist = new PFMComparator.NormalizedEuclideanDistance();
                ComparableElement<String, Double>[] ce = PFMComparator.find(DNAAlphabet.SINGLETON, pfm, library, dist, 7, 2, true, 0.05);
                int i4 = 0;
                while (i4 < ce.length) {
                    System.out.println(String.valueOf(i4) + "\t" + ce[i4].getWeight() + "\t" + ce[i4].getElement());
                    ++i4;
                }
            }
        }
    }
}

