/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.taxa;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.taxa.NCBITaxon;
import org.biojavax.bio.taxa.SimpleNCBITaxonName;

public class SimpleNCBITaxon
extends AbstractChangeable
implements NCBITaxon {
    protected Set names = new TreeSet();
    private Map namesMap = new TreeMap();
    private Integer parent;
    private int NCBITaxID;
    private String nodeRank;
    private Integer geneticCode;
    private Integer mitoGeneticCode;
    private Integer leftValue;
    private Integer rightValue;
    private boolean isTaxonHidden = false;
    private static final String TAXONISHIDDEN = "X";
    private static final int ROOTNCBIID = 1;
    private Integer id;

    public SimpleNCBITaxon(int NCBITaxID) {
        this.NCBITaxID = NCBITaxID;
    }

    public SimpleNCBITaxon(Integer NCBITaxID) {
        this.NCBITaxID = NCBITaxID;
    }

    protected SimpleNCBITaxon() {
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        NCBITaxon them = (NCBITaxon)o;
        return this.NCBITaxID - them.getNCBITaxID();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof NCBITaxon)) {
            return false;
        }
        NCBITaxon them = (NCBITaxon)obj;
        return this.NCBITaxID == them.getNCBITaxID();
    }

    public int hashCode() {
        return this.NCBITaxID;
    }

    public Set getNameClasses() {
        return this.namesMap.keySet();
    }

    public Set getNames(String nameClass) throws IllegalArgumentException {
        if (nameClass == null) {
            throw new IllegalArgumentException("Name class cannot be null");
        }
        Set items = (Set)this.namesMap.get(nameClass);
        TreeSet<String> n = new TreeSet<String>();
        if (items != null) {
            for (SimpleNCBITaxonName name : items) {
                n.add(name.getName());
            }
        }
        return n;
    }

    protected Set getNameSet() {
        return this.names;
    }

    void setNameSet(Set names) {
        this.names = names;
        this.namesMap.clear();
        for (SimpleNCBITaxonName n : names) {
            try {
                this.addName(n.getNameClass(), n.getName());
            }
            catch (ChangeVetoException e) {
                throw new RuntimeException("Database contents don't add up", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addName(String nameClass, String name) throws IllegalArgumentException, ChangeVetoException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (nameClass == null) {
            throw new IllegalArgumentException("Name class cannot be null");
        }
        SimpleNCBITaxonName n = new SimpleNCBITaxonName(nameClass, name);
        if (!this.hasListeners(NCBITaxon.NAMES)) {
            if (!this.namesMap.containsKey(nameClass)) {
                this.namesMap.put(nameClass, new TreeSet());
            }
            ((Set)this.namesMap.get(nameClass)).add(n);
            this.names.add(n);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, NCBITaxon.NAMES, name, ((Set)this.namesMap.get(nameClass)).contains(n) ? name : null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(NCBITaxon.NAMES);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                if (!this.namesMap.containsKey(nameClass)) {
                    this.namesMap.put(nameClass, new TreeSet());
                }
                ((Set)this.namesMap.get(nameClass)).add(n);
                this.names.add(n);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeName(String nameClass, String name) throws IllegalArgumentException, ChangeVetoException {
        boolean results;
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (nameClass == null) {
            throw new IllegalArgumentException("Name class cannot be null");
        }
        SimpleNCBITaxonName n = new SimpleNCBITaxonName(nameClass, name);
        if (!this.namesMap.containsKey(nameClass)) {
            return false;
        }
        if (!this.hasListeners(NCBITaxon.NAMES)) {
            results = ((Set)this.namesMap.get(nameClass)).remove(n);
            this.names.remove(n);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, NCBITaxon.NAMES, null, name);
            ChangeSupport changeSupport = cs = this.getChangeSupport(NCBITaxon.NAMES);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                results = ((Set)this.namesMap.get(nameClass)).remove(n);
                this.names.remove(n);
                cs.firePostChangeEvent(ce);
            }
        }
        return results;
    }

    public boolean containsName(String nameClass, String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (nameClass == null) {
            throw new IllegalArgumentException("Name class cannot be null");
        }
        if (!this.namesMap.containsKey(nameClass)) {
            return false;
        }
        SimpleNCBITaxonName n = new SimpleNCBITaxonName(nameClass, name);
        return ((Set)this.namesMap.get(nameClass)).contains(n);
    }

    protected final Map getNamesMap() {
        return this.namesMap;
    }

    public Integer getParentNCBITaxID() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentNCBITaxID(Integer parent) throws ChangeVetoException {
        if (!this.hasListeners(NCBITaxon.PARENT)) {
            this.parent = parent;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, NCBITaxon.PARENT, parent, this.parent);
            ChangeSupport changeSupport = cs = this.getChangeSupport(NCBITaxon.PARENT);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.parent = parent;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public int getNCBITaxID() {
        return this.NCBITaxID;
    }

    void setNCBITaxID(int NCBITaxID) {
        this.NCBITaxID = NCBITaxID;
    }

    public String getNodeRank() {
        return this.nodeRank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeRank(String nodeRank) throws ChangeVetoException {
        if (!this.hasListeners(NCBITaxon.NODERANK)) {
            this.nodeRank = nodeRank;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, NCBITaxon.NODERANK, nodeRank, this.nodeRank);
            ChangeSupport changeSupport = cs = this.getChangeSupport(NCBITaxon.NODERANK);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.nodeRank = nodeRank;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public Integer getGeneticCode() {
        return this.geneticCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeneticCode(Integer geneticCode) throws ChangeVetoException {
        if (!this.hasListeners(NCBITaxon.GENETICCODE)) {
            this.geneticCode = geneticCode;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, NCBITaxon.GENETICCODE, this.nodeRank, this.nodeRank);
            ChangeSupport changeSupport = cs = this.getChangeSupport(NCBITaxon.GENETICCODE);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.geneticCode = geneticCode;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public Integer getMitoGeneticCode() {
        return this.mitoGeneticCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMitoGeneticCode(Integer mitoGeneticCode) throws ChangeVetoException {
        if (!this.hasListeners(NCBITaxon.MITOGENETICCODE)) {
            this.mitoGeneticCode = mitoGeneticCode;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, NCBITaxon.MITOGENETICCODE, mitoGeneticCode, this.mitoGeneticCode);
            ChangeSupport changeSupport = cs = this.getChangeSupport(NCBITaxon.MITOGENETICCODE);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.mitoGeneticCode = mitoGeneticCode;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public Integer getLeftValue() {
        return this.leftValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftValue(Integer leftValue) throws ChangeVetoException {
        if (!this.hasListeners(NCBITaxon.LEFTVALUE)) {
            this.leftValue = leftValue;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, NCBITaxon.LEFTVALUE, leftValue, this.leftValue);
            ChangeSupport changeSupport = cs = this.getChangeSupport(NCBITaxon.LEFTVALUE);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.leftValue = leftValue;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public Integer getRightValue() {
        return this.rightValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightValue(Integer rightValue) throws ChangeVetoException {
        if (!this.hasListeners(NCBITaxon.RIGHTVALUE)) {
            this.rightValue = rightValue;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, NCBITaxon.RIGHTVALUE, rightValue, this.rightValue);
            ChangeSupport changeSupport = cs = this.getChangeSupport(NCBITaxon.RIGHTVALUE);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rightValue = rightValue;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public String getDisplayName() {
        StringBuffer sb = new StringBuffer();
        Set sciNames = this.getNames("scientific name");
        Set comNames = this.getNames("common name");
        if (sciNames.size() > 0) {
            sb.append((String)sciNames.iterator().next());
            if (comNames.size() > 0) {
                sb.append(" (");
                sb.append((String)comNames.iterator().next());
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public final boolean isTaxonHidden() {
        return this.isTaxonHidden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTaxonHidden(boolean isTaxonHidden) throws ChangeVetoException {
        if (!this.hasListeners(HIDDEN)) {
            this.isTaxonHidden = isTaxonHidden;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, HIDDEN, new Boolean(isTaxonHidden), new Boolean(this.isTaxonHidden));
            ChangeSupport changeSupport = cs = this.getChangeSupport(HIDDEN);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.isTaxonHidden = isTaxonHidden;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    String getTaxonHiddenChar() {
        return this.isTaxonHidden() ? TAXONISHIDDEN : null;
    }

    void setTaxonHiddenChar(String isHiddenChar) throws ChangeVetoException {
        this.setTaxonHidden(isHiddenChar != null || isHiddenChar != null && isHiddenChar.length() > 0);
    }

    public String getNameHierarchy() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Integer parent = this.getParentNCBITaxID();
        while (parent != null) {
            NCBITaxon t = (NCBITaxon)RichObjectFactory.getObject(SimpleNCBITaxon.class, new Object[]{parent});
            Set sciNames = t.getNames("scientific name");
            if (sciNames.size() > 0) {
                if (!t.isTaxonHidden() && !SimpleNCBITaxon.isRoot(t)) {
                    if (!first) {
                        sb.insert(0, "; ");
                    } else {
                        first = false;
                    }
                    sb.insert(0, (String)sciNames.iterator().next());
                }
                if (t.getParentNCBITaxID().equals(new Integer(t.getNCBITaxID()))) {
                    parent = null;
                    continue;
                }
                parent = t.getParentNCBITaxID();
                continue;
            }
            parent = null;
        }
        sb.append(".");
        return sb.toString();
    }

    private static final boolean isRoot(NCBITaxon theTaxon) {
        return SimpleNCBITaxon.isRoot(theTaxon.getNCBITaxID());
    }

    private static final boolean isRoot(int theNCBIId) {
        return theNCBIId == 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("taxid:");
        sb.append(this.NCBITaxID);
        sb.append("[");
        Iterator i = this.getNameSet().iterator();
        while (i.hasNext()) {
            SimpleNCBITaxonName n = (SimpleNCBITaxonName)i.next();
            sb.append(n);
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}

