/*
 * Decompiled with CFR 0.152.
 */
package projects.talen;

import de.jstacs.utils.ComparableElement;
import java.util.Arrays;

public class LimitedSortedList<T> {
    private ComparableElement<T, Double>[] list;
    private int curr;
    private boolean expand;

    public LimitedSortedList(int limit) {
        if (limit > 0) {
            this.list = new ComparableElement[limit];
            this.expand = false;
        } else {
            this.list = new ComparableElement[-limit];
            this.expand = true;
        }
        this.curr = 0;
    }

    public void clear() {
        this.curr = 0;
    }

    public boolean checkInsert(double val) {
        return this.curr < this.list.length || val > this.list[0].getWeight();
    }

    public ComparableElement<T, Double> getElementAt(int idx) {
        if (idx >= this.curr) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.list[idx];
    }

    public T getBestElement() {
        if (this.curr == this.list.length) {
            return this.list[this.list.length - 1].getElement();
        }
        double max = Double.NEGATIVE_INFINITY;
        T maxEl = null;
        int i = 0;
        while (i < this.curr) {
            double temp = this.list[i].getWeight();
            if (temp > max) {
                max = temp;
                maxEl = this.list[i].getElement();
            }
            ++i;
        }
        return maxEl;
    }

    public T getWorstElement() {
        if (this.curr == this.list.length) {
            return this.list[0].getElement();
        }
        double min = Double.POSITIVE_INFINITY;
        T minEl = null;
        int i = 0;
        while (i < this.curr) {
            double temp = this.list[i].getWeight();
            if (temp < min) {
                min = temp;
                minEl = this.list[i].getElement();
            }
            ++i;
        }
        return minEl;
    }

    public double getBestScore() {
        if (this.curr == this.list.length) {
            return this.list[this.list.length - 1].getWeight();
        }
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.curr) {
            double temp = this.list[i].getWeight();
            if (temp > max) {
                max = temp;
            }
            ++i;
        }
        return max;
    }

    public double getWorstScore() {
        if (this.curr == this.list.length) {
            return this.list[0].getWeight();
        }
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.curr) {
            double temp = this.list[i].getWeight();
            if (temp < min) {
                min = temp;
            }
            ++i;
        }
        return min;
    }

    public void insertAll(LimitedSortedList<T> list2) {
        int i = 0;
        while (i < list2.curr) {
            this.insert(list2.list[i].getWeight(), list2.list[i].getElement());
            ++i;
        }
    }

    public boolean insert(double val, T element) {
        if (this.curr < this.list.length) {
            this.list[this.curr] = new ComparableElement<T, Double>(element, val);
            ++this.curr;
            if (this.curr == this.list.length) {
                if (this.expand) {
                    ComparableElement[] temp = new ComparableElement[(int)((double)this.list.length * 1.5)];
                    System.arraycopy(this.list, 0, temp, 0, this.list.length);
                    this.list = temp;
                } else {
                    Arrays.sort(this.list);
                }
            }
            return true;
        }
        if (val > this.list[0].getWeight()) {
            ComparableElement<T, Double> el = new ComparableElement<T, Double>(element, val);
            int idx = Arrays.binarySearch(this.list, el);
            if (idx < 0) {
                idx = -idx - 1 - 1;
            }
            System.arraycopy(this.list, 1, this.list, 0, idx);
            this.list[idx] = el;
            return true;
        }
        return false;
    }

    public int getLength() {
        return this.curr;
    }

    public ComparableElement<T, Double>[] getSortedList() {
        if (this.curr == this.list.length) {
            return (ComparableElement[])this.list.clone();
        }
        Object[] temp = new ComparableElement[this.curr];
        System.arraycopy(this.list, 0, temp, 0, this.curr);
        Arrays.sort(temp);
        return temp;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        int i = 0;
        while (i < this.list.length && (this.curr == this.list.length || i < this.curr)) {
            str.append(this.list[i].getWeight() + ": " + this.list[i].getElement().toString() + "; ");
            ++i;
        }
        str.append("]");
        return str.toString();
    }
}

