/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionUtil;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class TruncatedDist
extends ContinuousDistribution {
    public static int NUMINTERVALS = 500;
    private ContinuousDistribution dist;
    private double fa;
    private double fb;
    private double fbfa;
    private double a;
    private double b;
    private double approxMean;
    private double approxVariance;
    private double approxStandardDeviation;

    public TruncatedDist(ContinuousDistribution dist, double a, double b) {
        this.setParams(dist, a, b);
    }

    public double density(double x) {
        return this.dist.density(x) / this.fbfa;
    }

    public double cdf(double x) {
        if (x <= this.a) {
            return 0.0;
        }
        if (x >= this.b) {
            return 1.0;
        }
        return this.dist.cdf(x) / this.fbfa;
    }

    public double barF(double x) {
        if (x <= this.a) {
            return 1.0;
        }
        if (x >= this.b) {
            return 0.0;
        }
        return this.dist.barF(x) / this.fbfa;
    }

    public double inverseF(double u) {
        return this.dist.inverseF(this.fa + this.fbfa * u);
    }

    public double getMean() {
        if (Double.isNaN(this.approxMean)) {
            throw new UnsupportedOperationException("Undefined mean");
        }
        return this.approxMean;
    }

    public double getVariance() {
        if (Double.isNaN(this.approxVariance)) {
            throw new UnsupportedOperationException("Unknown variance");
        }
        return this.approxVariance;
    }

    public double getStandardDeviation() {
        if (Double.isNaN(this.approxStandardDeviation)) {
            throw new UnsupportedOperationException("Unknown standard deviation");
        }
        return this.approxStandardDeviation;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getFa() {
        return this.fa;
    }

    public double getFb() {
        return this.fb;
    }

    public double getArea() {
        return this.fbfa;
    }

    public void setParams(ContinuousDistribution dist, double a, double b) {
        this.dist = dist;
        if (a >= b) {
            throw new IllegalArgumentException("a must be smaller than b.");
        }
        this.supportA = this.a = a;
        this.supportB = this.b = b;
        this.fa = a == Double.NEGATIVE_INFINITY ? 0.0 : dist.cdf(a);
        this.fb = b == Double.POSITIVE_INFINITY ? 1.0 : dist.cdf(b);
        this.fbfa = this.fb - this.fa;
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            this.approxStandardDeviation = Double.NaN;
            this.approxVariance = Double.NaN;
            this.approxMean = Double.NaN;
        } else {
            MomentFunction func1 = new MomentFunction(dist, 1);
            this.approxMean = MathFunctionUtil.simpsonIntegral(func1, a, b, NUMINTERVALS) / this.fbfa;
            MomentFunction func2 = new MomentFunction(dist, 2, this.approxMean);
            this.approxVariance = MathFunctionUtil.simpsonIntegral(func2, a, b, NUMINTERVALS) / this.fbfa;
            this.approxStandardDeviation = Math.sqrt(this.approxVariance);
        }
    }

    public double[] getParams() {
        double[] retour = new double[]{this.a, this.b, this.fa, this.fb, this.fbfa};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : a = " + this.a + ", b = " + this.b + ", F(a) = " + this.fa + ", F(b) = " + this.fb + ", F(b)-F(a) = " + this.fbfa;
    }

    private static class MomentFunction
    implements MathFunction {
        private ContinuousDistribution dist;
        private int moment;
        private double offset;

        public MomentFunction(ContinuousDistribution dist, int moment) {
            this.dist = dist;
            this.moment = moment;
        }

        public MomentFunction(ContinuousDistribution dist, int moment, double offset) {
            this(dist, moment);
            this.offset = offset;
        }

        public double evaluate(double x) {
            double res = this.dist.density(x);
            double offsetX = x - this.offset;
            for (int i = 0; i < this.moment; ++i) {
                res *= offsetX;
            }
            return res;
        }
    }
}

