/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.SubclassFinder;
import de.jstacs.utils.ToolBox;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractPerformanceMeasure
extends ParameterSet
implements PerformanceMeasure {
    protected AbstractPerformanceMeasure() {
    }

    protected AbstractPerformanceMeasure(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public abstract String getName();

    @Override
    public ResultSet compute(double[] sortedScoresClass0, double[] sortedScoresClass1) {
        return this.compute(sortedScoresClass0, null, sortedScoresClass1, null);
    }

    @Override
    public ResultSet compute(double[][][] classSpecificScores) {
        return this.compute(classSpecificScores, null);
    }

    public static SelectionParameter getCollectionOfAllMeasures(int numClasses, boolean numerical) throws Exception {
        LinkedList<Class<AbstractPerformanceMeasure>> list = SubclassFinder.findInstantiableSubclasses(AbstractPerformanceMeasure.class, AbstractPerformanceMeasure.class.getPackage().getName());
        Iterator it = list.iterator();
        LinkedList<AbstractPerformanceMeasure> found = new LinkedList<AbstractPerformanceMeasure>();
        while (it.hasNext()) {
            Class cl = (Class)it.next();
            if (numerical && !NumericalPerformanceMeasure.class.isAssignableFrom(cl)) continue;
            try {
                AbstractPerformanceMeasure mea = (AbstractPerformanceMeasure)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (mea.getAllowedNumberOfClasses() != 0 && mea.getAllowedNumberOfClasses() != numClasses) continue;
                found.add(mea);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return new SelectionParameter("Performance Measures", "Performance measures that can be computed for " + (numClasses == 0 ? "any number of" : Integer.valueOf(numClasses)) + " classes.", true, found.toArray(new AbstractPerformanceMeasure[0]));
    }

    protected static double findThreshold(double[] sortedReferenceScores, double[] sortedMeasureScores, double[] referenceWeights, double percentage, boolean atLeast) {
        double sum = referenceWeights == null ? (double)sortedReferenceScores.length : ToolBox.sum(0, sortedReferenceScores.length, referenceWeights);
        double hypThreshWeight = sum * percentage;
        double curr = 0.0;
        int i = 0;
        while (curr < hypThreshWeight && i < sortedReferenceScores.length) {
            curr += AbstractPerformanceMeasure.getWeight(referenceWeights, i);
            ++i;
        }
        if (atLeast) {
            while (i + 1 < sortedReferenceScores.length && sortedReferenceScores[i] == sortedReferenceScores[i + 1]) {
                ++i;
            }
        } else if (i < sortedReferenceScores.length) {
            while (i - 1 >= 0 && sortedReferenceScores[i] == sortedReferenceScores[i - 1]) {
                curr -= AbstractPerformanceMeasure.getWeight(referenceWeights, i);
                --i;
            }
            if (i > 0 && curr != hypThreshWeight) {
                --i;
            }
        }
        double min = i == sortedReferenceScores.length ? sortedReferenceScores[sortedReferenceScores.length - 1] : sortedReferenceScores[i];
        if (!atLeast) {
            return min;
        }
        int j = AbstractPerformanceMeasure.findSplitIndex(sortedMeasureScores, min);
        while (j < sortedMeasureScores.length && sortedMeasureScores[j] == min) {
            ++j;
        }
        double max = j == sortedMeasureScores.length ? min * 1.01 : sortedMeasureScores[j];
        while (i < sortedReferenceScores.length && sortedReferenceScores[i] == min) {
            ++i;
        }
        if (i < sortedReferenceScores.length) {
            max = Math.min(max, sortedReferenceScores[i]);
        }
        return (min + max) / 2.0;
    }

    protected static int findSplitIndex(double[] sortedScores, double t) {
        int i = Arrays.binarySearch(sortedScores, t);
        if (i >= 0) {
            while (i >= 0 && sortedScores[i] == t) {
                --i;
            }
            ++i;
        } else {
            i = -(i + 1);
        }
        return i;
    }

    protected static final double getWeight(double[] weight, int index) {
        if (weight == null) {
            return 1.0;
        }
        return weight[index];
    }

    public static boolean simpleWeights(double[] weight) {
        if (weight != null) {
            int i = 0;
            while (i < weight.length) {
                if (weight[i] != 1.0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

