/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences.annotation;

import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.results.CategoricalResult;
import java.util.LinkedList;

public class SimpleSequenceAnnotationParser
implements SequenceAnnotationParser {
    private LinkedList<SequenceAnnotation> annot = new LinkedList();
    private static final SequenceAnnotation[] empty = new SequenceAnnotation[0];
    private static final String TYPE = "unparsed comment line";

    @Override
    public void addToAnnotation(String unparsed) {
        this.annot.add(new SequenceAnnotation(TYPE, String.valueOf(this.annot.size()), new CategoricalResult("unparsed comment", "", unparsed.substring(1))));
    }

    @Override
    public void clearAnnotation() {
        this.annot.clear();
    }

    @Override
    public SequenceAnnotation[] getCurrentAnnotation() {
        return this.annot.size() == 0 ? null : this.annot.toArray(empty);
    }

    @Override
    public String parseAnnotationToComment(char commentChar, SequenceAnnotation ... annotations) {
        String simple = "" + commentChar;
        if (annotations == null || annotations.length == 0) {
            return simple;
        }
        StringBuffer res = new StringBuffer();
        String start = "";
        int i = 0;
        while (i < annotations.length) {
            if (annotations[i].getType().equals(TYPE) && annotations[i].getNumberOfResults() == 1 && annotations[i].getResultAt(0) instanceof CategoricalResult) {
                res.append(String.valueOf(start) + commentChar + annotations[i].getResultAt(0).getValue().toString());
                start = "\n";
            }
            ++i;
        }
        if (res.length() == 0) {
            return simple;
        }
        return res.toString();
    }
}

