/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sampling;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sampling.AbstractBurnInTest;
import de.jstacs.sampling.VarianceRatioBurnInTestParameterSet;
import de.jstacs.utils.DoubleList;

public class VarianceRatioBurnInTest
extends AbstractBurnInTest {
    private double threshold;

    public VarianceRatioBurnInTest(VarianceRatioBurnInTestParameterSet parameters) throws CloneNotSupportedException {
        super(parameters);
        this.threshold = parameters.getThreshold();
    }

    public VarianceRatioBurnInTest(StringBuffer rep) throws NonParsableException {
        super(rep);
    }

    @Override
    protected String getXMLTag() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer furtherinf = new StringBuffer(2000);
        XMLParser.appendObjectWithTags(furtherinf, this.threshold, "threshold");
        return furtherinf;
    }

    @Override
    protected void setFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.threshold = XMLParser.extractObjectForTags(xml, "threshold", Double.TYPE);
    }

    @Override
    public String getInstanceName() {
        return "Variance-Ratio burn-in test of Gelman and Rubin for " + this.values.length + " different chains with threshold " + this.threshold;
    }

    @Override
    protected int computeLengthOfBurnIn() {
        if (this.values[0].length() < 250) {
            return this.values[0].length();
        }
        int m = this.values.length;
        DoubleList meanOfchains = new DoubleList(m);
        int minL = this.values[0].length();
        int maxL = this.values[0].length();
        int i = 1;
        while (i < this.values.length) {
            if (this.values[i].length() < minL) {
                minL = this.values[i].length();
            }
            if (this.values[i].length() > maxL) {
                maxL = this.values[i].length();
            }
            ++i;
        }
        int it = 250;
        while (it < minL) {
            int n = it / 2;
            int start = it - n;
            meanOfchains.clear();
            int i2 = 0;
            while (i2 < m) {
                meanOfchains.add(this.values[i2].mean(start, it));
                ++i2;
            }
            double meanOfChainMeans = meanOfchains.mean(0, meanOfchains.length());
            double b = 0.0;
            int i3 = 0;
            while (i3 < m) {
                b += (meanOfchains.get(i3) - meanOfChainMeans) * (meanOfchains.get(i3) - meanOfChainMeans);
                ++i3;
            }
            b /= (double)m - 1.0;
            double w = 0.0;
            int i4 = 0;
            while (i4 < m) {
                int j = start;
                while (j < it) {
                    w += (this.values[i4].get(j) - meanOfchains.get(i4)) * (this.values[i4].get(j) - meanOfchains.get(i4));
                    ++j;
                }
                ++i4;
            }
            double sigma = (1.0 - 1.0 / (double)n) * (w /= (double)m * ((double)n - 1.0));
            double r = Math.sqrt((sigma += (1.0 + 1.0 / (double)m) * b) / w);
            if (r < this.threshold) {
                return it;
            }
            it += 2;
        }
        return maxL;
    }
}

