/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.swing.gvt.AbstractJGVTComponent;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.batik.swing.svg.AbstractJSVGComponent;
import org.apache.batik.swing.svg.GVTTreeBuilder;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.LinkActivationEvent;
import org.apache.batik.swing.svg.LinkActivationListener;
import org.apache.batik.swing.svg.Messages;
import org.apache.batik.swing.svg.SVGDocumentLoader;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGLoadEventDispatcher;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.swing.svg.SVGUpdateOverlay;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.SVGFeatureStrings;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class AbstractJSVGComponent
extends JGVTComponent {
    public static final int AUTODETECT = 0;
    public static final int ALWAYS_DYNAMIC = 1;
    public static final int ALWAYS_STATIC = 2;
    public static final int ALWAYS_INTERACTIVE = 3;
    public static final String SCRIPT_ALERT = "script.alert";
    public static final String SCRIPT_PROMPT = "script.prompt";
    public static final String SCRIPT_CONFIRM = "script.confirm";
    public static final String BROKEN_LINK_TITLE = "broken.link.title";
    protected SVGDocumentLoader documentLoader;
    protected SVGDocumentLoader nextDocumentLoader;
    protected DocumentLoader loader;
    protected GVTTreeBuilder gvtTreeBuilder;
    protected GVTTreeBuilder nextGVTTreeBuilder;
    protected SVGLoadEventDispatcher svgLoadEventDispatcher;
    protected UpdateManager updateManager;
    protected UpdateManager nextUpdateManager;
    protected SVGDocument svgDocument;
    protected List svgDocumentLoaderListeners = new LinkedList();
    protected List gvtTreeBuilderListeners = new LinkedList();
    protected List svgLoadEventDispatcherListeners = new LinkedList();
    protected List linkActivationListeners = new LinkedList();
    protected List updateManagerListeners = new LinkedList();
    protected UserAgent userAgent;
    protected SVGUserAgent svgUserAgent;
    protected BridgeContext bridgeContext;
    protected String fragmentIdentifier;
    protected boolean isDynamicDocument;
    protected boolean isInteractiveDocument;
    protected boolean selfCallingDisableInteractions = false;
    protected boolean userSetDisableInteractions = false;
    protected int documentState;
    protected Dimension prevComponentSize;
    protected Runnable afterStopRunnable = null;
    protected SVGUpdateOverlay updateOverlay;
    protected boolean recenterOnResize = true;
    protected AffineTransform viewingTransform = null;
    protected int animationLimitingMode;
    protected float animationLimitingAmount;
    protected JSVGComponentListener jsvgComponentListener = new JSVGComponentListener();
    protected static final Set FEATURES = new HashSet();

    public AbstractJSVGComponent() {
        this(null, false, false);
    }

    public AbstractJSVGComponent(SVGUserAgent ua, boolean eventsEnabled, boolean selectableText) {
        super(eventsEnabled, selectableText);
        this.svgUserAgent = ua;
        this.userAgent = new BridgeUserAgentWrapper(this.createUserAgent());
        this.addSVGDocumentLoaderListener((SVGListener)this.listener);
        this.addGVTTreeBuilderListener((SVGListener)this.listener);
        this.addSVGLoadEventDispatcherListener((SVGListener)this.listener);
        if (this.updateOverlay != null) {
            this.getOverlays().add(this.updateOverlay);
        }
    }

    public void dispose() {
        this.setSVGDocument(null);
    }

    public void setDisableInteractions(boolean b) {
        super.setDisableInteractions(b);
        if (!this.selfCallingDisableInteractions) {
            this.userSetDisableInteractions = true;
        }
    }

    public void clearUserSetDisableInteractions() {
        this.userSetDisableInteractions = false;
        this.updateZoomAndPanEnable(this.svgDocument);
    }

    public void updateZoomAndPanEnable(Document doc) {
        if (this.userSetDisableInteractions) {
            return;
        }
        if (doc == null) {
            return;
        }
        try {
            Element root = doc.getDocumentElement();
            String znp = root.getAttributeNS(null, "zoomAndPan");
            boolean enable = "magnify".equals(znp);
            this.selfCallingDisableInteractions = true;
            this.setDisableInteractions(!enable);
            Object var6_5 = null;
            this.selfCallingDisableInteractions = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.selfCallingDisableInteractions = false;
            throw throwable;
        }
    }

    public boolean getRecenterOnResize() {
        return this.recenterOnResize;
    }

    public void setRecenterOnResize(boolean recenterOnResize) {
        this.recenterOnResize = recenterOnResize;
    }

    public boolean isDynamic() {
        return this.isDynamicDocument;
    }

    public boolean isInteractive() {
        return this.isInteractiveDocument;
    }

    public void setDocumentState(int state) {
        this.documentState = state;
    }

    public UpdateManager getUpdateManager() {
        if (this.svgLoadEventDispatcher != null) {
            return this.svgLoadEventDispatcher.getUpdateManager();
        }
        if (this.nextUpdateManager != null) {
            return this.nextUpdateManager;
        }
        return this.updateManager;
    }

    public void resumeProcessing() {
        if (this.updateManager != null) {
            this.updateManager.resume();
        }
    }

    public void suspendProcessing() {
        if (this.updateManager != null) {
            this.updateManager.suspend();
        }
    }

    public void stopProcessing() {
        this.nextDocumentLoader = null;
        this.nextGVTTreeBuilder = null;
        if (this.documentLoader != null) {
            this.documentLoader.halt();
        }
        if (this.gvtTreeBuilder != null) {
            this.gvtTreeBuilder.halt();
        }
        if (this.svgLoadEventDispatcher != null) {
            this.svgLoadEventDispatcher.halt();
        }
        if (this.nextUpdateManager != null) {
            this.nextUpdateManager.interrupt();
            this.nextUpdateManager = null;
        }
        if (this.updateManager != null) {
            this.updateManager.interrupt();
        }
        super.stopProcessing();
    }

    public void loadSVGDocument(String url) {
        String oldURI = null;
        if (this.svgDocument != null) {
            oldURI = this.svgDocument.getURL();
        }
        final ParsedURL newURI = new ParsedURL(oldURI, url);
        this.stopThenRun(new Runnable(){

            public void run() {
                String url = newURI.toString();
                AbstractJSVGComponent.this.fragmentIdentifier = newURI.getRef();
                AbstractJSVGComponent.this.loader = new DocumentLoader(AbstractJSVGComponent.this.userAgent);
                AbstractJSVGComponent.this.nextDocumentLoader = new SVGDocumentLoader(url, AbstractJSVGComponent.this.loader);
                AbstractJSVGComponent.this.nextDocumentLoader.setPriority(1);
                Iterator it = AbstractJSVGComponent.this.svgDocumentLoaderListeners.iterator();
                while (it.hasNext()) {
                    AbstractJSVGComponent.this.nextDocumentLoader.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)it.next());
                }
                AbstractJSVGComponent.this.startDocumentLoader();
            }
        });
    }

    private void startDocumentLoader() {
        this.documentLoader = this.nextDocumentLoader;
        this.nextDocumentLoader = null;
        this.documentLoader.start();
    }

    public void setDocument(Document doc) {
        if (doc != null && !(doc.getImplementation() instanceof SVGDOMImplementation)) {
            Document d;
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            doc = d = DOMUtilities.deepCloneDocument(doc, impl);
        }
        this.setSVGDocument((SVGDocument)doc);
    }

    public void setSVGDocument(SVGDocument doc) {
        if (doc != null && !(doc.getImplementation() instanceof SVGDOMImplementation)) {
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            Document d = DOMUtilities.deepCloneDocument(doc, impl);
            doc = (SVGDocument)d;
        }
        final SVGDocument svgdoc = doc;
        this.stopThenRun(new Runnable(){

            public void run() {
                AbstractJSVGComponent.this.installSVGDocument(svgdoc);
            }
        });
    }

    protected void stopThenRun(Runnable r) {
        if (this.afterStopRunnable != null) {
            this.afterStopRunnable = r;
            return;
        }
        this.afterStopRunnable = r;
        this.stopProcessing();
        if (this.documentLoader == null && this.gvtTreeBuilder == null && this.gvtTreeRenderer == null && this.svgLoadEventDispatcher == null && this.nextUpdateManager == null && this.updateManager == null) {
            Runnable asr = this.afterStopRunnable;
            this.afterStopRunnable = null;
            asr.run();
        }
    }

    protected void installSVGDocument(SVGDocument doc) {
        this.svgDocument = doc;
        if (this.bridgeContext != null) {
            this.bridgeContext.dispose();
            this.bridgeContext = null;
        }
        this.releaseRenderingReferences();
        if (doc == null) {
            this.isDynamicDocument = false;
            this.isInteractiveDocument = false;
            this.disableInteractions = true;
            this.initialTransform = new AffineTransform();
            this.setRenderingTransform(this.initialTransform, false);
            Rectangle vRect = this.getRenderRect();
            this.repaint(vRect.x, vRect.y, vRect.width, vRect.height);
            return;
        }
        this.bridgeContext = this.createBridgeContext((SVGOMDocument)doc);
        switch (this.documentState) {
            case 2: {
                this.isDynamicDocument = false;
                this.isInteractiveDocument = false;
                break;
            }
            case 3: {
                this.isDynamicDocument = false;
                this.isInteractiveDocument = true;
                break;
            }
            case 1: {
                this.isDynamicDocument = true;
                this.isInteractiveDocument = true;
                break;
            }
            case 0: {
                this.isDynamicDocument = this.bridgeContext.isDynamicDocument(doc);
                boolean bl = this.isInteractiveDocument = this.isDynamicDocument || this.bridgeContext.isInteractiveDocument(doc);
            }
        }
        if (this.isInteractiveDocument) {
            if (this.isDynamicDocument) {
                this.bridgeContext.setDynamicState(2);
            } else {
                this.bridgeContext.setDynamicState(1);
            }
        }
        this.setBridgeContextAnimationLimitingMode();
        this.updateZoomAndPanEnable(doc);
        this.nextGVTTreeBuilder = new GVTTreeBuilder(doc, this.bridgeContext);
        this.nextGVTTreeBuilder.setPriority(1);
        Iterator it = this.gvtTreeBuilderListeners.iterator();
        while (it.hasNext()) {
            this.nextGVTTreeBuilder.addGVTTreeBuilderListener((GVTTreeBuilderListener)it.next());
        }
        this.initializeEventHandling();
        if (this.gvtTreeBuilder == null && this.documentLoader == null && this.gvtTreeRenderer == null && this.svgLoadEventDispatcher == null && this.updateManager == null) {
            this.startGVTTreeBuilder();
        }
    }

    protected void startGVTTreeBuilder() {
        this.gvtTreeBuilder = this.nextGVTTreeBuilder;
        this.nextGVTTreeBuilder = null;
        this.gvtTreeBuilder.start();
    }

    public SVGDocument getSVGDocument() {
        return this.svgDocument;
    }

    public Dimension2D getSVGDocumentSize() {
        return this.bridgeContext.getDocumentSize();
    }

    public String getFragmentIdentifier() {
        return this.fragmentIdentifier;
    }

    public void setFragmentIdentifier(String fi) {
        this.fragmentIdentifier = fi;
        if (this.computeRenderingTransform()) {
            this.scheduleGVTRendering();
        }
    }

    public void flushImageCache() {
        ImageTagRegistry reg = ImageTagRegistry.getRegistry();
        reg.flushCache();
    }

    public void setGraphicsNode(GraphicsNode gn, boolean createDispatcher) {
        Dimension2D dim = this.bridgeContext.getDocumentSize();
        Dimension mySz = new Dimension((int)dim.getWidth(), (int)dim.getHeight());
        this.setMySize(mySz);
        SVGSVGElement elt = this.svgDocument.getRootElement();
        this.prevComponentSize = this.getSize();
        AffineTransform at = this.calculateViewingTransform(this.fragmentIdentifier, elt);
        CanvasGraphicsNode cgn = this.getCanvasGraphicsNode(gn);
        cgn.setViewingTransform(at);
        this.viewingTransform = null;
        this.initialTransform = new AffineTransform();
        this.setRenderingTransform(this.initialTransform, false);
        this.jsvgComponentListener.updateMatrix(this.initialTransform);
        this.addJGVTComponentListener(this.jsvgComponentListener);
        this.addComponentListener(this.jsvgComponentListener);
        super.setGraphicsNode(gn, createDispatcher);
    }

    protected BridgeContext createBridgeContext(SVGOMDocument doc) {
        if (this.loader == null) {
            this.loader = new DocumentLoader(this.userAgent);
        }
        BridgeContext result = doc.isSVG12() ? new SVG12BridgeContext(this.userAgent, this.loader) : new BridgeContext(this.userAgent, this.loader);
        return result;
    }

    protected void startSVGLoadEventDispatcher(GraphicsNode root) {
        UpdateManager um = new UpdateManager(this.bridgeContext, root, this.svgDocument);
        this.svgLoadEventDispatcher = new SVGLoadEventDispatcher(root, this.svgDocument, this.bridgeContext, um);
        Iterator it = this.svgLoadEventDispatcherListeners.iterator();
        while (it.hasNext()) {
            this.svgLoadEventDispatcher.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)it.next());
        }
        this.svgLoadEventDispatcher.start();
    }

    protected ImageRenderer createImageRenderer() {
        if (this.isDynamicDocument) {
            return this.rendererFactory.createDynamicImageRenderer();
        }
        return this.rendererFactory.createStaticImageRenderer();
    }

    public CanvasGraphicsNode getCanvasGraphicsNode() {
        return this.getCanvasGraphicsNode(this.gvtRoot);
    }

    protected CanvasGraphicsNode getCanvasGraphicsNode(GraphicsNode gn) {
        if (!(gn instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode cgn = (CompositeGraphicsNode)gn;
        List children = cgn.getChildren();
        if (children.size() == 0) {
            return null;
        }
        gn = (GraphicsNode)children.get(0);
        if (!(gn instanceof CanvasGraphicsNode)) {
            return null;
        }
        return (CanvasGraphicsNode)gn;
    }

    public AffineTransform getViewingTransform() {
        AffineTransform vt;
        AbstractJSVGComponent abstractJSVGComponent = this;
        synchronized (abstractJSVGComponent) {
            CanvasGraphicsNode cgn;
            vt = this.viewingTransform;
            if (vt == null && (cgn = this.getCanvasGraphicsNode()) != null) {
                vt = cgn.getViewingTransform();
            }
        }
        return vt;
    }

    public AffineTransform getViewBoxTransform() {
        AffineTransform at = this.getRenderingTransform();
        at = at == null ? new AffineTransform() : new AffineTransform(at);
        AffineTransform vt = this.getViewingTransform();
        if (vt != null) {
            at.concatenate(vt);
        }
        return at;
    }

    protected boolean computeRenderingTransform() {
        if (this.svgDocument == null || this.gvtRoot == null) {
            return false;
        }
        boolean ret = this.updateRenderingTransform();
        this.initialTransform = new AffineTransform();
        if (!this.initialTransform.equals(this.getRenderingTransform())) {
            this.setRenderingTransform(this.initialTransform, false);
            ret = true;
        }
        return ret;
    }

    protected AffineTransform calculateViewingTransform(String fragIdent, SVGSVGElement svgElt) {
        Dimension d = this.getSize();
        if (d.width < 1) {
            d.width = 1;
        }
        if (d.height < 1) {
            d.height = 1;
        }
        return ViewBox.getViewTransform(fragIdent, svgElt, d.width, d.height, this.bridgeContext);
    }

    protected boolean updateRenderingTransform() {
        if (this.svgDocument == null || this.gvtRoot == null) {
            return false;
        }
        try {
            AffineTransform vt;
            AffineTransform at;
            SVGSVGElement elt = this.svgDocument.getRootElement();
            Dimension d = this.getSize();
            Dimension oldD = this.prevComponentSize;
            if (oldD == null) {
                oldD = d;
            }
            this.prevComponentSize = d;
            if (d.width < 1) {
                d.width = 1;
            }
            if (d.height < 1) {
                d.height = 1;
            }
            if ((at = this.calculateViewingTransform(this.fragmentIdentifier, elt)).equals(vt = this.getViewingTransform())) {
                return oldD.width != d.width || oldD.height != d.height;
            }
            if (!this.recenterOnResize) {
                return true;
            }
            Point2D pt = new Point2D.Float((float)oldD.width / 2.0f, (float)oldD.height / 2.0f);
            AffineTransform rendAT = this.getRenderingTransform();
            if (rendAT != null) {
                try {
                    AffineTransform invRendAT = rendAT.createInverse();
                    pt = invRendAT.transform(pt, null);
                }
                catch (NoninvertibleTransformException e) {
                    // empty catch block
                }
            }
            if (vt != null) {
                try {
                    AffineTransform invVT = vt.createInverse();
                    pt = invVT.transform(pt, null);
                }
                catch (NoninvertibleTransformException e) {
                    // empty catch block
                }
            }
            if (at != null) {
                pt = at.transform(pt, null);
            }
            if (rendAT != null) {
                pt = rendAT.transform(pt, null);
            }
            float dx = (float)((double)((float)d.width / 2.0f) - pt.getX());
            float dy = (float)((double)((float)d.height / 2.0f) - pt.getY());
            dx = dx < 0.0f ? (int)((double)dx - 0.5) : (int)((double)dx + 0.5);
            dy = dy < 0.0f ? (int)((double)dy - 0.5) : (int)((double)dy + 0.5);
            if (dx != 0.0f || dy != 0.0f) {
                rendAT.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
                this.setRenderingTransform(rendAT, false);
            }
            AbstractJSVGComponent abstractJSVGComponent = this;
            synchronized (abstractJSVGComponent) {
                this.viewingTransform = at;
            }
            Runnable r = new Runnable(at){
                AffineTransform myAT;
                CanvasGraphicsNode myCGN;
                private final /* synthetic */ AffineTransform val$at;
                {
                    this.myAT = this.val$at = val$at;
                    this.myCGN = AbstractJSVGComponent.this.getCanvasGraphicsNode();
                }

                public void run() {
                    AbstractJSVGComponent abstractJSVGComponent = AbstractJSVGComponent.this;
                    synchronized (abstractJSVGComponent) {
                        this.myCGN.setViewingTransform(this.myAT);
                        if (AbstractJSVGComponent.this.viewingTransform == this.myAT) {
                            AbstractJSVGComponent.this.viewingTransform = null;
                        }
                    }
                }
            };
            UpdateManager um = this.getUpdateManager();
            if (um != null) {
                um.getUpdateRunnableQueue().invokeLater(r);
            } else {
                r.run();
            }
        }
        catch (BridgeException e) {
            this.userAgent.displayError(e);
        }
        return true;
    }

    protected void renderGVTTree() {
        class UpdateRenderingRunnable
        implements Runnable {
            AffineTransform at;
            boolean doubleBuf;
            boolean clearPaintTrans;
            Shape aoi;
            int width;
            int height;
            boolean active;
            private final /* synthetic */ AbstractJSVGComponent this$0;

            public UpdateRenderingRunnable(AbstractJSVGComponent this$0, AffineTransform at, boolean doubleBuf, boolean clearPaintTrans, Shape aoi, int width, int height) {
                this.this$0 = this$0;
                this.updateInfo(at, doubleBuf, clearPaintTrans, aoi, width, height);
                this.active = true;
            }

            public void updateInfo(AffineTransform at, boolean doubleBuf, boolean clearPaintTrans, Shape aoi, int width, int height) {
                this.at = at;
                this.doubleBuf = doubleBuf;
                this.clearPaintTrans = clearPaintTrans;
                this.aoi = aoi;
                this.width = width;
                this.height = height;
                this.active = true;
            }

            public void deactivate() {
                this.active = false;
            }

            public void run() {
                if (!this.active) {
                    return;
                }
                this.this$0.updateManager.updateRendering(this.at, this.doubleBuf, this.clearPaintTrans, this.aoi, this.width, this.height);
            }
        }
        if (!this.isInteractiveDocument || this.updateManager == null || !this.updateManager.isRunning()) {
            super.renderGVTTree();
            return;
        }
        Rectangle visRect = this.getRenderRect();
        if (this.gvtRoot == null || visRect.width <= 0 || visRect.height <= 0) {
            return;
        }
        AffineTransform inv = null;
        try {
            inv = this.renderingTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        Shape s = inv == null ? visRect : inv.createTransformedShape(visRect);
        RunnableQueue rq = this.updateManager.getUpdateRunnableQueue();
        Object object = rq.getIteratorLock();
        synchronized (object) {
            Iterator it = rq.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof UpdateRenderingRunnable)) continue;
                ((UpdateRenderingRunnable)next).deactivate();
            }
        }
        rq.invokeLater(new UpdateRenderingRunnable(this, this.renderingTransform, this.doubleBufferedRendering, true, s, visRect.width, visRect.height));
    }

    protected void handleException(Exception e) {
        this.userAgent.displayError(e);
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener l) {
        this.svgDocumentLoaderListeners.add(l);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener l) {
        this.svgDocumentLoaderListeners.remove(l);
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.gvtTreeBuilderListeners.add(l);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.gvtTreeBuilderListeners.remove(l);
    }

    public void addSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener l) {
        this.svgLoadEventDispatcherListeners.add(l);
    }

    public void removeSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener l) {
        this.svgLoadEventDispatcherListeners.remove(l);
    }

    public void addLinkActivationListener(LinkActivationListener l) {
        this.linkActivationListeners.add(l);
    }

    public void removeLinkActivationListener(LinkActivationListener l) {
        this.linkActivationListeners.remove(l);
    }

    public void addUpdateManagerListener(UpdateManagerListener l) {
        this.updateManagerListeners.add(l);
    }

    public void removeUpdateManagerListener(UpdateManagerListener l) {
        this.updateManagerListeners.remove(l);
    }

    public void showAlert(String message) {
        JOptionPane.showMessageDialog(this, Messages.formatMessage(SCRIPT_ALERT, new Object[]{message}));
    }

    public String showPrompt(String message) {
        return JOptionPane.showInputDialog(this, (Object)Messages.formatMessage(SCRIPT_PROMPT, new Object[]{message}));
    }

    public String showPrompt(String message, String defaultValue) {
        return (String)JOptionPane.showInputDialog(this, Messages.formatMessage(SCRIPT_PROMPT, new Object[]{message}), null, -1, null, null, defaultValue);
    }

    public boolean showConfirm(String message) {
        return JOptionPane.showConfirmDialog(this, Messages.formatMessage(SCRIPT_CONFIRM, new Object[]{message}), "Confirm", 0) == 0;
    }

    public void setMySize(Dimension d) {
        this.setPreferredSize(d);
        this.invalidate();
    }

    public void setAnimationLimitingNone() {
        this.animationLimitingMode = 0;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    public void setAnimationLimitingCPU(float pc) {
        this.animationLimitingMode = 1;
        this.animationLimitingAmount = pc;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    public void setAnimationLimitingFPS(float fps) {
        this.animationLimitingMode = 2;
        this.animationLimitingAmount = fps;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    protected void setBridgeContextAnimationLimitingMode() {
        switch (this.animationLimitingMode) {
            case 0: {
                this.bridgeContext.setAnimationLimitingNone();
                break;
            }
            case 1: {
                this.bridgeContext.setAnimationLimitingCPU(this.animationLimitingAmount);
                break;
            }
            case 2: {
                this.bridgeContext.setAnimationLimitingFPS(this.animationLimitingAmount);
            }
        }
    }

    protected AbstractJGVTComponent.Listener createListener() {
        return new SVGListener();
    }

    protected UserAgent createUserAgent() {
        return new BridgeUserAgent();
    }

    static /* synthetic */ boolean access$1103(AbstractJSVGComponent x0, boolean x1) {
        x0.suspendInteractions = x1;
        return x0.suspendInteractions;
    }

    static /* synthetic */ boolean access$1201(AbstractJSVGComponent x0) {
        return x0.doubleBufferedRendering;
    }

    static /* synthetic */ BufferedImage access$1303(AbstractJSVGComponent x0, BufferedImage x1) {
        x0.image = x1;
        return x0.image;
    }

    static /* synthetic */ BufferedImage access$1403(AbstractJSVGComponent x0, BufferedImage x1) {
        x0.image = x1;
        return x0.image;
    }

    static /* synthetic */ AffineTransform access$1503(AbstractJSVGComponent x0, AffineTransform x1) {
        x0.paintingTransform = x1;
        return x0.paintingTransform;
    }

    static /* synthetic */ boolean access$1601(AbstractJSVGComponent x0) {
        return x0.doubleBufferedRendering;
    }

    static /* synthetic */ boolean access$1703(AbstractJSVGComponent x0, boolean x1) {
        x0.suspendInteractions = x1;
        return x0.suspendInteractions;
    }

    static /* synthetic */ AWTEventDispatcher access$1801(AbstractJSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$1901(AbstractJSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2001(AbstractJSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2101(AbstractJSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2201(AbstractJSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2301(AbstractJSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2401(AbstractJSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2501(AbstractJSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2601(AbstractJSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2701(AbstractJSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static {
        SVGFeatureStrings.addSupportedFeatureStrings(FEATURES);
    }

    protected class BridgeUserAgent
    implements UserAgent {
        protected Map extensions = new HashMap();
        static /* synthetic */ Class class$org$apache$batik$swing$svg$AbstractJSVGComponent;

        protected BridgeUserAgent() {
        }

        public Dimension2D getViewportSize() {
            return AbstractJSVGComponent.this.getSize();
        }

        public EventDispatcher getEventDispatcher() {
            return AbstractJSVGComponent.this.eventDispatcher;
        }

        public void displayError(String message) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.displayError(message);
            }
        }

        public void displayError(Exception ex) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.displayError(ex);
            }
        }

        public void displayMessage(String message) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.displayMessage(message);
            }
        }

        public void showAlert(String message) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.showAlert(message);
                return;
            }
            AbstractJSVGComponent.this.showAlert(message);
        }

        public String showPrompt(String message) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.showPrompt(message);
            }
            return AbstractJSVGComponent.this.showPrompt(message);
        }

        public String showPrompt(String message, String defaultValue) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.showPrompt(message, defaultValue);
            }
            return AbstractJSVGComponent.this.showPrompt(message, defaultValue);
        }

        public boolean showConfirm(String message) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.showConfirm(message);
            }
            return AbstractJSVGComponent.this.showConfirm(message);
        }

        public float getPixelUnitToMillimeter() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getPixelUnitToMillimeter();
            }
            return 0.26458332f;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public String getDefaultFontFamily() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getDefaultFontFamily();
            }
            return "Arial, Helvetica, sans-serif";
        }

        public float getMediumFontSize() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getMediumFontSize();
            }
            return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
        }

        public float getLighterFontWeight(float f) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getLighterFontWeight(f);
            }
            int weight = (int)((f + 50.0f) / 100.0f) * 100;
            switch (weight) {
                case 100: {
                    return 100.0f;
                }
                case 200: {
                    return 100.0f;
                }
                case 300: {
                    return 200.0f;
                }
                case 400: {
                    return 300.0f;
                }
                case 500: {
                    return 400.0f;
                }
                case 600: {
                    return 400.0f;
                }
                case 700: {
                    return 400.0f;
                }
                case 800: {
                    return 400.0f;
                }
                case 900: {
                    return 400.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public float getBolderFontWeight(float f) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getBolderFontWeight(f);
            }
            int weight = (int)((f + 50.0f) / 100.0f) * 100;
            switch (weight) {
                case 100: {
                    return 600.0f;
                }
                case 200: {
                    return 600.0f;
                }
                case 300: {
                    return 600.0f;
                }
                case 400: {
                    return 600.0f;
                }
                case 500: {
                    return 600.0f;
                }
                case 600: {
                    return 700.0f;
                }
                case 700: {
                    return 800.0f;
                }
                case 800: {
                    return 900.0f;
                }
                case 900: {
                    return 900.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public String getLanguages() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getLanguages();
            }
            return "en";
        }

        public String getUserStyleSheetURI() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getUserStyleSheetURI();
            }
            return null;
        }

        public void openLink(SVGAElement elt) {
            ParsedURL oldURI;
            String show = XLinkSupport.getXLinkShow(elt);
            String href = elt.getHref().getAnimVal();
            if (show.equals("new")) {
                this.fireLinkActivatedEvent(elt, href);
                if (AbstractJSVGComponent.this.svgUserAgent != null) {
                    String oldURI2 = AbstractJSVGComponent.this.svgDocument.getURL();
                    ParsedURL newURI = null;
                    if (elt.getOwnerDocument() != AbstractJSVGComponent.this.svgDocument) {
                        SVGDocument doc = (SVGDocument)elt.getOwnerDocument();
                        href = new ParsedURL(doc.getURL(), href).toString();
                    }
                    newURI = new ParsedURL(oldURI2, href);
                    href = newURI.toString();
                    AbstractJSVGComponent.this.svgUserAgent.openLink(href, true);
                } else {
                    AbstractJSVGComponent.this.loadSVGDocument(href);
                }
                return;
            }
            ParsedURL newURI = new ParsedURL(((SVGDocument)elt.getOwnerDocument()).getURL(), href);
            href = newURI.toString();
            if (AbstractJSVGComponent.this.svgDocument != null && newURI.sameFile(oldURI = new ParsedURL(AbstractJSVGComponent.this.svgDocument.getURL()))) {
                String s = newURI.getRef();
                if (!(AbstractJSVGComponent.this.fragmentIdentifier == s || s != null && s.equals(AbstractJSVGComponent.this.fragmentIdentifier))) {
                    AbstractJSVGComponent.this.fragmentIdentifier = s;
                    if (AbstractJSVGComponent.this.computeRenderingTransform()) {
                        AbstractJSVGComponent.super.scheduleGVTRendering();
                    }
                }
                this.fireLinkActivatedEvent(elt, href);
                return;
            }
            this.fireLinkActivatedEvent(elt, href);
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.openLink(href, false);
            } else {
                AbstractJSVGComponent.this.loadSVGDocument(href);
            }
        }

        protected void fireLinkActivatedEvent(SVGAElement elt, String href) {
            Object[] ll = AbstractJSVGComponent.this.linkActivationListeners.toArray();
            if (ll.length > 0) {
                LinkActivationEvent ev = new LinkActivationEvent(AbstractJSVGComponent.this, elt, href);
                int i = 0;
                while (i < ll.length) {
                    LinkActivationListener l = (LinkActivationListener)ll[i];
                    l.linkActivated(ev);
                    ++i;
                }
            }
        }

        public void setSVGCursor(Cursor cursor) {
            if (cursor != AbstractJSVGComponent.this.getCursor()) {
                AbstractJSVGComponent.this.setCursor(cursor);
            }
        }

        public void setTextSelection(Mark start, Mark end) {
            AbstractJSVGComponent.this.select(start, end);
        }

        public void deselectAll() {
            AbstractJSVGComponent.this.deselectAll();
        }

        public String getXMLParserClassName() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getXMLParserClassName();
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.isXMLParserValidating();
            }
            return false;
        }

        public AffineTransform getTransform() {
            return AbstractJSVGComponent.this.renderingTransform;
        }

        public void setTransform(AffineTransform at) {
            AbstractJSVGComponent.this.setRenderingTransform(at);
        }

        public String getMedia() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getMedia();
            }
            return "screen";
        }

        public String getAlternateStyleSheet() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getAlternateStyleSheet();
            }
            return null;
        }

        public Point getClientAreaLocationOnScreen() {
            return AbstractJSVGComponent.this.getLocationOnScreen();
        }

        public boolean hasFeature(String s) {
            return FEATURES.contains(s);
        }

        public boolean supportExtension(String s) {
            if (AbstractJSVGComponent.this.svgUserAgent != null && AbstractJSVGComponent.this.svgUserAgent.supportExtension(s)) {
                return true;
            }
            return this.extensions.containsKey(s);
        }

        public void registerExtension(BridgeExtension ext) {
            Iterator i = ext.getImplementedExtensions();
            while (i.hasNext()) {
                this.extensions.put(i.next(), ext);
            }
        }

        public void handleElement(Element elt, Object data) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.handleElement(elt, data);
            }
        }

        public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptURL, ParsedURL docURL) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getScriptSecurity(scriptType, scriptURL, docURL);
            }
            return new DefaultScriptSecurity(scriptType, scriptURL, docURL);
        }

        public void checkLoadScript(String scriptType, ParsedURL scriptURL, ParsedURL docURL) throws SecurityException {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.checkLoadScript(scriptType, scriptURL, docURL);
            } else {
                ScriptSecurity s = this.getScriptSecurity(scriptType, scriptURL, docURL);
                if (s != null) {
                    s.checkLoadScript();
                }
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourceURL, ParsedURL docURL) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getExternalResourceSecurity(resourceURL, docURL);
            }
            return new RelaxedExternalResourceSecurity(resourceURL, docURL);
        }

        public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.checkLoadExternalResource(resourceURL, docURL);
            } else {
                ExternalResourceSecurity s = this.getExternalResourceSecurity(resourceURL, docURL);
                if (s != null) {
                    s.checkLoadExternalResource();
                }
            }
        }

        public SVGDocument getBrokenLinkDocument(Element e, String url, String message) {
            Class cls = class$org$apache$batik$swing$svg$AbstractJSVGComponent == null ? (class$org$apache$batik$swing$svg$AbstractJSVGComponent = BridgeUserAgent.class$("org.apache.batik.swing.svg.AbstractJSVGComponent")) : class$org$apache$batik$swing$svg$AbstractJSVGComponent;
            URL blURL = cls.getResource("resources/BrokenLink.svg");
            if (blURL == null) {
                throw new BridgeException(AbstractJSVGComponent.this.bridgeContext, e, "uri.image.broken", new Object[]{url, message});
            }
            DocumentLoader loader = AbstractJSVGComponent.this.bridgeContext.getDocumentLoader();
            SVGDocument doc = null;
            try {
                doc = (SVGDocument)loader.loadDocument(blURL.toString());
                if (doc == null) {
                    return doc;
                }
                DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
                Element infoE = (doc = (SVGDocument)DOMUtilities.deepCloneDocument(doc, impl)).getElementById("__More_About");
                if (infoE == null) {
                    return doc;
                }
                Element titleE = doc.createElementNS("http://www.w3.org/2000/svg", "title");
                String title = Messages.formatMessage(AbstractJSVGComponent.BROKEN_LINK_TITLE, null);
                titleE.appendChild(doc.createTextNode(title));
                Element descE = doc.createElementNS("http://www.w3.org/2000/svg", "desc");
                descE.appendChild(doc.createTextNode(message));
                infoE.insertBefore(descE, infoE.getFirstChild());
                infoE.insertBefore(titleE, descE);
            }
            catch (Exception ex) {
                throw new BridgeException(AbstractJSVGComponent.this.bridgeContext, e, ex, "uri.image.broken", new Object[]{url, message});
            }
            return doc;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    protected static class BridgeUserAgentWrapper
    implements UserAgent {
        protected UserAgent userAgent;

        public BridgeUserAgentWrapper(UserAgent ua) {
            this.userAgent = ua;
        }

        public EventDispatcher getEventDispatcher() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getEventDispatcher();
            }
            class Query
            implements Runnable {
                EventDispatcher result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getEventDispatcher();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public Dimension2D getViewportSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getViewportSize();
            }
            class Query
            implements Runnable {
                Dimension2D result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getViewportSize();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public void displayError(Exception ex) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayError(ex);
            } else {
                EventQueue.invokeLater(new Runnable(this, ex){
                    private final /* synthetic */ Exception val$ex;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$ex = val$ex;
                    }

                    public void run() {
                        this.this$0.userAgent.displayError(this.val$ex);
                    }
                });
            }
        }

        public void displayMessage(String message) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayMessage(message);
            } else {
                EventQueue.invokeLater(new Runnable(this, message){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$message = val$message;
                    }

                    public void run() {
                        this.this$0.userAgent.displayMessage(this.val$message);
                    }
                });
            }
        }

        public void showAlert(String message) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.showAlert(message);
            } else {
                this.invokeAndWait(new Runnable(this, message){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$message = val$message;
                    }

                    public void run() {
                        this.this$0.userAgent.showAlert(this.val$message);
                    }
                });
            }
        }

        public String showPrompt(String message) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(message);
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$message) {
                    this.this$0 = this$0;
                    this.val$message = val$message;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showPrompt(this.val$message);
                }
            }
            Query q = new Query(this, message);
            this.invokeAndWait(q);
            return q.result;
        }

        public String showPrompt(String message, String defaultValue) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(message, defaultValue);
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ String val$defaultValue;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$message, String val$defaultValue) {
                    this.this$0 = this$0;
                    this.val$message = val$message;
                    this.val$defaultValue = val$defaultValue;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showPrompt(this.val$message, this.val$defaultValue);
                }
            }
            Query q = new Query(this, message, defaultValue);
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean showConfirm(String message) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showConfirm(message);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$message) {
                    this.this$0 = this$0;
                    this.val$message = val$message;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showConfirm(this.val$message);
                }
            }
            Query q = new Query(this, message);
            this.invokeAndWait(q);
            return q.result;
        }

        public float getPixelUnitToMillimeter() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getPixelUnitToMillimeter();
            }
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getPixelUnitToMillimeter();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public String getDefaultFontFamily() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getDefaultFontFamily();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getDefaultFontFamily();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public float getMediumFontSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMediumFontSize();
            }
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getMediumFontSize();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public float getLighterFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLighterFontWeight(f);
            }
            float ff = f;
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ float val$ff;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, float val$ff) {
                    this.this$0 = this$0;
                    this.val$ff = val$ff;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getLighterFontWeight(this.val$ff);
                }
            }
            Query q = new Query(this, ff);
            this.invokeAndWait(q);
            return q.result;
        }

        public float getBolderFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getBolderFontWeight(f);
            }
            float ff = f;
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ float val$ff;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, float val$ff) {
                    this.this$0 = this$0;
                    this.val$ff = val$ff;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getBolderFontWeight(this.val$ff);
                }
            }
            Query q = new Query(this, ff);
            this.invokeAndWait(q);
            return q.result;
        }

        public String getLanguages() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLanguages();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getLanguages();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public String getUserStyleSheetURI() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getUserStyleSheetURI();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getUserStyleSheetURI();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public void openLink(SVGAElement elt) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.openLink(elt);
            } else {
                EventQueue.invokeLater(new Runnable(this, elt){
                    private final /* synthetic */ SVGAElement val$elt;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$elt = val$elt;
                    }

                    public void run() {
                        this.this$0.userAgent.openLink(this.val$elt);
                    }
                });
            }
        }

        public void setSVGCursor(Cursor cursor) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setSVGCursor(cursor);
            } else {
                EventQueue.invokeLater(new Runnable(this, cursor){
                    private final /* synthetic */ Cursor val$cursor;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$cursor = val$cursor;
                    }

                    public void run() {
                        this.this$0.userAgent.setSVGCursor(this.val$cursor);
                    }
                });
            }
        }

        public void setTextSelection(Mark start, Mark end) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setTextSelection(start, end);
            } else {
                EventQueue.invokeLater(new Runnable(this, start, end){
                    private final /* synthetic */ Mark val$start;
                    private final /* synthetic */ Mark val$end;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$start = val$start;
                        this.val$end = val$end;
                    }

                    public void run() {
                        this.this$0.userAgent.setTextSelection(this.val$start, this.val$end);
                    }
                });
            }
        }

        public void deselectAll() {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.deselectAll();
            } else {
                EventQueue.invokeLater(new Runnable(this){
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        this.this$0.userAgent.deselectAll();
                    }
                });
            }
        }

        public String getXMLParserClassName() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getXMLParserClassName();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getXMLParserClassName();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean isXMLParserValidating() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.isXMLParserValidating();
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.isXMLParserValidating();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public AffineTransform getTransform() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getTransform();
            }
            class Query
            implements Runnable {
                AffineTransform result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getTransform();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public void setTransform(AffineTransform at) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setTransform(at);
            } else {
                AffineTransform affine = at;
                class Query
                implements Runnable {
                    private final /* synthetic */ AffineTransform val$affine;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;

                    Query(BridgeUserAgentWrapper this$0, AffineTransform val$affine) {
                        this.this$0 = this$0;
                        this.val$affine = val$affine;
                    }

                    public void run() {
                        this.this$0.userAgent.setTransform(this.val$affine);
                    }
                }
                Query q = new Query(this, affine);
                this.invokeAndWait(q);
            }
        }

        public String getMedia() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMedia();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getMedia();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public String getAlternateStyleSheet() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getAlternateStyleSheet();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getAlternateStyleSheet();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public Point getClientAreaLocationOnScreen() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getClientAreaLocationOnScreen();
            }
            class Query
            implements Runnable {
                Point result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getClientAreaLocationOnScreen();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean hasFeature(String s) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.hasFeature(s);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$s;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$s) {
                    this.this$0 = this$0;
                    this.val$s = val$s;
                }

                public void run() {
                    this.result = this.this$0.userAgent.hasFeature(this.val$s);
                }
            }
            Query q = new Query(this, s);
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean supportExtension(String s) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.supportExtension(s);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$s;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$s) {
                    this.this$0 = this$0;
                    this.val$s = val$s;
                }

                public void run() {
                    this.result = this.this$0.userAgent.supportExtension(this.val$s);
                }
            }
            Query q = new Query(this, s);
            this.invokeAndWait(q);
            return q.result;
        }

        public void registerExtension(BridgeExtension ext) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.registerExtension(ext);
            } else {
                EventQueue.invokeLater(new Runnable(this, ext){
                    private final /* synthetic */ BridgeExtension val$ext;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$ext = val$ext;
                    }

                    public void run() {
                        this.this$0.userAgent.registerExtension(this.val$ext);
                    }
                });
            }
        }

        public void handleElement(Element elt, Object data) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.handleElement(elt, data);
            } else {
                EventQueue.invokeLater(new Runnable(this, elt, data){
                    private final /* synthetic */ Element val$elt;
                    private final /* synthetic */ Object val$data;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$elt = val$elt;
                        this.val$data = val$data;
                    }

                    public void run() {
                        this.this$0.userAgent.handleElement(this.val$elt, this.val$data);
                    }
                });
            }
        }

        public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptPURL, ParsedURL docPURL) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getScriptSecurity(scriptType, scriptPURL, docPURL);
            }
            String st = scriptType;
            ParsedURL sPURL = scriptPURL;
            ParsedURL dPURL = docPURL;
            class Query
            implements Runnable {
                ScriptSecurity result;
                private final /* synthetic */ String val$st;
                private final /* synthetic */ ParsedURL val$sPURL;
                private final /* synthetic */ ParsedURL val$dPURL;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$st, ParsedURL val$sPURL, ParsedURL val$dPURL) {
                    this.this$0 = this$0;
                    this.val$st = val$st;
                    this.val$sPURL = val$sPURL;
                    this.val$dPURL = val$dPURL;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getScriptSecurity(this.val$st, this.val$sPURL, this.val$dPURL);
                }
            }
            Query q = new Query(this, st, sPURL, dPURL);
            this.invokeAndWait(q);
            return q.result;
        }

        public void checkLoadScript(String scriptType, ParsedURL scriptPURL, ParsedURL docPURL) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadScript(scriptType, scriptPURL, docPURL);
            } else {
                String st = scriptType;
                ParsedURL sPURL = scriptPURL;
                ParsedURL dPURL = docPURL;
                class Query
                implements Runnable {
                    SecurityException se;
                    private final /* synthetic */ String val$st;
                    private final /* synthetic */ ParsedURL val$sPURL;
                    private final /* synthetic */ ParsedURL val$dPURL;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;

                    Query(BridgeUserAgentWrapper this$0, String val$st, ParsedURL val$sPURL, ParsedURL val$dPURL) {
                        this.this$0 = this$0;
                        this.val$st = val$st;
                        this.val$sPURL = val$sPURL;
                        this.val$dPURL = val$dPURL;
                        this.se = null;
                    }

                    public void run() {
                        try {
                            this.this$0.userAgent.checkLoadScript(this.val$st, this.val$sPURL, this.val$dPURL);
                        }
                        catch (SecurityException se) {
                            this.se = se;
                        }
                    }
                }
                Query q = new Query(this, st, sPURL, dPURL);
                this.invokeAndWait(q);
                if (q.se != null) {
                    q.se.fillInStackTrace();
                    throw q.se;
                }
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourcePURL, ParsedURL docPURL) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getExternalResourceSecurity(resourcePURL, docPURL);
            }
            ParsedURL rPURL = resourcePURL;
            ParsedURL dPURL = docPURL;
            class Query
            implements Runnable {
                ExternalResourceSecurity result;
                private final /* synthetic */ ParsedURL val$rPURL;
                private final /* synthetic */ ParsedURL val$dPURL;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, ParsedURL val$rPURL, ParsedURL val$dPURL) {
                    this.this$0 = this$0;
                    this.val$rPURL = val$rPURL;
                    this.val$dPURL = val$dPURL;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getExternalResourceSecurity(this.val$rPURL, this.val$dPURL);
                }
            }
            Query q = new Query(this, rPURL, dPURL);
            this.invokeAndWait(q);
            return q.result;
        }

        public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadExternalResource(resourceURL, docURL);
            } else {
                ParsedURL rPURL = resourceURL;
                ParsedURL dPURL = docURL;
                class Query
                implements Runnable {
                    SecurityException se;
                    private final /* synthetic */ ParsedURL val$rPURL;
                    private final /* synthetic */ ParsedURL val$dPURL;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;

                    Query(BridgeUserAgentWrapper this$0, ParsedURL val$rPURL, ParsedURL val$dPURL) {
                        this.this$0 = this$0;
                        this.val$rPURL = val$rPURL;
                        this.val$dPURL = val$dPURL;
                    }

                    public void run() {
                        try {
                            this.this$0.userAgent.checkLoadExternalResource(this.val$rPURL, this.val$dPURL);
                        }
                        catch (SecurityException se) {
                            this.se = se;
                        }
                    }
                }
                Query q = new Query(this, rPURL, dPURL);
                this.invokeAndWait(q);
                if (q.se != null) {
                    q.se.fillInStackTrace();
                    throw q.se;
                }
            }
        }

        public SVGDocument getBrokenLinkDocument(Element e, String url, String msg) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getBrokenLinkDocument(e, url, msg);
            }
            class Query
            implements Runnable {
                SVGDocument doc;
                RuntimeException rex;
                private final /* synthetic */ Element val$e;
                private final /* synthetic */ String val$url;
                private final /* synthetic */ String val$msg;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, Element val$e, String val$url, String val$msg) {
                    this.this$0 = this$0;
                    this.val$e = val$e;
                    this.val$url = val$url;
                    this.val$msg = val$msg;
                    this.rex = null;
                }

                public void run() {
                    try {
                        this.doc = this.this$0.userAgent.getBrokenLinkDocument(this.val$e, this.val$url, this.val$msg);
                    }
                    catch (RuntimeException re) {
                        this.rex = re;
                    }
                }
            }
            Query q = new Query(this, e, url, msg);
            this.invokeAndWait(q);
            if (q.rex != null) {
                throw q.rex;
            }
            return q.doc;
        }

        protected void invokeAndWait(Runnable r) {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class SVGListener
    extends JGVTComponent.ExtendedListener
    implements SVGDocumentLoaderListener,
    GVTTreeBuilderListener,
    SVGLoadEventDispatcherListener,
    UpdateManagerListener {
        protected SVGListener() {
        }

        public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
        }

        public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.documentLoader = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            AbstractJSVGComponent.this.setSVGDocument(e.getSVGDocument());
        }

        public void documentLoadingCancelled(SVGDocumentLoaderEvent e) {
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.documentLoader = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        public void documentLoadingFailed(SVGDocumentLoaderEvent e) {
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.documentLoader = null;
            AbstractJSVGComponent.this.userAgent.displayError(((SVGDocumentLoader)e.getSource()).getException());
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        public void gvtBuildStarted(GVTTreeBuilderEvent e) {
            AbstractJSVGComponent.this.removeJGVTComponentListener(AbstractJSVGComponent.this.jsvgComponentListener);
            AbstractJSVGComponent.this.removeComponentListener(AbstractJSVGComponent.this.jsvgComponentListener);
        }

        public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            AbstractJSVGComponent.this.loader = null;
            AbstractJSVGComponent.this.gvtTreeBuilder = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.gvtRoot = null;
            if (AbstractJSVGComponent.this.isDynamicDocument && AbstractJSVGComponent.this.eventsEnabled) {
                AbstractJSVGComponent.this.startSVGLoadEventDispatcher(e.getGVTRoot());
            } else {
                if (AbstractJSVGComponent.this.isInteractiveDocument) {
                    AbstractJSVGComponent.this.nextUpdateManager = new UpdateManager(AbstractJSVGComponent.this.bridgeContext, e.getGVTRoot(), AbstractJSVGComponent.this.svgDocument);
                }
                AbstractJSVGComponent.this.setGraphicsNode(e.getGVTRoot(), false);
                AbstractJSVGComponent.super.scheduleGVTRendering();
            }
        }

        public void gvtBuildCancelled(GVTTreeBuilderEvent e) {
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            AbstractJSVGComponent.this.loader = null;
            AbstractJSVGComponent.this.gvtTreeBuilder = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.image = null;
            AbstractJSVGComponent.this.repaint();
        }

        public void gvtBuildFailed(GVTTreeBuilderEvent e) {
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            AbstractJSVGComponent.this.loader = null;
            AbstractJSVGComponent.this.gvtTreeBuilder = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode gn = e.getGVTRoot();
            if (gn == null) {
                AbstractJSVGComponent.this.image = null;
                AbstractJSVGComponent.this.repaint();
            } else {
                AbstractJSVGComponent.this.setGraphicsNode(gn, false);
                AbstractJSVGComponent.this.computeRenderingTransform();
            }
            AbstractJSVGComponent.this.userAgent.displayError(((GVTTreeBuilder)e.getSource()).getException());
        }

        public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
        }

        public void svgLoadEventDispatchCompleted(SVGLoadEventDispatcherEvent e) {
            AbstractJSVGComponent.this.nextUpdateManager = AbstractJSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            AbstractJSVGComponent.this.svgLoadEventDispatcher = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                AbstractJSVGComponent.this.nextUpdateManager = null;
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                AbstractJSVGComponent.this.nextUpdateManager = null;
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                AbstractJSVGComponent.this.nextUpdateManager = null;
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.setGraphicsNode(e.getGVTRoot(), false);
            AbstractJSVGComponent.super.scheduleGVTRendering();
        }

        public void svgLoadEventDispatchCancelled(SVGLoadEventDispatcherEvent e) {
            AbstractJSVGComponent.this.nextUpdateManager = AbstractJSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            AbstractJSVGComponent.this.svgLoadEventDispatcher = null;
            AbstractJSVGComponent.this.nextUpdateManager.interrupt();
            AbstractJSVGComponent.this.nextUpdateManager = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void svgLoadEventDispatchFailed(SVGLoadEventDispatcherEvent e) {
            AbstractJSVGComponent.this.nextUpdateManager = AbstractJSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            AbstractJSVGComponent.this.svgLoadEventDispatcher = null;
            AbstractJSVGComponent.this.nextUpdateManager.interrupt();
            AbstractJSVGComponent.this.nextUpdateManager = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode gn = e.getGVTRoot();
            if (gn == null) {
                AbstractJSVGComponent.this.image = null;
                AbstractJSVGComponent.this.repaint();
            } else {
                AbstractJSVGComponent.this.setGraphicsNode(gn, false);
                AbstractJSVGComponent.this.computeRenderingTransform();
            }
            AbstractJSVGComponent.this.userAgent.displayError(((SVGLoadEventDispatcher)e.getSource()).getException());
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
            super.gvtRenderingCompleted(e);
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                AbstractJSVGComponent.this.updateManager = AbstractJSVGComponent.this.nextUpdateManager;
                AbstractJSVGComponent.this.nextUpdateManager = null;
                AbstractJSVGComponent.this.updateManager.addUpdateManagerListener(this);
                AbstractJSVGComponent.this.updateManager.manageUpdates(AbstractJSVGComponent.this.renderer);
            }
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent e) {
            super.gvtRenderingCancelled(e);
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent e) {
            super.gvtRenderingFailed(e);
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void managerStarted(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    AbstractJSVGComponent.access$1103(SVGListener.access$1000(this.this$1), false);
                    Object[] dll = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).managerStarted(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        public void managerSuspended(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    Object[] dll = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).managerSuspended(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        public void managerResumed(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    Object[] dll = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).managerResumed(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        public void managerStopped(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    SVGListener.access$1000((SVGListener)this.this$1).updateManager = null;
                    Object[] dll = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).managerStopped(this.val$e);
                            ++i;
                        }
                    }
                    if (SVGListener.access$1000((SVGListener)this.this$1).afterStopRunnable != null) {
                        EventQueue.invokeLater(SVGListener.access$1000((SVGListener)this.this$1).afterStopRunnable);
                        SVGListener.access$1000((SVGListener)this.this$1).afterStopRunnable = null;
                        return;
                    }
                    if (SVGListener.access$1000((SVGListener)this.this$1).nextGVTTreeBuilder != null) {
                        SVGListener.access$1000(this.this$1).startGVTTreeBuilder();
                        return;
                    }
                    if (SVGListener.access$1000((SVGListener)this.this$1).nextDocumentLoader != null) {
                        AbstractJSVGComponent.access$000(SVGListener.access$1000(this.this$1));
                        return;
                    }
                }
            });
        }

        public void updateStarted(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    Object[] dll;
                    if (!AbstractJSVGComponent.access$1201(SVGListener.access$1000(this.this$1))) {
                        AbstractJSVGComponent.access$1303(SVGListener.access$1000(this.this$1), this.val$e.getImage());
                    }
                    if ((dll = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray()).length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).updateStarted(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        public void updateCompleted(UpdateManagerEvent e) {
            try {
                EventQueue.invokeAndWait(new Runnable(this, e){
                    private final /* synthetic */ UpdateManagerEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        List l;
                        AbstractJSVGComponent.access$1403(SVGListener.access$1000(this.this$1), this.val$e.getImage());
                        if (this.val$e.getClearPaintingTransform()) {
                            AbstractJSVGComponent.access$1503(SVGListener.access$1000(this.this$1), null);
                        }
                        if ((l = this.val$e.getDirtyAreas()) != null) {
                            Iterator<E> i = l.iterator();
                            while (i.hasNext()) {
                                Rectangle r = (Rectangle)i.next();
                                if (SVGListener.access$1000((SVGListener)this.this$1).updateOverlay != null) {
                                    SVGListener.access$1000((SVGListener)this.this$1).updateOverlay.addRect(r);
                                    r = SVGListener.access$1000(this.this$1).getRenderRect();
                                }
                                if (AbstractJSVGComponent.access$1601(SVGListener.access$1000(this.this$1))) {
                                    SVGListener.access$1000(this.this$1).repaint(r);
                                    continue;
                                }
                                SVGListener.access$1000(this.this$1).paintImmediately(r);
                            }
                            if (SVGListener.access$1000((SVGListener)this.this$1).updateOverlay != null) {
                                SVGListener.access$1000((SVGListener)this.this$1).updateOverlay.endUpdate();
                            }
                        }
                        AbstractJSVGComponent.access$1703(SVGListener.access$1000(this.this$1), false);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    Object[] dll = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).updateCompleted(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        public void updateFailed(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    Object[] dll = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).updateFailed(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        protected void dispatchKeyTyped(KeyEvent e) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyTyped(e);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$1801(SVGListener.access$1000(this.this$1)).keyTyped(this.val$e);
                    }
                });
            }
        }

        protected void dispatchKeyPressed(KeyEvent e) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyPressed(e);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$1901(SVGListener.access$1000(this.this$1)).keyPressed(this.val$e);
                    }
                });
            }
        }

        protected void dispatchKeyReleased(KeyEvent e) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyReleased(e);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2001(SVGListener.access$1000(this.this$1)).keyReleased(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseClicked(MouseEvent e) {
            if (!AbstractJSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseClicked(e);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2101(SVGListener.access$1000(this.this$1)).mouseClicked(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMousePressed(MouseEvent e) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchMousePressed(e);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2201(SVGListener.access$1000(this.this$1)).mousePressed(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseReleased(MouseEvent e) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseReleased(e);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2301(SVGListener.access$1000(this.this$1)).mouseReleased(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseEntered(MouseEvent e) {
            if (!AbstractJSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseEntered(e);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2401(SVGListener.access$1000(this.this$1)).mouseEntered(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseExited(MouseEvent e) {
            if (!AbstractJSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseExited(e);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2501(SVGListener.access$1000(this.this$1)).mouseExited(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseDragged(MouseEvent e) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseDragged(e);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                class MouseDraggedRunnable
                implements Runnable {
                    MouseEvent event;
                    private final /* synthetic */ SVGListener this$1;

                    MouseDraggedRunnable(SVGListener this$1, MouseEvent evt) {
                        this.this$1 = this$1;
                        this.event = evt;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2601(SVGListener.access$1000(this.this$1)).mouseDragged(this.event);
                    }
                }
                RunnableQueue rq = AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue();
                Object object = rq.getIteratorLock();
                synchronized (object) {
                    Iterator it = rq.iterator();
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (!(next instanceof MouseDraggedRunnable)) continue;
                        MouseDraggedRunnable mdr = (MouseDraggedRunnable)next;
                        MouseEvent mev = mdr.event;
                        if (mev.getModifiers() == e.getModifiers()) {
                            mdr.event = e;
                        }
                        return;
                    }
                }
                rq.invokeLater(new MouseDraggedRunnable(this, e));
            }
        }

        protected void dispatchMouseMoved(MouseEvent e) {
            if (!AbstractJSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseMoved(e);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                class MouseMovedRunnable
                implements Runnable {
                    MouseEvent event;
                    private final /* synthetic */ SVGListener this$1;

                    MouseMovedRunnable(SVGListener this$1, MouseEvent evt) {
                        this.this$1 = this$1;
                        this.event = evt;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2701(SVGListener.access$1000(this.this$1)).mouseMoved(this.event);
                    }
                }
                RunnableQueue rq = AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue();
                int i = 0;
                Object object = rq.getIteratorLock();
                synchronized (object) {
                    Iterator it = rq.iterator();
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (next instanceof MouseMovedRunnable) {
                            MouseMovedRunnable mmr = (MouseMovedRunnable)next;
                            MouseEvent mev = mmr.event;
                            if (mev.getModifiers() == e.getModifiers()) {
                                mmr.event = e;
                            }
                            return;
                        }
                        ++i;
                    }
                }
                rq.invokeLater(new MouseMovedRunnable(this, e));
            }
        }

        static /* synthetic */ AbstractJSVGComponent access$1000(SVGListener x0) {
            return x0.AbstractJSVGComponent.this;
        }
    }

    protected class JSVGComponentListener
    extends ComponentAdapter
    implements JGVTComponentListener {
        float prevScale = 0.0f;
        float prevTransX = 0.0f;
        float prevTransY = 0.0f;

        protected JSVGComponentListener() {
        }

        public void componentResized(ComponentEvent ce) {
            if (AbstractJSVGComponent.this.isDynamicDocument && AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this){
                    private final /* synthetic */ JSVGComponentListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        try {
                            JSVGComponentListener.access$100((JSVGComponentListener)this.this$1).updateManager.dispatchSVGResizeEvent();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        public void componentTransformChanged(ComponentEvent event) {
            boolean dispatchScroll;
            AffineTransform at = AbstractJSVGComponent.this.getRenderingTransform();
            float currScale = (float)Math.sqrt(at.getDeterminant());
            float currTransX = (float)at.getTranslateX();
            float currTransY = (float)at.getTranslateY();
            boolean dispatchZoom = currScale != this.prevScale;
            boolean bl = dispatchScroll = currTransX != this.prevTransX || currTransY != this.prevTransY;
            if (AbstractJSVGComponent.this.isDynamicDocument && AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, dispatchZoom, dispatchScroll){
                    private final /* synthetic */ boolean val$dispatchZoom;
                    private final /* synthetic */ boolean val$dispatchScroll;
                    private final /* synthetic */ JSVGComponentListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$dispatchZoom = val$dispatchZoom;
                        this.val$dispatchScroll = val$dispatchScroll;
                    }

                    public void run() {
                        try {
                            if (this.val$dispatchZoom) {
                                JSVGComponentListener.access$100((JSVGComponentListener)this.this$1).updateManager.dispatchSVGZoomEvent();
                            }
                            if (this.val$dispatchScroll) {
                                JSVGComponentListener.access$100((JSVGComponentListener)this.this$1).updateManager.dispatchSVGScrollEvent();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            this.prevScale = currScale;
            this.prevTransX = currTransX;
            this.prevTransY = currTransY;
        }

        public void updateMatrix(AffineTransform at) {
            this.prevScale = (float)Math.sqrt(at.getDeterminant());
            this.prevTransX = (float)at.getTranslateX();
            this.prevTransY = (float)at.getTranslateY();
        }

        static /* synthetic */ AbstractJSVGComponent access$100(JSVGComponentListener x0) {
            return x0.AbstractJSVGComponent.this;
        }
    }
}

