/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.projection;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.projection.ProjectedFeature;
import org.biojava.bio.seq.projection.ProjectionContext;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ClassTools;
import org.biojava.utils.bytecode.ByteCode;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.GeneratedClassLoader;
import org.biojava.utils.bytecode.GeneratedCodeClass;
import org.biojava.utils.bytecode.GeneratedCodeMethod;
import org.biojava.utils.bytecode.InstructionVector;
import org.biojava.utils.bytecode.IntrospectedCodeClass;
import org.biojava.utils.bytecode.LocalVariable;

public class ProjectionEngine {
    public static final ProjectionEngine DEFAULT = new ProjectionEngine();
    private final Map _projectionClasses;
    private final PEClassLoader loader = new PEClassLoader(ClassTools.getClassLoader(ProjectionEngine.class));
    private final Instantiator instantiator;

    private ProjectionEngine() {
        this._projectionClasses = new HashMap();
        try {
            this.instantiator = new InstantiatorImpl();
        }
        catch (Exception ex) {
            throw new AssertionFailure("Assertion failure: can't initialize projection system", ex);
        }
    }

    private Class searchForClass(Class origClass, Class ctxtClass) {
        Map pc = (Map)this._projectionClasses.get(ctxtClass);
        if (pc == null) {
            return null;
        }
        return (Class)pc.get(origClass);
    }

    private void registerClass(Class origClass, Class ctxtClass, Class projClass) {
        HashMap<Class, Class> pc = (HashMap<Class, Class>)this._projectionClasses.get(ctxtClass);
        if (pc == null) {
            pc = new HashMap<Class, Class>();
            pc.put(null, ProjectedFeature.class);
            this._projectionClasses.put(ctxtClass, pc);
        }
        pc.put(origClass, projClass);
    }

    public Feature projectFeature(Feature f, ProjectionContext ctx) {
        Class<?> featureClass = f.getClass();
        Class<?>[] fcInterfaces = featureClass.getInterfaces();
        Class featureInterface = Feature.class;
        for (int i = fcInterfaces.length - 1; i >= 0; --i) {
            if (!Feature.class.isAssignableFrom(fcInterfaces[i])) continue;
            featureInterface = fcInterfaces[i];
            break;
        }
        Class projectionClass = this.getFeatureProjectionClass(featureInterface, ctx.getClass());
        Class[] sig = new Class[]{featureInterface, ProjectionContext.class};
        try {
            Constructor ct = projectionClass.getConstructor(sig);
            Object[] args = new Object[]{f, ctx};
            return (Feature)this.instantiator.newInstance(ct, args);
        }
        catch (Exception ex) {
            throw new AssertionFailure("Assertion failed: Couldn't instantiate proxy " + projectionClass.getName(), ex);
        }
    }

    private synchronized Class getFeatureProjectionClass(Class face, Class ctxtClass) {
        Class projection = this.searchForClass(face, ctxtClass);
        if (projection == null) {
            try {
                Class<ProjectedFeature> baseClass = ProjectedFeature.class;
                String faceName = face.getName().replaceAll("\\.", "_").replaceAll("\\$", "__");
                String ctxtName = ctxtClass.getName().replaceAll("\\$", "_");
                CodeClass baseClassC = IntrospectedCodeClass.forClass(baseClass);
                CodeClass faceClassC = IntrospectedCodeClass.forClass(face);
                GeneratedCodeClass pclass = new GeneratedCodeClass(ctxtName + "__" + faceName, baseClassC, new CodeClass[]{faceClassC}, 33);
                CodeClass[] baseInitArgsList = new CodeClass[]{IntrospectedCodeClass.forClass(Feature.class), IntrospectedCodeClass.forClass(ProjectionContext.class)};
                CodeClass voidC = IntrospectedCodeClass.forClass(Void.TYPE);
                CodeClass projectionContextC = IntrospectedCodeClass.forClass(ProjectionContext.class);
                CodeClass ourContextC = IntrospectedCodeClass.forClass(ctxtClass);
                CodeMethod m_ourBase_init = baseClassC.getConstructor(baseInitArgsList);
                CodeMethod m_ourBase_getViewedFeature = baseClassC.getMethod("getViewedFeature", CodeUtils.EMPTY_LIST);
                CodeMethod m_ourBase_getProjectionContext = baseClassC.getMethod("getProjectionContext", CodeUtils.EMPTY_LIST);
                GeneratedCodeMethod init = pclass.createMethod("<init>", voidC, new CodeClass[]{faceClassC, projectionContextC}, 1);
                InstructionVector initIV = new InstructionVector();
                initIV.add(ByteCode.make_aload(init.getThis()));
                initIV.add(ByteCode.make_aload(init.getVariable(0)));
                initIV.add(ByteCode.make_aload(init.getVariable(1)));
                initIV.add(ByteCode.make_invokespecial(m_ourBase_init));
                initIV.add(ByteCode.make_return());
                pclass.setCodeGenerator(init, initIV);
                block3: for (CodeMethod faceMethod : faceClassC.getMethods()) {
                    String propName;
                    Set baseMethods = baseClassC.getMethodsByName(faceMethod.getName());
                    if (baseClassC.getMethodsByName(faceMethod.getName()).size() > 0) {
                        for (CodeMethod meth : baseMethods) {
                            if ((meth.getModifiers() & 0x400) != 0) continue;
                            continue block3;
                        }
                    }
                    if (faceMethod.getName().startsWith("get") && faceMethod.numParameters() == 0) {
                        InstructionVector proxyIV;
                        propName = faceMethod.getName().substring("get".length());
                        GeneratedCodeMethod getterMethod = pclass.createMethod(faceMethod.getName(), faceMethod.getReturnType(), CodeUtils.EMPTY_LIST, 1);
                        CodeMethod projMeth = null;
                        for (CodeMethod cm : ourContextC.getMethodsByName("project" + propName)) {
                            if (cm.numParameters() != 1 || !cm.getReturnType().equals(cm.getParameterType(0)) || !cm.getReturnType().equals(faceMethod.getReturnType())) continue;
                            projMeth = cm;
                            break;
                        }
                        if (projMeth == null) {
                            proxyIV = new InstructionVector();
                            proxyIV.add(ByteCode.make_aload(getterMethod.getThis()));
                            proxyIV.add(ByteCode.make_invokevirtual(m_ourBase_getViewedFeature));
                            proxyIV.add(ByteCode.make_invokeinterface(faceMethod));
                            proxyIV.add(ByteCode.make_return(getterMethod));
                            pclass.setCodeGenerator(getterMethod, proxyIV);
                        } else {
                            proxyIV = new InstructionVector();
                            proxyIV.add(ByteCode.make_aload(getterMethod.getThis()));
                            proxyIV.add(ByteCode.make_invokevirtual(m_ourBase_getProjectionContext));
                            proxyIV.add(ByteCode.make_checkcast(ourContextC));
                            proxyIV.add(ByteCode.make_aload(getterMethod.getThis()));
                            proxyIV.add(ByteCode.make_invokevirtual(m_ourBase_getViewedFeature));
                            proxyIV.add(ByteCode.make_invokeinterface(faceMethod));
                            proxyIV.add(ByteCode.make_invokevirtual(projMeth));
                            proxyIV.add(ByteCode.make_return(getterMethod));
                            pclass.setCodeGenerator(getterMethod, proxyIV);
                        }
                    }
                    if (!faceMethod.getName().startsWith("set") || faceMethod.numParameters() != 0) continue;
                    propName = faceMethod.getName().substring("set".length());
                    GeneratedCodeMethod setterMethod = pclass.createMethod(faceMethod.getName(), voidC, new CodeClass[]{faceMethod.getParameterType(0)}, 1);
                    CodeMethod revertMeth = null;
                    for (CodeMethod cm : ourContextC.getMethodsByName("revert" + propName)) {
                        InstructionVector proxyIV;
                        if (cm.numParameters() == 1 && cm.getReturnType().equals(cm.getParameterType(0)) && cm.getReturnType().equals(faceMethod.getReturnType())) {
                            revertMeth = cm;
                            continue block3;
                        }
                        if (revertMeth == null) {
                            proxyIV = new InstructionVector();
                            proxyIV.add(ByteCode.make_aload(setterMethod.getThis()));
                            proxyIV.add(ByteCode.make_invokevirtual(m_ourBase_getViewedFeature));
                            proxyIV.add(ByteCode.make_lload(setterMethod.getVariable(0)));
                            proxyIV.add(ByteCode.make_invokeinterface(faceMethod));
                            pclass.setCodeGenerator(setterMethod, proxyIV);
                            continue;
                        }
                        proxyIV = new InstructionVector();
                        proxyIV.add(ByteCode.make_aload(setterMethod.getThis()));
                        proxyIV.add(ByteCode.make_invokevirtual(m_ourBase_getViewedFeature));
                        proxyIV.add(ByteCode.make_aload(setterMethod.getThis()));
                        proxyIV.add(ByteCode.make_invokevirtual(m_ourBase_getProjectionContext));
                        proxyIV.add(ByteCode.make_checkcast(ourContextC));
                        proxyIV.add(ByteCode.make_lload(setterMethod.getVariable(0)));
                        proxyIV.add(ByteCode.make_invokevirtual(revertMeth));
                        proxyIV.add(ByteCode.make_invokeinterface(faceMethod));
                        pclass.setCodeGenerator(setterMethod, proxyIV);
                    }
                }
                projection = this.loader.defineClass(pclass);
                this.registerClass(face, ctxtClass, projection);
            }
            catch (CodeException ex) {
                throw new BioError(ex);
            }
            catch (NoSuchMethodException nsme) {
                throw new BioError(nsme);
            }
        }
        return projection;
    }

    public Feature.Template revertTemplate(Feature.Template templ, ProjectionContext ctxt) {
        Class<?> templateClass = templ.getClass();
        Class projClass = this.getTemplateProjectorClass(templateClass, ctxt.getClass());
        TemplateProjector proj = null;
        try {
            proj = (TemplateProjector)projClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new AssertionFailure("Assertion failed: Couldn't instantiate template projector" + projClass.getName(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionFailure("Assertion Failed: Couldn't instantiate template projector" + projClass.getName(), iae);
        }
        try {
            return proj.revertTemplate(ctxt, templ);
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionFailure(cnse);
        }
    }

    private Class getTemplateProjectorClass(Class templateClass, Class ctxtClass) {
        Class projection = this.searchForClass(templateClass, ctxtClass);
        if (projection == null) {
            try {
                String tpltName = templateClass.getName().replaceAll("\\.", "_").replaceAll("\\$", "__");
                String ctxtName = ctxtClass.getName().replaceAll("\\$", "_");
                CodeClass c_baseClass = CodeUtils.TYPE_OBJECT;
                CodeClass c_tpClass = IntrospectedCodeClass.forClass(TemplateProjector.class);
                GeneratedCodeClass pclass = new GeneratedCodeClass(ctxtName + "__" + tpltName, c_baseClass, new CodeClass[]{c_tpClass}, 33);
                CodeMethod m_Object_init = CodeUtils.TYPE_OBJECT.getConstructor(CodeUtils.EMPTY_LIST);
                GeneratedCodeMethod init = pclass.createMethod("<init>", CodeUtils.TYPE_VOID, CodeUtils.EMPTY_LIST, 1);
                InstructionVector initIV = new InstructionVector();
                initIV.add(ByteCode.make_aload(init.getThis()));
                initIV.add(ByteCode.make_invokespecial(m_Object_init));
                initIV.add(ByteCode.make_return());
                pclass.setCodeGenerator(init, initIV);
                CodeClass c_FeatureTemplate = IntrospectedCodeClass.forClass(Feature.Template.class);
                CodeClass c_ProjectionContext = IntrospectedCodeClass.forClass(ProjectionContext.class);
                GeneratedCodeMethod revT = pclass.createMethod("revertTemplate", c_FeatureTemplate, new CodeClass[]{c_ProjectionContext, c_FeatureTemplate}, new String[]{"ctxt", "origTplt"}, 1);
                revT.addThrownException(IntrospectedCodeClass.forClass(CloneNotSupportedException.class));
                InstructionVector revTIV = new InstructionVector();
                CodeMethod m_FeatureTemplate_clone = c_FeatureTemplate.getMethod("clone", CodeUtils.EMPTY_LIST);
                LocalVariable lv_ctxt = revT.getVariable("ctxt");
                LocalVariable lv_origTplt = revT.getVariable("origTplt");
                LocalVariable lv_ourTplt = new LocalVariable(c_FeatureTemplate, "ourTemplate");
                revTIV.add(ByteCode.make_aload(lv_origTplt));
                revTIV.add(ByteCode.make_invokevirtual(m_FeatureTemplate_clone));
                revTIV.add(ByteCode.make_checkcast(c_FeatureTemplate));
                revTIV.add(ByteCode.make_astore(lv_ourTplt));
                CodeClass c_ourContext = IntrospectedCodeClass.forClass(ctxtClass);
                CodeClass c_ourTemplate = IntrospectedCodeClass.forClass(templateClass);
                for (CodeField field : c_ourTemplate.getFields()) {
                    String fieldName = field.getName();
                    String propName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    String revName = "revert" + propName;
                    CodeMethod revertMeth = null;
                    for (CodeMethod cm : c_ourContext.getMethodsByName(revName)) {
                        if (cm.numParameters() != 1 || !cm.getReturnType().equals(cm.getParameterType(0)) || !cm.getReturnType().equals(field.getType())) continue;
                        revertMeth = cm;
                        break;
                    }
                    if (revertMeth == null) continue;
                    InstructionVector revIV = new InstructionVector();
                    revIV.add(ByteCode.make_aload(lv_ourTplt));
                    revIV.add(ByteCode.make_checkcast(c_ourTemplate));
                    revIV.add(ByteCode.make_aload(lv_ctxt));
                    revIV.add(ByteCode.make_checkcast(c_ourContext));
                    revIV.add(ByteCode.make_aload(lv_origTplt));
                    revIV.add(ByteCode.make_checkcast(c_ourTemplate));
                    revIV.add(ByteCode.make_getfield(field));
                    revIV.add(ByteCode.make_invokevirtual(revertMeth));
                    revIV.add(ByteCode.make_putfield(field));
                    revTIV.add(revIV);
                }
                revTIV.add(ByteCode.make_aload(lv_ourTplt));
                revTIV.add(ByteCode.make_areturn());
                pclass.setCodeGenerator(revT, revTIV);
                projection = this.loader.defineClass(pclass);
                this.registerClass(templateClass, ctxtClass, projection);
            }
            catch (CodeException ce) {
                throw new AssertionFailure("Unable to create template projector: ", ce);
            }
            catch (NoSuchMethodException nsme) {
                throw new AssertionFailure("Unable to create template projector: ", nsme);
            }
        }
        return projection;
    }

    public static interface TemplateProjector {
        public Feature.Template revertTemplate(ProjectionContext var1, Feature.Template var2) throws CloneNotSupportedException;
    }

    static class InstantiatorImpl
    implements Instantiator {
        InstantiatorImpl() {
        }

        public Object newInstance(Constructor c, Object[] args) throws Exception {
            return c.newInstance(args);
        }
    }

    public static interface Instantiator {
        public Object newInstance(Constructor var1, Object[] var2) throws Exception;
    }

    private static class PEClassLoader
    extends GeneratedClassLoader {
        public PEClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class loadClassMagick(String name) throws ClassNotFoundException {
            try {
                String resName = name.replace('.', '/') + ".class";
                InputStream is = this.getResourceAsStream(resName);
                if (is == null) {
                    throw new ClassNotFoundException("Could not find class resource: " + resName);
                }
                byte[] buffer = new byte[10000];
                int len = 0;
                int read = 0;
                while (read >= 0) {
                    read = is.read(buffer, len, buffer.length - len);
                    if (read <= 0) continue;
                    len += read;
                }
                is.close();
                Class<?> c = this.defineClass(name, buffer, 0, len);
                this.resolveClass(c);
                return c;
            }
            catch (Exception ex) {
                throw new ClassNotFoundException("Could not load class for " + name + ": " + ex.toString());
            }
        }
    }
}

