/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Lmder_fcn;
import optimization.Minpack_f77;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.Num;

public class BetaDist
extends ContinuousDistribution {
    private static final double RENORM = 1.0E300;
    protected double alpha;
    protected double beta;
    protected double a;
    protected double b;
    protected double bminusa;
    protected double logFactor;
    protected double Beta;
    protected double logBeta;

    public BetaDist(double alpha, double beta) {
        this.setParams(alpha, beta, 0.0, 1.0, this.decPrec);
    }

    public BetaDist(double alpha, double beta, double a, double b) {
        this.setParams(alpha, beta, a, b, this.decPrec);
    }

    public BetaDist(double alpha, double beta, int d) {
        this.setParams(alpha, beta, 0.0, 1.0, d);
    }

    public BetaDist(double alpha, double beta, double a, double b, int d) {
        this.setParams(alpha, beta, a, b, d);
    }

    public double density(double x) {
        if (x <= this.a || x >= this.b) {
            return 0.0;
        }
        double temp = (this.alpha - 1.0) * Math.log(x - this.a) + (this.beta - 1.0) * Math.log(this.b - x);
        return Math.exp(this.logFactor + temp);
    }

    public double cdf(double x) {
        if (this.a >= this.b) {
            throw new IllegalArgumentException("a >= b");
        }
        return BetaDist.cdf(this.alpha, this.beta, this.decPrec, (x - this.a) / this.bminusa);
    }

    public double inverseF(double u) {
        return this.a + (this.b - this.a) * BetaDist.inverseF(this.alpha, this.beta, this.decPrec, u);
    }

    public double getMean() {
        return BetaDist.getMean(this.alpha, this.beta, this.a, this.b);
    }

    public double getVariance() {
        return BetaDist.getVariance(this.alpha, this.beta, this.a, this.b);
    }

    public double getStandardDeviation() {
        return BetaDist.getStandardDeviation(this.alpha, this.beta, this.a, this.b);
    }

    public static double density(double alpha, double beta, double x) {
        return BetaDist.density(alpha, beta, 0.0, 1.0, x);
    }

    public static double density(double alpha, double beta, double a, double b, double x) {
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        if (x <= a || x >= b) {
            return 0.0;
        }
        double factor = Num.lnGamma(alpha + beta) - (Num.lnGamma(alpha) + Num.lnGamma(beta)) - (alpha + beta - 1.0) * Math.log(b - a) + (alpha - 1.0) * Math.log(x - a) + (beta - 1.0) * Math.log(b - x);
        return Math.exp(factor);
    }

    private static double isubx_alphabeta_small(double alpha, double beta, double x, int d) {
        double v;
        int k = 0;
        if (alpha <= 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("alpha not in (0, 1] ");
        }
        if (beta <= 0.0 || beta > 2.0) {
            throw new IllegalArgumentException("beta not in (0, 2] ");
        }
        double epsilon = EPSARRAY[d];
        double u = Math.pow(x, alpha);
        double s = u / alpha;
        do {
            u = ((double)(k + 1) - beta) * x * u / (double)(k + 1);
            v = u / ((double)(k + 1) + alpha);
            ++k;
        } while (Math.abs(v) / (s += v) > epsilon);
        v = Num.lnGamma(alpha + beta) - Num.lnGamma(alpha) - Num.lnGamma(beta);
        return s * Math.exp(v);
    }

    private static void forward(double alpha, double beta, double x, double I0, double I1, int nmax, double[] I) {
        I[0] = I0;
        if (nmax > 0) {
            I[1] = I1;
        }
        for (int n = 1; n < nmax; ++n) {
            I[n + 1] = (1.0 + ((double)(n - 1) + alpha + beta) * (1.0 - x) / ((double)n + beta)) * I[n] - ((double)(n - 1) + alpha + beta) * (1.0 - x) * I[n - 1] / ((double)n + beta);
        }
    }

    private static void backward(double alpha, double beta, double x, double I0, int d, int nmax, double[] I) {
        boolean again;
        int n;
        int ntab;
        I[0] = I0;
        if (nmax == 0) {
            return;
        }
        double epsilon = EPSARRAY[d];
        int nu = 2 * nmax + 5;
        for (ntab = 64; ntab <= nu; ntab *= 2) {
        }
        double[] Rr = new double[ntab];
        double[] Iapprox = new double[ntab];
        double[] Itemp = new double[ntab];
        for (n = 1; n <= nmax; ++n) {
            Iapprox[n] = 0.0;
        }
        for (n = 0; n <= nmax; ++n) {
            Itemp[n] = I[n];
        }
        block3: do {
            n = nu;
            double r = 0.0;
            do {
                r = ((double)(n - 1) + alpha + beta) * x / ((double)n + alpha + ((double)(n - 1) + alpha + beta) * x - ((double)n + alpha) * r);
                if (n > nmax) continue;
                Rr[n - 1] = r;
            } while (--n >= 1);
            for (n = 0; n < nmax; ++n) {
                Itemp[n + 1] = Rr[n] * Itemp[n];
            }
            again = false;
            for (n = 1; n <= nmax; ++n) {
                if (!(Math.abs((Itemp[n] - Iapprox[n]) / Itemp[n]) > epsilon)) continue;
                again = true;
                for (int m = 1; m <= nmax; ++m) {
                    Iapprox[m] = Itemp[m];
                }
                if (ntab > (nu += 5)) continue block3;
                double[] nT = new double[ntab *= 2];
                System.arraycopy(Rr, 0, nT, 0, Rr.length);
                Rr = nT;
                nT = new double[ntab];
                System.arraycopy(Iapprox, 0, nT, 0, Iapprox.length);
                Iapprox = nT;
                nT = new double[ntab];
                System.arraycopy(Itemp, 0, nT, 0, Itemp.length);
                Itemp = nT;
                continue block3;
            }
        } while (again);
        for (n = 0; n <= nmax; ++n) {
            I[n] = Itemp[n];
        }
    }

    private static void isubx_beta_fixed(double alpha, double beta, double x, int d, int nmax, double[] I) {
        int mmax;
        double beta0;
        double Ibeta1 = 0.0;
        if (alpha <= 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("alpha not in (0, 1] ");
        }
        int m = (int)beta;
        double s = beta - (double)m;
        if (s > 0.0) {
            beta0 = s;
            mmax = m;
        } else {
            beta0 = s + 1.0;
            mmax = m - 1;
        }
        double Ibeta0 = 1.0E300 * BetaDist.isubx_alphabeta_small(alpha, beta0, x, d);
        if (mmax > 0) {
            Ibeta1 = 1.0E300 * BetaDist.isubx_alphabeta_small(alpha, beta0 + 1.0, x, d);
        }
        double[] Ibeta = new double[mmax + 1];
        BetaDist.forward(alpha, beta0, x, Ibeta0, Ibeta1, mmax, Ibeta);
        BetaDist.backward(alpha, beta, x, Ibeta[mmax], d, nmax, I);
        m = 0;
        while (m <= nmax) {
            int n = m++;
            I[n] = I[n] / 1.0E300;
        }
    }

    private static void isubx_alpha_fixed(double alpha, double beta, double x, int d, int nmax, double[] I) {
        int mmax;
        double alpha0;
        if (beta <= 0.0 || beta > 1.0) {
            throw new IllegalArgumentException("beta not in (0, 1] ");
        }
        int m = (int)alpha;
        double s = alpha - (double)m;
        if (s > 0.0) {
            alpha0 = s;
            mmax = m;
        } else {
            alpha0 = s + 1.0;
            mmax = m - 1;
        }
        double I0 = 1.0E300 * BetaDist.isubx_alphabeta_small(alpha0, beta, x, d);
        double I1 = 1.0E300 * BetaDist.isubx_alphabeta_small(alpha0, beta + 1.0, x, d);
        double[] Ialpha = new double[mmax + 1];
        BetaDist.backward(alpha0, beta, x, I0, d, mmax, Ialpha);
        double Ibeta0 = Ialpha[mmax];
        BetaDist.backward(alpha0, beta + 1.0, x, I1, d, mmax, Ialpha);
        double Ibeta1 = Ialpha[mmax];
        BetaDist.forward(alpha, beta, x, Ibeta0, Ibeta1, nmax, I);
        m = 0;
        while (m <= nmax) {
            int n = m++;
            I[n] = I[n] / 1.0E300;
        }
    }

    private static void beta_beta_fixed(double alpha, double beta, double x, int d, int nmax, double[] I) {
        if (alpha <= 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("alpha not in (0, 1]");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (nmax < 0) {
            throw new IllegalArgumentException("nmax < 0");
        }
        if (x == 0.0 || x == 1.0) {
            for (int n = 0; n <= nmax; ++n) {
                I[n] = x;
            }
            return;
        }
        if (x <= 0.5) {
            BetaDist.isubx_beta_fixed(alpha, beta, x, d, nmax, I);
        } else {
            BetaDist.isubx_alpha_fixed(beta, alpha, 1.0 - x, d, nmax, I);
            for (int n = 0; n <= nmax; ++n) {
                I[n] = 1.0 - I[n];
            }
        }
    }

    private static void beta_alpha_fixed(double alpha, double beta, double x, int d, int nmax, double[] I) {
        if (beta <= 0.0 || beta > 1.0) {
            throw new IllegalArgumentException("beta not in (0, 1]");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (nmax < 0) {
            throw new IllegalArgumentException("nmax < 0");
        }
        if (x == 0.0 || x == 1.0) {
            for (int n = 0; n <= nmax; ++n) {
                I[n] = x;
            }
            return;
        }
        if (x <= 0.5) {
            BetaDist.isubx_alpha_fixed(alpha, beta, x, d, nmax, I);
        } else {
            BetaDist.isubx_beta_fixed(beta, alpha, 1.0 - x, d, nmax, I);
            for (int n = 0; n <= nmax; ++n) {
                I[n] = 1.0 - I[n];
            }
        }
    }

    private static double beta_g(double x, int d) {
        double inc;
        if (x > 1.3) {
            return -BetaDist.beta_g(1.0 / x, d);
        }
        if (x < 1.0E-20) {
            return 1.0;
        }
        if (x < 0.7) {
            return (1.0 - x * x + 2.0 * x * Math.log(x)) / ((1.0 - x) * (1.0 - x));
        }
        if (x == 1.0) {
            return 0.0;
        }
        double epsilon = EPSARRAY[d];
        double y = 1.0 - x;
        double sum = 0.0;
        double term = 1.0;
        int j = 2;
        do {
            inc = (term *= y) / (double)(j * (j + 1));
            ++j;
        } while (Math.abs(inc / (sum += inc)) > epsilon);
        return 2.0 * sum;
    }

    public static double cdf(double alpha, double beta, int d, double x) {
        double ALPHABETAMAX = 1000.0;
        double ALPHABETALIM = 30.0;
        boolean flag = false;
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        if (Math.max(alpha, beta) <= 1000.0) {
            if (alpha < beta) {
                int n = (int)alpha;
                double alpha0 = alpha - (double)n;
                if (alpha0 <= 0.0) {
                    alpha0 = 1.0;
                    --n;
                }
                double[] I = new double[n + 1];
                BetaDist.beta_beta_fixed(alpha0, beta, x, d, n, I);
                double u = I[n];
                if (u <= 0.0) {
                    return 0.0;
                }
                if (u <= 1.0) {
                    return u;
                }
                return 1.0;
            }
            int n = (int)beta;
            double beta0 = beta - (double)n;
            if (beta0 <= 0.0) {
                beta0 = 1.0;
                --n;
            }
            double[] I = new double[n + 1];
            BetaDist.beta_alpha_fixed(alpha, beta0, x, d, n, I);
            double u = I[n];
            if (u <= 0.0) {
                return 0.0;
            }
            if (u <= 1.0) {
                return u;
            }
            return 1.0;
        }
        if (alpha > 1000.0 && beta < 30.0 || beta > 1000.0 && alpha < 30.0) {
            double u;
            if (x > 0.5) {
                return 1.0 - BetaDist.cdf(beta, alpha, d, 1.0 - x);
            }
            if (alpha < beta) {
                u = alpha;
                alpha = beta;
                beta = u;
                flag = false;
            } else {
                flag = true;
            }
            u = alpha + 0.5 * beta - 0.5;
            double temp = !flag ? x / (2.0 - x) : (1.0 - x) / (1.0 + x);
            double yd = 2.0 * u * temp;
            double gam = Math.exp(beta * Math.log(yd) - yd - Num.lnGamma(beta)) * (2.0 * yd * yd - (beta - 1.0) * yd - (beta * beta - 1.0)) / (24.0 * u * u);
            if (flag) {
                yd = GammaDist.barF(beta, d, yd);
                return yd - gam;
            }
            yd = GammaDist.cdf(beta, d, yd);
            return yd + gam;
        }
        double h1 = alpha + beta - 1.0;
        double y = 1.0 - x;
        double h3 = Math.sqrt((1.0 + y * BetaDist.beta_g((alpha - 0.5) / (h1 * x), d) + x * BetaDist.beta_g((beta - 0.5) / (h1 * y), d)) / ((h1 + 0.16666666666666666) * x * y)) * ((h1 + 0.3333333333333333 + 0.02 * (1.0 / alpha + 1.0 / beta + 1.0 / (alpha + beta))) * x - alpha + 0.3333333333333333 - 0.02 / alpha - 0.01 / (alpha + beta));
        return NormalDist.cdf01(h3);
    }

    public static double cdf(double alpha, double beta, double a, double b, int d, double x) {
        return BetaDist.cdf(alpha, beta, d, (x - a) / (b - a));
    }

    public static double barF(double alpha, double beta, int d, double x) {
        return 1.0 - BetaDist.cdf(alpha, beta, d, x);
    }

    public static double barF(double alpha, double beta, double a, double b, int d, double x) {
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        return 1.0 - BetaDist.cdf(alpha, beta, d, (x - a) / (b - a));
    }

    public static double inverseF(double alpha, double beta, int d, double u) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return 0.0;
        }
        if (u >= 1.0) {
            return 1.0;
        }
        double MACHEP = 1.110223E-16f;
        double MAXLOG = 709.782712893384;
        double MINLOG = -708.3964185322641;
        double MAXNUM = Double.MAX_VALUE;
        boolean ihalve = false;
        boolean newt = false;
        double p = 0.0;
        double q = 0.0;
        double y0 = 0.0;
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        double lgm = 0.0;
        double yp = 0.0;
        double di = 0.0;
        double dithresh = 0.0;
        double xt = 0.0;
        double x0 = 0.0;
        double yl = 0.0;
        double x1 = 1.0;
        double yh = 1.0;
        boolean nflg = false;
        boolean rflg = false;
        if (alpha <= 1.0 || beta <= 1.0) {
            dithresh = 1.0E-6;
            rflg = false;
            p = alpha;
            q = beta;
            y0 = u;
            x = p / (p + q);
            y = BetaDist.cdf(p, q, d, x);
            ihalve = true;
        } else {
            dithresh = 1.0E-4;
        }
        block0: while (true) {
            int i;
            if (ihalve) {
                ihalve = false;
                int dir = 0;
                di = 0.5;
                for (i = 0; i < 100; ++i) {
                    if (i != 0) {
                        x = x0 + di * (x1 - x0);
                        if (x == 1.0) {
                            x = 0.9999999999999999;
                        }
                        if (x == 0.0 && (x = x0 + (di = 0.5) * (x1 - x0)) == 0.0) {
                            return 0.0;
                        }
                        y = BetaDist.cdf(p, q, d, x);
                        yp = (x1 - x0) / (x1 + x0);
                        if (Math.abs(yp) < dithresh) {
                            newt = true;
                            continue block0;
                        }
                        yp = (y - y0) / y0;
                        if (Math.abs(yp) < dithresh) {
                            newt = true;
                            continue block0;
                        }
                    }
                    if (y < y0) {
                        x0 = x;
                        yl = y;
                        if (dir < 0) {
                            dir = 0;
                            di = 0.5;
                        } else {
                            di = dir > 3 ? 1.0 - (1.0 - di) * (1.0 - di) : (dir > 1 ? 0.5 * di + 0.5 : (y0 - y) / (yh - yl));
                        }
                        ++dir;
                        if (!(x0 > 0.75)) continue;
                        if (rflg) {
                            rflg = false;
                            p = alpha;
                            q = beta;
                            y0 = u;
                        } else {
                            rflg = true;
                            p = beta;
                            q = alpha;
                            y0 = 1.0 - u;
                        }
                        x = 1.0 - x;
                        y = BetaDist.cdf(p, q, d, x);
                        x0 = 0.0;
                        yl = 0.0;
                        x1 = 1.0;
                        yh = 1.0;
                        ihalve = true;
                        continue block0;
                    }
                    x1 = x;
                    if (rflg && x1 < (double)1.110223E-16f) {
                        x = 0.0;
                        break block0;
                    }
                    yh = y;
                    if (dir > 0) {
                        dir = 0;
                        di = 0.5;
                    } else {
                        di = dir < -3 ? (di *= di) : (dir < -1 ? 0.5 * di : (y - y0) / (yh - yl));
                    }
                    --dir;
                }
                if (x0 >= 1.0) {
                    x = 0.9999999999999999;
                    break;
                }
                if (x <= 0.0) {
                    return 0.0;
                }
                newt = true;
            }
            if (newt) {
                newt = false;
                if (nflg) break;
                nflg = true;
                lgm = Num.lnGamma(p + q) - Num.lnGamma(p) - Num.lnGamma(q);
                for (i = 0; i < 8; ++i) {
                    if (i != 0) {
                        y = BetaDist.cdf(p, q, d, x);
                    }
                    if (y < yl) {
                        x = x0;
                        y = yl;
                    } else if (y > yh) {
                        x = x1;
                        y = yh;
                    } else if (y < y0) {
                        x0 = x;
                        yl = y;
                    } else {
                        x1 = x;
                        yh = y;
                    }
                    if (x >= 1.0 || x <= 0.0) break;
                    z = (p - 1.0) * Math.log(x) + (q - 1.0) * Math.log1p(-x) + lgm;
                    if (z < -708.3964185322641) break block0;
                    if (z > 709.782712893384) break;
                    z = Math.exp(z);
                    xt = x - (z = (y - y0) / z);
                    if (xt <= x0 && (xt = x0 + 0.5 * (y = (x - x0) / (x1 - x0)) * (x - x0)) <= 0.0 || xt >= x1 && (xt = x1 - 0.5 * (y = (x1 - x) / (x1 - x0)) * (x1 - x)) >= 1.0) break;
                    x = xt;
                    if (Math.abs(z / x) < 1.4210854715202004E-14) break block0;
                }
                dithresh = 2.842170943040401E-14;
                ihalve = true;
                continue;
            }
            yp = -NormalDist.inverseF01(u);
            if (u > 0.5) {
                rflg = true;
                p = beta;
                q = alpha;
                y0 = 1.0 - u;
                yp = -yp;
            } else {
                rflg = false;
                p = alpha;
                q = beta;
                y0 = u;
            }
            lgm = (yp * yp - 3.0) / 6.0;
            x = 2.0 / (1.0 / (2.0 * p - 1.0) + 1.0 / (2.0 * q - 1.0));
            z = yp * Math.sqrt(x + lgm) / x - (1.0 / (2.0 * q - 1.0) - 1.0 / (2.0 * p - 1.0)) * (lgm + 0.8333333333333334 - 2.0 / (3.0 * x));
            z = 2.0 * z;
            if (z < -708.3964185322641) {
                x = 1.0;
                return 0.0;
            }
            x = p / (p + q * Math.exp(z));
            y = BetaDist.cdf(p, q, d, x);
            yp = (y - y0) / y0;
            if (Math.abs(yp) < 0.2) {
                newt = true;
                continue;
            }
            ihalve = true;
        }
        if (rflg) {
            x = x <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - x;
        }
        return x;
    }

    public static double inverseF(double alpha, double beta, double a, double b, int d, double u) {
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        return a + (b - a) * BetaDist.inverseF(alpha, beta, d, u);
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double sum = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += x[i];
            a = x[i] > 0.0 ? (a += Math.log(x[i])) : (a -= 709.0);
            if (x[i] < 1.0) {
                b += Math.log1p(-x[i]);
                continue;
            }
            b -= 709.0;
        }
        double mean = sum / (double)n;
        sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += (x[i] - mean) * (x[i] - mean);
        }
        double var = sum / ((double)n - 1.0);
        Optim system = new Optim(a, b);
        double[] param = new double[3];
        param[1] = mean * (mean * (1.0 - mean) / var - 1.0);
        param[2] = (1.0 - mean) * (mean * (1.0 - mean) / var - 1.0);
        double[] fvec = new double[3];
        double[][] fjac = new double[3][3];
        int[] iflag = new int[2];
        int[] info = new int[2];
        int[] ipvt = new int[3];
        Minpack_f77.lmder1_f77((Lmder_fcn)system, (int)2, (int)2, (double[])param, (double[])fvec, (double[][])fjac, (double)1.0E-5, (int[])info, (int[])ipvt);
        double[] parameters = new double[]{param[1], param[2]};
        return parameters;
    }

    @Deprecated
    public static double[] getMaximumLikelihoodEstimate(double[] x, int n) {
        return BetaDist.getMLE(x, n);
    }

    public static BetaDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = BetaDist.getMaximumLikelihoodEstimate(x, n);
        return new BetaDist(parameters[0], parameters[1]);
    }

    public static double getMean(double alpha, double beta) {
        return BetaDist.getMean(alpha, beta, 0.0, 1.0);
    }

    public static double getMean(double alpha, double beta, double a, double b) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return (alpha * b + beta * a) / (alpha + beta);
    }

    public static double getVariance(double alpha, double beta) {
        return BetaDist.getVariance(alpha, beta, 0.0, 1.0);
    }

    public static double getVariance(double alpha, double beta, double a, double b) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return alpha * beta * (b - a) * (b - a) / ((alpha + beta) * (alpha + beta) * (alpha + beta + 1.0));
    }

    public static double getStandardDeviation(double alpha, double beta) {
        return Math.sqrt(BetaDist.getVariance(alpha, beta));
    }

    public static double getStandardDeviation(double alpha, double beta, double a, double b) {
        return Math.sqrt(BetaDist.getVariance(alpha, beta, a, b));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public void setParams(double alpha, double beta, double a, double b, int d) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        this.alpha = alpha;
        this.beta = beta;
        this.decPrec = d;
        this.supportA = this.a = a;
        this.supportB = this.b = b;
        this.bminusa = b - a;
        double temp = Num.lnGamma(alpha);
        temp = alpha == beta ? (temp *= 2.0) : (temp += Num.lnGamma(beta));
        this.logBeta = temp - Num.lnGamma(alpha + beta);
        this.Beta = Math.exp(this.logBeta);
        this.logFactor = -this.logBeta - Math.log(this.bminusa) * (alpha + beta - 1.0);
    }

    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.beta};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : alpha = " + this.alpha + ", beta = " + this.beta;
    }

    private static class Optim
    implements Lmder_fcn {
        private double a;
        private double b;

        public Optim(double a, double b) {
            this.a = a;
            this.b = b;
        }

        public void fcn(int m, int n, double[] x, double[] fvec, double[][] fjac, int[] iflag) {
            if (x[1] <= 0.0 || x[2] <= 0.0) {
                double BIG = 1.0E100;
                fvec[1] = 1.0E100;
                fvec[2] = 1.0E100;
                fjac[1][1] = 1.0E100;
                fjac[1][2] = 0.0;
                fjac[2][1] = 0.0;
                fjac[2][2] = 1.0E100;
                return;
            }
            if (iflag[1] == 1) {
                double trig = Num.digamma(x[1] + x[2]);
                fvec[1] = Num.digamma(x[1]) - trig - this.a;
                fvec[2] = Num.digamma(x[2]) - trig - this.b;
            } else if (iflag[1] == 2) {
                double trig = Num.trigamma(x[1] + x[2]);
                fjac[1][1] = Num.trigamma(x[1]) - trig;
                fjac[1][2] = -trig;
                fjac[2][1] = -trig;
                fjac[2][2] = Num.trigamma(x[2]) - trig;
            }
        }
    }
}

