/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.graphs;

import de.jstacs.algorithms.graphs.tensor.AsymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.Tensor;
import java.util.Arrays;

public class DAG {
    public static int[] computeMaximalHP(Tensor score) {
        byte index;
        byte i;
        int[] nodes;
        Object pre;
        Object best;
        byte by = score.getOrder();
        byte g = (byte)(by - 1);
        int L = score.getNumberOfNodes();
        int numOfSubsets = (int)Math.pow(2.0, L);
        int anz = 1;
        int[] copy = new int[L];
        int[] help = new int[by];
        int[] perm = new int[by];
        int[] powers = new int[by + 1];
        powers[0] = 1;
        do {
            powers[anz] = powers[anz - 1] * L;
        } while (++anz <= by);
        if (by == 1) {
            best = new double[L][numOfSubsets];
            pre = new int[L][numOfSubsets];
        } else {
            best = new double[powers[by]][];
            pre = new int[powers[by]][];
            nodes = new int[by + 1];
            anz = 0;
            while (anz < by) {
                nodes[anz] = (byte)(by - anz - 1);
                ++anz;
            }
            do {
                System.arraycopy(nodes, 0, help, 0, by);
                Arrays.sort(help);
                anz = 1;
                i = nodes[0];
                while (anz < by && help[anz] != help[anz - 1]) {
                    i += nodes[anz] * powers[anz++];
                }
                if (anz == by) {
                    best[i] = new double[numOfSubsets];
                    pre[i] = new int[numOfSubsets];
                }
                i = 0;
                while (nodes[i] == L - 1) {
                    nodes[i] = 0;
                    ++i;
                }
                byte by2 = i;
                nodes[by2] = nodes[by2] + 1;
            } while (nodes[by] == 0);
        }
        nodes = new int[L];
        int counter = 0;
        while (counter < L) {
            nodes[counter] = counter;
            ++counter;
        }
        help = new int[by];
        i = 0;
        while (true) {
            System.arraycopy(nodes, 0, copy, 0, L);
            index = 0;
            anz = 0;
            i = 0;
            while (i < by) {
                counter = help[i];
                perm[i] = copy[counter];
                anz += 1 << perm[i];
                index += perm[i] * powers[g - i];
                while (counter < L - 1) {
                    copy[counter++] = copy[counter];
                }
                ++i;
            }
            best[index][anz] = DAG.getScoreForPath(score, by, by, perm);
            pre[index][anz] = -1;
            i = g;
            while (i >= 0 && help[i] == L - i - 1) {
                help[i--] = 0;
            }
            if (i < 0) break;
            byte by3 = i;
            help[by3] = help[by3] + 1;
        }
        int l = by + 1;
        while (l <= L) {
            anz = 0;
            counter = 0;
            while (counter < l) {
                nodes[counter] = counter;
                anz += 1 << counter;
                ++counter;
            }
            block12: while (true) {
                help = new int[by];
                i = 0;
                while (i >= 0) {
                    System.arraycopy(nodes, 0, copy, 0, l);
                    counter = help[0];
                    byte current = copy[counter];
                    while (counter < l - 1) {
                        copy[counter++] = copy[counter];
                    }
                    index = current;
                    i = 1;
                    while (i < by) {
                        counter = help[i];
                        perm[i - 1] = copy[counter];
                        index += copy[counter] * powers[i];
                        while (counter < l - 1) {
                            copy[counter++] = copy[counter];
                        }
                        ++i;
                    }
                    best[index][anz] = Double.NEGATIVE_INFINITY;
                    int oldIndex = index / L;
                    int oldAnz = anz - (1 << current);
                    counter = 0;
                    while (counter < l - by) {
                        perm[g] = copy[counter];
                        double val = best[oldIndex + perm[g] * powers[g]][oldAnz] + score.getValue(by, current, perm);
                        if (best[index][anz] < val) {
                            best[index][anz] = val;
                            pre[index][anz] = perm[g];
                        }
                        ++counter;
                    }
                    i = g;
                    while (i >= 0 && help[i] == l - i - 1) {
                        help[i--] = 0;
                    }
                    if (i < 0) continue;
                    byte by4 = i;
                    help[by4] = help[by4] + 1;
                }
                i = l - 1;
                counter = (byte)(L - 1);
                while (i >= 0 && nodes[i] == counter) {
                    anz -= 1 << nodes[i--];
                    --counter;
                }
                if (i < 0) break;
                int n = anz - (1 << nodes[i]);
                byte by5 = i++;
                int n2 = nodes[by5] + 1;
                nodes[by5] = n2;
                anz = n + (1 << n2);
                while (true) {
                    if (i >= l) continue block12;
                    nodes[i] = nodes[i - 1];
                    byte by6 = i++;
                    int n3 = nodes[by6] + 1;
                    nodes[by6] = n3;
                    anz += 1 << n3;
                }
                break;
            }
            ++l;
        }
        double max = Double.NEGATIVE_INFINITY;
        anz = numOfSubsets - 1;
        i = 0;
        while (i < powers[by]) {
            if (best[i] != null && best[i][anz] > max) {
                index = i;
                max = best[i][anz];
            }
            ++i;
        }
        int[] erg = new int[L];
        i = L - 1;
        while (pre[index][anz] != -1) {
            erg[i] = index % L;
            index = index / L + pre[index][anz] * powers[g];
            anz -= 1 << erg[i--];
        }
        anz /= L;
        while (i >= 0) {
            erg[i--] = index % L;
            index /= L;
        }
        return erg;
    }

    public static int[][] computeMaximalKDAG(Tensor score) {
        return DAG.computeMaxKDAG(score instanceof SymmetricTensor ? (SymmetricTensor)score : new SymmetricTensor((AsymmetricTensor)score));
    }

    protected static int[][] computeMaxKDAG(SymmetricTensor score) {
        int[] tempEdge;
        int i;
        int L = score.getNumberOfNodes();
        int n = 0;
        int l = 0;
        int k = score.getOrder();
        if (L > 31) {
            throw new IllegalArgumentException("This algorithm can only handle bayesian networks with at most 31 nodes. If you are interested in bayesian networks with more nodes please try an other algorithm.");
        }
        int anz = 1;
        int numOfSubsets = (int)Math.pow(2.0, L);
        int[] nodes = new int[L + 1];
        nodes[0] = 0;
        double[] best = new double[numOfSubsets];
        int[] edge = new int[numOfSubsets];
        do {
            if (l == 0) {
                best[anz] = score.getRootValue(nodes[0]);
                edge[anz] = 0;
            } else {
                byte c = (byte)(k < l ? k : (byte)l);
                int[] par = new int[l];
                System.arraycopy(nodes, 0, par, 0, l);
                best[anz] = best[anz - (1 << nodes[--n])] + score.getBest(nodes[n], par, c);
                edge[anz] = score.getTrueIndexForLastGetBest();
                while (n > 0) {
                    par[--n] = nodes[n + 1] - 1;
                    double temp = best[anz - (1 << nodes[n])] + score.getBest(nodes[n], par, c);
                    if (!(best[anz] < temp)) continue;
                    best[anz] = temp;
                    edge[anz] = score.getTrueIndexForLastGetBest();
                }
            }
            i = 0;
            while ((anz & 1 << i) > 0) {
                ++i;
            }
            ++anz;
            l -= i - 1;
            nodes[0] = i;
            n = 1;
            while (n <= l) {
                while ((anz & 1 << ++i) == 0) {
                }
                nodes[n] = i;
                ++n;
            }
        } while (anz < numOfSubsets);
        int[][] tempRandDeps = new int[L][];
        --anz;
        l = L - 1;
        do {
            i = k < l ? k : l;
            tempEdge = score.getEdgeFromIndex(edge[anz], (byte)(i + 1));
            tempRandDeps[tempEdge[i]] = tempEdge;
            anz -= 1 << tempEdge[i];
        } while (--l != 0);
        tempRandDeps[tempEdge[0]] = new int[]{tempEdge[0]};
        return tempRandDeps;
    }

    public static int[] enumerateHP(Tensor score) {
        int L;
        int m = L = score.getNumberOfNodes();
        int counter = 0;
        byte k = score.getOrder();
        --m;
        int[] copy = new int[L];
        int[] index = new int[L];
        int[] bestPerm = new int[L];
        int[] perm = new int[L];
        int[] id = new int[L];
        index[0] = -1;
        while (counter < L) {
            id[counter] = counter;
            ++counter;
        }
        double bestWeights = Double.NEGATIVE_INFINITY;
        counter = 0;
        do {
            int n = counter;
            index[n] = index[n] + 1;
            System.arraycopy(id, 0, copy, 0, L);
            counter = 0;
            while (counter < L) {
                int i = index[counter];
                perm[counter] = copy[i];
                while (i < m) {
                    copy[i++] = copy[i];
                }
                ++counter;
            }
            double weights = DAG.getScoreForPath(score, L, k, perm);
            if (weights > bestWeights) {
                bestWeights = weights;
                System.arraycopy(perm, 0, bestPerm, 0, L);
            }
            counter = m;
            while (--counter >= 0 && index[counter] == m - counter) {
                index[counter] = 0;
            }
        } while (counter >= 0);
        return bestPerm;
    }

    public static double getScore(Tensor t, int[][] structure) throws IllegalArgumentException {
        int counter = 0;
        int n = t.getNumberOfNodes();
        if (structure.length != n) {
            throw new IllegalArgumentException("The given structure and tensor are defined on a different number of nodes.");
        }
        double erg = 0.0;
        while (counter < n) {
            int k = structure[counter].length - 1;
            if (k > 0) {
                erg += t.getValue((byte)k, structure[counter][k], structure[counter]);
            } else if (k == 0) {
                erg += t.getRootValue(structure[counter][k]);
            }
            ++counter;
        }
        return erg;
    }

    public static double getScoreForPath(Tensor score, int l, byte k, int[] path) {
        int j;
        int c;
        double weight = score.getRootValue(path[0]);
        int[] parents = new int[k];
        byte i = 1;
        while (i < k) {
            c = 0;
            j = i - 1;
            while (j >= 0) {
                parents[c] = path[j];
                --j;
                ++c;
            }
            weight += score.getValue(i, path[i], parents);
            i = (byte)(i + 1);
        }
        while (i < l) {
            c = 0;
            j = i - 1;
            while (j >= i - k) {
                parents[c] = path[j];
                --j;
                ++c;
            }
            weight += score.getValue(k, path[i], parents);
            i = (byte)(i + 1);
        }
        return weight;
    }

    public static int[][] getStructureFromPath(int[] path, Tensor score) {
        int j;
        int c;
        byte by = score.getOrder();
        int i = 1;
        int l = score.getNumberOfNodes();
        int[][] structure = new int[l][];
        int[] parents = new int[by];
        structure[path[0]] = new int[]{path[0]};
        while (i < by) {
            c = 0;
            j = i - 1;
            while (j >= 0) {
                parents[c] = path[j];
                --j;
                ++c;
            }
            structure[path[i]] = score.getMaximalEdgeFor((byte)i, path[i], parents);
            ++i;
        }
        while (i < l) {
            c = 0;
            j = i - 1;
            while (j >= i - by) {
                parents[c] = path[j];
                --j;
                ++c;
            }
            structure[path[i]] = score.getMaximalEdgeFor(by, path[i], parents);
            ++i;
        }
        return structure;
    }

    public static String toDirectedGraphvizFormat(int[][] structure) {
        return DAG.toGraphvizFormat(structure, " -> ");
    }

    public static String toUndirectedGraphvizFormat(int[][] structure) {
        return DAG.toGraphvizFormat(structure, " -- ");
    }

    public static String toWeightedGraphvizFormat(int[][] structure, String arrow, Tensor t) {
        String erg = "";
        double sum = 0.0;
        int i = 0;
        while (i < structure.length) {
            int j = 0;
            double current = 0.0;
            if (structure[i].length > 2) {
                erg = String.valueOf(erg) + "{" + structure[i][0];
                j = 1;
                while (j < structure[i].length - 1) {
                    erg = String.valueOf(erg) + " " + structure[i][j];
                    ++j;
                }
                erg = String.valueOf(erg) + "} " + arrow + " ";
            } else if (structure[i].length == 2) {
                erg = String.valueOf(erg) + structure[i][j++] + arrow;
            }
            erg = String.valueOf(erg) + structure[i][j];
            int k = structure[i].length - 1;
            if (k > 0) {
                current = t.getValue((byte)k, structure[i][k], structure[i]);
            } else if (k == 0) {
                current = t.getRootValue(structure[i][k]);
            }
            erg = String.valueOf(erg) + "\t[weight=" + current + "]\n";
            sum += current;
            i = (byte)(i + 1);
        }
        erg = String.valueOf(erg) + "\nscore = " + sum;
        return erg;
    }

    protected static String toGraphvizFormat(int[][] structure, String arrow) {
        String erg = "";
        int i = 0;
        while (i < structure.length) {
            int j = 0;
            if (structure[i].length > 2) {
                erg = String.valueOf(erg) + "{" + structure[i][0];
                j = 1;
                while (j < structure[i].length - 1) {
                    erg = String.valueOf(erg) + " " + structure[i][j];
                    ++j;
                }
                erg = String.valueOf(erg) + "} " + arrow + " ";
            } else if (structure[i].length == 2) {
                erg = String.valueOf(erg) + structure[i][j++] + arrow;
            }
            erg = String.valueOf(erg) + structure[i][j] + "\n";
            ++i;
        }
        return erg;
    }
}

