/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sampling;

import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sampling.AbstractBurnInTestParameterSet;
import de.jstacs.sampling.BurnInTest;
import de.jstacs.utils.DoubleList;

public abstract class AbstractBurnInTest
implements BurnInTest,
InstantiableFromParameterSet {
    protected DoubleList[] values;
    private int currentSamplingIndex;
    private boolean computed;
    private int burnInLength;
    private AbstractBurnInTestParameterSet parameters;

    protected AbstractBurnInTest(AbstractBurnInTestParameterSet parameters) throws CloneNotSupportedException {
        this.parameters = parameters.clone();
        int starts = this.parameters.getNumberOfStarts();
        this.values = new DoubleList[starts];
        int i = 0;
        while (i < starts) {
            this.values[i] = new DoubleList();
            ++i;
        }
        this.resetAllValues();
    }

    protected AbstractBurnInTest(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, this.getXMLTag());
        this.parameters = XMLParser.extractObjectForTags(xml, "parameters", AbstractBurnInTestParameterSet.class);
        this.computed = XMLParser.extractObjectForTags(xml, "computed", Boolean.TYPE);
        this.burnInLength = XMLParser.extractObjectForTags(xml, "burnInLength", Integer.TYPE);
        this.currentSamplingIndex = XMLParser.extractObjectForTags(xml, "currentSamplingIndex", Integer.TYPE);
        this.values = XMLParser.extractObjectForTags(xml, "values", DoubleList[].class);
        this.setFurtherInformation(xml);
    }

    @Override
    public AbstractBurnInTest clone() throws CloneNotSupportedException {
        return (AbstractBurnInTest)super.clone();
    }

    public AbstractBurnInTestParameterSet getCurrentParameterSet() throws CloneNotSupportedException {
        return this.parameters.clone();
    }

    @Override
    public final void resetAllValues() {
        this.currentSamplingIndex = -1;
        int i = 0;
        int end = this.values.length;
        while (i < end) {
            this.values[i].clear();
            ++i;
        }
        this.computed = false;
    }

    @Override
    public final void setCurrentSamplingIndex(int index) {
        this.currentSamplingIndex = index;
    }

    @Override
    public final void setValue(double val) {
        this.values[this.currentSamplingIndex].add(val);
        this.computed = false;
    }

    @Override
    public final StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(this.values.length * 10000);
        XMLParser.appendObjectWithTags(xml, this.parameters, "parameters");
        XMLParser.appendObjectWithTags(xml, this.computed, "computed");
        XMLParser.appendObjectWithTags(xml, this.burnInLength, "burnInLength");
        XMLParser.appendObjectWithTags(xml, this.currentSamplingIndex, "currentSamplingIndex");
        XMLParser.appendObjectWithTags(xml, this.values, "values");
        xml.append(this.getFurtherInformation());
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }

    protected abstract String getXMLTag();

    protected abstract StringBuffer getFurtherInformation();

    protected abstract void setFurtherInformation(StringBuffer var1) throws NonParsableException;

    @Override
    public final int getLengthOfBurnIn() {
        if (!this.computed) {
            this.burnInLength = this.computeLengthOfBurnIn();
            this.computed = true;
        }
        return this.burnInLength;
    }

    protected abstract int computeLengthOfBurnIn();
}

