/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.utils.ProgressUpdater;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class GUIProgressUpdater
implements ProgressUpdater,
ActionListener {
    private JProgressBar progress = new JProgressBar();
    private JFrame frame;
    private JButton b;
    private boolean canceled;

    public GUIProgressUpdater(boolean cancelButton) {
        this.progress.setIndeterminate(false);
        this.progress.setStringPainted(true);
        this.progress.setMinimum(0);
        if (cancelButton) {
            this.b = new JButton("cancel");
            this.b.addActionListener(this);
        }
    }

    @Override
    public void setMax(int max) {
        this.progress.setMaximum(max);
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(0);
        this.frame.setResizable(false);
        this.frame.setLayout(new FlowLayout());
        this.frame.add(this.progress);
        if (this.b != null) {
            this.frame.add(this.b);
        }
        this.frame.pack();
        this.frame.setVisible(true);
        this.canceled = false;
        this.setValue(0);
    }

    @Override
    public void setValue(int value) {
        this.progress.setValue(value);
        this.frame.setTitle(String.valueOf(this.progress.getString()) + " done");
        if (this.progress.getMaximum() == value) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.frame.dispose();
        }
    }

    protected void finalize() throws Throwable {
        this.frame.dispose();
        super.finalize();
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.canceled = true;
        this.frame.setVisible(false);
        this.frame.dispose();
    }
}

