/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.program.gff.GFFRecordFilter;
import org.biojava.bio.program.gff.GFFTools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FramedFeature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class GFFEntrySet {
    public static final String PROPERTY_GFF_SCORE = "org.biojava.bio.program.gff.gff_feature_score";
    private List lines = new ArrayList();

    public Iterator lineIterator() {
        return this.lines.iterator();
    }

    public void add(String comment) {
        this.lines.add(comment);
    }

    public void add(GFFRecord record) {
        this.lines.add(record);
    }

    public int size() {
        return this.lines.size();
    }

    public SequenceAnnotator getAnnotator() {
        return this.getAnnotator(true);
    }

    public SequenceAnnotator getAnnotator(final boolean checkSeqName) {
        return new SequenceAnnotator(){

            public Sequence annotate(Sequence seq) throws BioException, ChangeVetoException {
                Feature.Template plain = new Feature.Template();
                StrandedFeature.Template stranded = new StrandedFeature.Template();
                FramedFeature.Template framed = new FramedFeature.Template();
                plain.annotation = Annotation.EMPTY_ANNOTATION;
                stranded.annotation = Annotation.EMPTY_ANNOTATION;
                framed.annotation = Annotation.EMPTY_ANNOTATION;
                Iterator i = GFFEntrySet.this.lineIterator();
                while (i.hasNext()) {
                    Feature.Template thisTemplate;
                    Object o = i.next();
                    if (!(o instanceof GFFRecord)) continue;
                    GFFRecord rec = (GFFRecord)o;
                    if (checkSeqName && !rec.getSeqName().equals(seq.getName())) continue;
                    if (rec.getStrand() == StrandedFeature.UNKNOWN) {
                        plain.location = new RangeLocation(rec.getStart(), rec.getEnd());
                        plain.type = rec.getFeature();
                        plain.source = rec.getSource();
                        thisTemplate = plain;
                    } else if (rec.getFrame() == GFFTools.NO_FRAME) {
                        stranded.location = new RangeLocation(rec.getStart(), rec.getEnd());
                        stranded.type = rec.getFeature();
                        stranded.source = rec.getSource();
                        stranded.strand = rec.getStrand();
                        thisTemplate = stranded;
                    } else {
                        framed.location = new RangeLocation(rec.getStart(), rec.getEnd());
                        framed.type = rec.getFeature();
                        framed.source = rec.getSource();
                        framed.strand = rec.getStrand();
                        switch (rec.getFrame()) {
                            case 0: {
                                framed.readingFrame = FramedFeature.FRAME_0;
                                break;
                            }
                            case 1: {
                                framed.readingFrame = FramedFeature.FRAME_1;
                                break;
                            }
                            case 2: {
                                framed.readingFrame = FramedFeature.FRAME_2;
                            }
                        }
                        thisTemplate = framed;
                    }
                    thisTemplate.annotation = new SmallAnnotation();
                    if (rec.getScore() != GFFTools.NO_SCORE) {
                        thisTemplate.annotation.setProperty(GFFEntrySet.PROPERTY_GFF_SCORE, new Double(rec.getScore()));
                    }
                    Map attributes = rec.getGroupAttributes();
                    for (String key : attributes.keySet()) {
                        thisTemplate.annotation.setProperty(key, attributes.get(key));
                    }
                    seq.createFeature(thisTemplate);
                }
                return seq;
            }
        };
    }

    public GFFEntrySet filter(GFFRecordFilter filter) {
        GFFEntrySet accepted = new GFFEntrySet();
        Iterator i = this.lineIterator();
        while (i.hasNext()) {
            GFFRecord record;
            Object o = i.next();
            if (!(o instanceof GFFRecord) || !filter.accept(record = (GFFRecord)o)) continue;
            accepted.add(record);
        }
        return accepted;
    }

    public GFFDocumentHandler getAddHandler() {
        return new EntrySetBuilder();
    }

    public void streamRecords(GFFDocumentHandler handler) {
        handler.startDocument("");
        Iterator i = this.lineIterator();
        while (i.hasNext()) {
            Object line = i.next();
            if (line instanceof String) {
                handler.commentLine((String)line);
                continue;
            }
            handler.recordLine((GFFRecord)line);
        }
        handler.endDocument();
    }

    private class EntrySetBuilder
    implements GFFDocumentHandler {
        private EntrySetBuilder() {
        }

        public void startDocument(String locator) {
        }

        public void endDocument() {
        }

        public void commentLine(String comment) {
            GFFEntrySet.this.lines.add(comment);
        }

        public void recordLine(GFFRecord record) {
            GFFEntrySet.this.lines.add(record);
        }
    }
}

