/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.classifiers.differentiableSequenceScoreBased.RankBasedOptimizableFunction3;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModelFactory;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSM;
import de.jstacs.utils.REnvironment;
import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import de.jstacs.utils.graphics.GraphicsAdaptorFactory;
import java.io.PrintWriter;

public class BulykCumulPWMs {
    public static void main(String[] args) throws Exception {
        DNADataSet ds = new DNADataSet(args[0], '>', new SplitSequenceAnnotationParser(":", ","));
        String outdir = args[1];
        DataSet[] dss = RankBasedOptimizableFunction3.splitByTagAndSort(1, ds, "group", "localWeight2");
        REnvironment re = new REnvironment();
        int i = 0;
        while (i < dss.length) {
            String group = dss[i].getElementAt(0).getSequenceAnnotationByType("group", 0).getIdentifier();
            String tal = dss[i].getElementAt(0).getSequenceAnnotationByType("seq", 0).getIdentifier();
            String[] rvds = tal.split("-");
            String targetS = tal.replaceAll("HD", "C").replaceAll("NG", "T").replaceAll("NI", "A").replaceAll("NN", "G").replaceAll("-", "");
            String[] labs = targetS.split("");
            Sequence target = Sequence.create(DNAAlphabetContainer.SINGLETON, "T" + targetS);
            int j = 1;
            while (j < dss[i].getNumberOfElements()) {
                DataSet part = dss[i].getPartialDataSet(0, j);
                double[] ws = new double[part.getNumberOfElements()];
                int k = 0;
                while (k < ws.length) {
                    ws[k] = Double.parseDouble(part.getElementAt(k).getSequenceAnnotationByType("globalWeight", 0).getIdentifier());
                    ++k;
                }
                BayesianNetworkDiffSM model = DifferentiableStatisticalModelFactory.createPWM(DNAAlphabetContainer.SINGLETON, dss[i].getElementLength(), 0.0);
                model.initializeFunction(0, false, new DataSet[]{part}, new double[][]{ws});
                double[][] pwm = model.getPWM();
                GraphicsAdaptor ga = GraphicsAdaptorFactory.getAdaptor(GraphicsAdaptorFactory.OutputFormat.PDF);
                SeqLogoPlotter.plotLogo(ga.getGraphics(SeqLogoPlotter.getWidth(500, pwm), 500), 500, pwm, labs, "", "");
                ga.generateOutput(String.valueOf(outdir) + "/" + group + "_" + j + ".pdf");
                j *= 2;
            }
            PrintWriter wr3 = new PrintWriter(String.valueOf(outdir) + "/mms_" + group + ".txt");
            PrintWriter wr1 = new PrintWriter(String.valueOf(outdir) + "/mm1_" + group + ".txt");
            PrintWriter wr2 = new PrintWriter(String.valueOf(outdir) + "/mm2_" + group + ".txt");
            StringBuffer buf1 = new StringBuffer();
            StringBuffer buf2 = new StringBuffer();
            double[] ranks = new double[dss[i].getNumberOfElements()];
            double[] ham = new double[dss[i].getNumberOfElements()];
            int j2 = 0;
            while (j2 < dss[i].getNumberOfElements()) {
                ranks[j2] = j2;
                ham[j2] = dss[i].getElementAt(j2).getHammingDistance(target);
                String gw = dss[i].getElementAt(j2).getSequenceAnnotationByType("globalWeight", 0).getIdentifier();
                String lw = dss[i].getElementAt(j2).getSequenceAnnotationByType("localWeight2", 0).getIdentifier();
                if (ham[j2] == 1.0) {
                    wr1.print(buf1);
                    wr1.println(String.valueOf(BulykCumulPWMs.diff(target, dss[i].getElementAt(j2))) + "\t" + j2 + "\t" + gw + "\t" + lw + "\t" + ham[j2]);
                    buf1.delete(0, buf1.length());
                    int[] diff = BulykCumulPWMs.diffPos(target, dss[i].getElementAt(j2));
                    wr3.println(String.valueOf(group) + "\t" + (diff[0] == 0 ? "0" : rvds[diff[0] - 1]) + "\t" + diff[0] + "\t" + diff[1] + "\t" + j2 + "\t" + gw + "\t" + lw);
                } else if (ham[j2] == 2.0) {
                    wr2.print(buf2);
                    wr2.println(String.valueOf(BulykCumulPWMs.diff(target, dss[i].getElementAt(j2))) + "\t" + j2 + "\t" + gw + "\t" + lw + "\t" + ham[j2]);
                    buf2.delete(0, buf2.length());
                } else if (ham[j2] == 0.0) {
                    wr1.print(buf1);
                    wr2.print(buf2);
                    wr1.println(String.valueOf(dss[i].getElementAt(j2).toString()) + "\t" + j2 + "\t" + gw + "\t" + lw + "\t" + ham[j2]);
                    wr2.println(String.valueOf(dss[i].getElementAt(j2).toString()) + "\t" + j2 + "\t" + gw + "\t" + lw + "\t" + ham[j2]);
                    buf1.delete(0, buf1.length());
                    buf2.delete(0, buf2.length());
                    wr3.println(String.valueOf(group) + "\tNA\tNA\tNA\t" + j2 + "\t" + gw + "\t" + lw);
                } else {
                    String str = String.valueOf(BulykCumulPWMs.diff(target, dss[i].getElementAt(j2))) + "\t" + j2 + "\t" + gw + "\t" + lw + "\t" + ham[j2] + "\n";
                    buf1.append(str);
                    buf2.append(str);
                }
                ++j2;
            }
            wr1.close();
            wr2.close();
            wr3.close();
            re.createVector("ranks", ranks);
            re.createVector("ham", ham);
            re.plotToPDF("plot(ranks,ham)", 10.0, 10.0, String.valueOf(outdir) + "/ham_" + group + ".pdf", true);
            ++i;
        }
    }

    private static int[] diffPos(Sequence target, Sequence cand) {
        int i = 0;
        while (i < target.getLength()) {
            if (target.discreteVal(i) != cand.discreteVal(i)) {
                return new int[]{i, cand.discreteVal(i)};
            }
            ++i;
        }
        return null;
    }

    private static String diff(Sequence target, Sequence cand) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < target.getLength()) {
            if (target.discreteVal(i) == cand.discreteVal(i)) {
                buf.append("-");
            } else {
                buf.append(cand.toString(i, i + 1));
            }
            ++i;
        }
        return buf.toString();
    }
}

