/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das.dasalignment;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.CardinalityConstraint;
import org.biojava.bio.CollectionConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.program.das.dasalignment.DASException;
import org.biojava.bio.structure.Atom;

public class Alignment {
    private List objects = new ArrayList();
    private List scores = new ArrayList();
    private List blocks = new ArrayList();
    private List vectors = new ArrayList();
    private List matrices = new ArrayList();
    private static final AnnotationType objectType = Alignment.getObjectAnnotationType();
    private static final AnnotationType scoreType = Alignment.getScoreAnnotationType();
    private static final AnnotationType blockType;
    private static final AnnotationType segmentType;
    private static final AnnotationType vectorType;
    private static final AnnotationType matrixType;

    public static AnnotationType getVectorAnnotationType() {
        AnnotationType.Impl annType = new AnnotationType.Impl();
        annType.setConstraints("intObjectId", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        annType.setConstraints("vector", new PropertyConstraint.ByClass(Atom.class), CardinalityConstraint.ONE);
        return annType;
    }

    public static AnnotationType getMatrixAnnotationType() {
        AnnotationType.Impl annType = new AnnotationType.Impl();
        annType.setConstraints("intObjectId", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        for (int x = 1; x <= 3; ++x) {
            for (int y = 1; y <= 3; ++y) {
                String mat = "mat" + x + y;
                annType.setConstraints(mat, new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
            }
        }
        return annType;
    }

    public static AnnotationType getScoreAnnotationType() {
        AnnotationType.Impl annType = new AnnotationType.Impl();
        annType.setConstraints("methodName", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        annType.setConstraints("value", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        return annType;
    }

    public static AnnotationType getBlockAnnotationType() {
        AnnotationType.Impl annType = new AnnotationType.Impl();
        annType.setConstraints("blockOrder", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        annType.setConstraints("blockScore", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ANY);
        PropertyConstraint.ByAnnotationType prop = new PropertyConstraint.ByAnnotationType(segmentType);
        annType.setConstraint("segments", new CollectionConstraint.AllValuesIn(prop, CardinalityConstraint.ANY));
        return annType;
    }

    public static AnnotationType getSegmentAnnotationType() {
        AnnotationType.Impl annType = new AnnotationType.Impl();
        annType.setConstraints("intObjectId", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        annType.setConstraints("start", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ANY);
        annType.setConstraints("end", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ANY);
        annType.setConstraints("strand", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ANY);
        annType.setConstraints("cigar", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ANY);
        return annType;
    }

    public static AnnotationType getObjectAnnotationType() {
        AnnotationType.Impl annType = new AnnotationType.Impl();
        annType.setConstraints("dbAccessionId", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        annType.setConstraints("intObjectId", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        annType.setConstraints("objectVersion", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        annType.setConstraints("type", new PropertyConstraint.Enumeration(new Object[]{"DNA", "PROTEIN", "STRUCTURE"}), CardinalityConstraint.ANY);
        annType.setConstraints("dbSource", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        annType.setConstraints("dbVersion", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        annType.setConstraints("dbCoordSys", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ANY);
        annType.setConstraints("sequence", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ANY);
        annType.setConstraints("seqStart", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ANY);
        annType.setConstraints("seqEnd", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ANY);
        return annType;
    }

    public void addVector(Annotation vector) throws DASException {
        if (!vectorType.instanceOf(vector)) {
            throw new IllegalArgumentException("Expecting an annotation conforming to: " + vectorType + " but got: " + vector);
        }
        this.vectors.add(vector);
    }

    public void addMatrix(Annotation matrix) throws DASException {
        if (!matrixType.instanceOf(matrix)) {
            throw new IllegalArgumentException("Expecting an annotation conforming to: " + matrixType + " but got: " + matrix);
        }
        this.matrices.add(matrix);
    }

    public void addObject(Annotation object) throws DASException {
        if (!objectType.instanceOf(object)) {
            throw new IllegalArgumentException("Expecting an annotation conforming to: " + objectType + " but got: " + object);
        }
        this.objects.add(object);
    }

    public Annotation[] getObjects() {
        return this.objects.toArray(new Annotation[this.objects.size()]);
    }

    public Annotation[] getVectors() {
        return this.vectors.toArray(new Annotation[this.vectors.size()]);
    }

    public Annotation[] getMatrices() {
        return this.matrices.toArray(new Annotation[this.matrices.size()]);
    }

    public void addScore(Annotation score) throws DASException {
        if (!scoreType.instanceOf(score)) {
            throw new IllegalArgumentException("Expecting an annotation conforming to: " + scoreType + " but got: " + score);
        }
        this.scores.add(score);
    }

    public Annotation[] getScores() {
        return this.scores.toArray(new Annotation[this.scores.size()]);
    }

    public void addBlock(Annotation block) throws DASException {
        if (!blockType.instanceOf(block)) {
            throw new IllegalArgumentException("Expecting an annotation conforming to: " + blockType + " but got: " + block);
        }
        this.blocks.add(block);
    }

    public Annotation[] getBlocks() {
        return this.blocks.toArray(new Annotation[this.blocks.size()]);
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.objects.size(); ++i) {
            Annotation object = (Annotation)this.objects.get(i);
            str = str + "object: " + (String)object.getProperty("dbAccessionId") + "\n";
        }
        str = str + "number of blocks: " + this.blocks.size();
        return str;
    }

    static {
        segmentType = Alignment.getSegmentAnnotationType();
        blockType = Alignment.getBlockAnnotationType();
        vectorType = Alignment.getVectorAnnotationType();
        matrixType = Alignment.getMatrixAnnotationType();
    }
}

