/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.latticeReduction;

public final class ExactLLL {
    private static int[] P = new int[10];
    private static long[] D = new long[11];
    private static long[][] lam = new long[10][10];
    static long[] det = new long[1];

    private static long exactDiv(long l, long l2) {
        if (l % l2 != 0L) {
            throw new RuntimeException("nonbzero remainder");
        }
        return l / l2;
    }

    private static long balDiv(long l, long l2) {
        long l3 = l % l2;
        long l4 = l / l2;
        if (l3 + l3 > l2 || l3 + l3 == l2 && l4 < 0L) {
            return l4 + 1L;
        }
        return l4;
    }

    private static long mulAddDiv(long l, long l2, long l3, long l4, long l5) {
        return (l3 * l + l4 * l2) / l5;
    }

    private static long mulSubDiv(long l, long l2, long l3, long l4, long l5) {
        return (l3 * l - l4 * l2) / l5;
    }

    private static void mulSubDiv(long[] lArray, long[] lArray2, long[] lArray3, long l, long l2, long l3) {
        int n = lArray.length;
        if (lArray2.length != n || lArray3.length != n) {
            throw new IllegalArgumentException("length mismatch");
        }
        for (int i = 0; i < n; ++i) {
            lArray[i] = (l * lArray2[i] - l2 * lArray3[i]) / l3;
        }
    }

    private static void rowTransform(long[] lArray, long[] lArray2, long l, long l2, long l3, long l4) {
        int n = lArray.length;
        if (lArray2.length != n) {
            throw new IllegalArgumentException("length mismatch");
        }
        for (int i = 0; i < n; ++i) {
            long l5 = l * lArray[i] + l2 * lArray2[i];
            long l6 = l3 * lArray[i] + l4 * lArray2[i];
            lArray[i] = l5;
            lArray2[i] = l6;
        }
    }

    private static void rowTransform(long[][] lArray, int n, int n2, int n3, long l, long l2, long l3, long l4) {
        long l5 = l * lArray[n][n3] + l2 * lArray[n2][n3];
        long l6 = l3 * lArray[n][n3] + l4 * lArray[n2][n3];
        lArray[n][n3] = l5;
        lArray[n2][n3] = l6;
    }

    private static long mulAdd(long l, long l2, long l3) {
        return l + l3 * l2;
    }

    private static long mulSub(long l, long l2, long l3) {
        return l - l3 * l2;
    }

    private static void mulSub(long[] lArray, long[] lArray2, long[] lArray3, long l) {
        int n = lArray.length;
        if (lArray2.length != n || lArray3.length != n) {
            throw new IllegalArgumentException("length mismatch");
        }
        for (int i = 0; i < n; ++i) {
            lArray[i] = lArray2[i] - l * lArray3[i];
        }
    }

    private static boolean swapTest(long l, long l2, long l3, long l4, long l5, long l6) {
        return l5 * l2 * l2 > l6 * (l * l3 + l4 * l4);
    }

    private static void reduce(int n, int n2, long[][] lArray, int[] nArray, long[] lArray2, long[][] lArray3, long[][] lArray4) {
        if (nArray[n2] == -1) {
            return;
        }
        if (2L * Math.abs(lArray3[n][nArray[n2]]) < lArray2[1 + nArray[n2]]) {
            return;
        }
        long l = ExactLLL.balDiv(lArray3[n][nArray[n2]], lArray2[1 + nArray[n2]]);
        ExactLLL.mulSub(lArray[n], lArray[n], lArray[n2], l);
        if (lArray4 != null) {
            ExactLLL.mulSub(lArray4[n], lArray4[n], lArray4[n2], l);
        }
        for (int i = 0; i <= n2 - 1; ++i) {
            if (nArray[i] == -1) continue;
            lArray3[n][nArray[i]] = ExactLLL.mulSub(lArray3[n][nArray[i]], lArray3[n2][nArray[i]], l);
        }
        lArray3[n][nArray[n2]] = ExactLLL.mulSub(lArray3[n][nArray[n2]], lArray2[1 + nArray[n2]], l);
    }

    private static void swap(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        lArray2 = lArray;
        lArray2 = lArray3;
    }

    private static final long gcd(long l, long l2) {
        while (l != 0L) {
            long l3 = l2 % l;
            l2 = l;
            l = l3;
        }
        return l2;
    }

    private static final long xgcd(long l, long l2, long[] lArray) {
        long l3 = l;
        long l4 = l2 % l;
        long l5 = 1L;
        long l6 = -l2 / l;
        long l7 = 0L;
        long l8 = 1L;
        do {
            long l9 = l3;
            l3 = l4;
            long l10 = l5;
            l5 = l6;
            long l11 = l7;
            l7 = l8;
            long l12 = l9 / l3;
            l4 = l9 % l3;
            l6 = l10 - l12 * l5;
            l8 = l11 - l12 * l7;
        } while (l4 != 0L);
        lArray[0] = l5;
        lArray[1] = l7;
        return l3;
    }

    private static boolean swap(int n, long[][] lArray, int[] nArray, long[] lArray2, long[][] lArray3, long[][] lArray4, int n2, boolean bl) {
        int n3;
        if (nArray[n] != -1) {
            long l;
            int n4;
            if (bl) {
                System.out.println("swap case 1: " + n);
            }
            ExactLLL.swap(lArray[n - 1], lArray[n]);
            if (lArray4 != null) {
                ExactLLL.swap(lArray4[n - 1], lArray4[n]);
            }
            for (n4 = 0; n4 <= n - 2; ++n4) {
                if (nArray[n4] == -1) continue;
                l = lArray3[n - 1][nArray[n4]];
                lArray3[n - 1][nArray[n4]] = lArray3[n][nArray[n4]];
                lArray3[n][nArray[n4]] = l;
            }
            for (n4 = n + 1; n4 < n2; ++n4) {
                l = ExactLLL.mulAddDiv(lArray3[n4][nArray[n] - 1], lArray3[n4][nArray[n]], lArray3[n][nArray[n] - 1], lArray2[1 + nArray[n] - 2], lArray2[1 + nArray[n] - 1]);
                long l2 = ExactLLL.mulSubDiv(lArray3[n4][nArray[n] - 1], lArray3[n4][nArray[n]], lArray2[1 + nArray[n]], lArray3[n][nArray[n] - 1], lArray2[1 + nArray[n] - 1]);
                lArray3[n4][nArray[n] - 1] = l;
                lArray3[n4][nArray[n]] = l2;
            }
            lArray2[1 + nArray[n] - 1] = ExactLLL.mulAddDiv(lArray2[1 + nArray[n]], lArray3[n][nArray[n] - 1], lArray2[1 + nArray[n] - 2], lArray3[n][nArray[n] - 1], lArray2[1 + nArray[n] - 1]);
            return false;
        }
        if (lArray3[n][nArray[n - 1]] != 0L) {
            int n5;
            if (bl) {
                System.out.println("swap case 2: " + n);
            }
            long[] lArray5 = new long[2];
            long l = ExactLLL.xgcd(lArray3[n][nArray[n - 1]], lArray2[1 + nArray[n - 1]], lArray5);
            long l3 = lArray5[0];
            long l4 = lArray5[1];
            long l5 = ExactLLL.exactDiv(lArray3[n][nArray[n - 1]], l);
            long l6 = ExactLLL.exactDiv(lArray2[1 + nArray[n - 1]], l);
            long l7 = -l6;
            ExactLLL.rowTransform(lArray[n - 1], lArray[n], l5, l7, l4, l3);
            if (lArray4 != null) {
                ExactLLL.rowTransform(lArray4[n - 1], lArray4[n], l5, l7, l4, l3);
            }
            for (n5 = 0; n5 <= n - 2; ++n5) {
                if (nArray[n5] == -1) continue;
                ExactLLL.rowTransform(lArray3, n - 1, n, nArray[n5], l5, l7, l4, l3);
            }
            l7 *= l7;
            lArray2[1 + nArray[n - 1]] = ExactLLL.exactDiv(lArray2[1 + nArray[n - 1]], l7);
            for (n5 = n + 1; n5 < n2; ++n5) {
                if (nArray[n5] == -1) continue;
                lArray2[1 + nArray[n5]] = ExactLLL.exactDiv(lArray2[1 + nArray[n5]], l7);
                for (int i = n5 + 1; i < n2; ++i) {
                    lArray3[i][nArray[n5]] = ExactLLL.exactDiv(lArray3[i][nArray[n5]], l7);
                }
            }
            for (n5 = n + 1; n5 < n2; ++n5) {
                lArray3[n5][nArray[n - 1]] = ExactLLL.exactDiv(lArray3[n5][nArray[n - 1]], l6);
            }
            n5 = nArray[n - 1];
            nArray[n - 1] = nArray[n];
            nArray[n] = n5;
            return true;
        }
        if (bl) {
            System.out.println("swap case 3: " + n);
        }
        ExactLLL.swap(lArray[n - 1], lArray[n]);
        if (lArray4 != null) {
            ExactLLL.swap(lArray4[n - 1], lArray4[n]);
        }
        for (n3 = 0; n3 <= n - 2; ++n3) {
            if (nArray[n3] == -1) continue;
            long l = lArray3[n - 1][nArray[n3]];
            lArray3[n - 1][nArray[n3]] = lArray3[n][nArray[n3]];
            lArray3[n][nArray[n3]] = l;
        }
        n3 = nArray[n - 1];
        nArray[n - 1] = nArray[n];
        nArray[n] = n3;
        return false;
    }

    private static long innerProduct(long[] lArray, long[] lArray2) {
        long l = 0L;
        if (lArray.length != lArray2.length) {
            throw new IllegalArgumentException("length mismatch");
        }
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i] * lArray2[i];
        }
        return l;
    }

    private static int incrementalGS(long[][] lArray, int[] nArray, long[] lArray2, long[][] lArray3, int n, int n2) {
        long l;
        long l2 = lArray[0].length;
        long l3 = lArray.length;
        for (int i = 0; i <= n2 - 1; ++i) {
            int n3 = nArray[i];
            if (n3 == -1) continue;
            long l4 = ExactLLL.innerProduct(lArray[n2], lArray[i]);
            for (int j = 0; j <= n3 - 1; ++j) {
                l = lArray2[1 + j] * l4;
                long l5 = lArray3[n2][j] * lArray3[i][j];
                l4 = (l - l5) / lArray2[1 + j - 1];
            }
            lArray3[n2][n3] = l4;
        }
        long l6 = ExactLLL.innerProduct(lArray[n2], lArray[n2]);
        for (int i = 0; i < n; ++i) {
            long l7 = lArray2[1 + i] * l6;
            l = lArray3[n2][i] * lArray3[n2][i];
            l6 = (l7 - l) / lArray2[1 + i - 1];
        }
        if (l6 == 0L) {
            nArray[n2] = -1;
        } else {
            nArray[n2] = n;
            lArray2[1 + n] = l6;
            ++n;
        }
        return n;
    }

    private static long[] reduce(long[][] lArray, long[][] lArray2, long l, long l2, boolean bl) {
        int n;
        int n2;
        int n3 = lArray[0].length;
        int n4 = lArray.length;
        boolean bl2 = true;
        if (P.length < n4) {
            P = new int[n4];
            D = new long[n4 + 1];
        } else {
            for (n2 = 0; n2 < n4; ++n2) {
                ExactLLL.P[n2] = 0;
                ExactLLL.D[n2] = 0L;
                for (n = 0; n < n4; ++n) {
                    ExactLLL.lam[n2][n] = 0L;
                }
            }
        }
        ExactLLL.D[n4] = 0L;
        ExactLLL.D[0] = 1L;
        if (lArray2.length != n4 || lArray2[0].length != n4) {
            throw new IllegalArgumentException("U has wrong length");
        }
        if (lArray2 != null) {
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n4; ++n) {
                    lArray2[n2][n] = n2 == n ? 1L : 0L;
                }
            }
        }
        n2 = 0;
        n = 0;
        int n5 = -1;
        while (n < n4) {
            if (n > n5) {
                n2 = ExactLLL.incrementalGS(lArray, P, D, lam, n2, n);
                n5 = n;
            }
            if (n == 0) {
                bl2 = true;
                ++n;
                continue;
            }
            if (bl2) {
                for (int i = n - 1; i >= 0; --i) {
                    ExactLLL.reduce(n, i, lArray, P, D, lam, lArray2);
                }
            }
            if (P[n - 1] != -1 && (P[n] == -1 || ExactLLL.swapTest(D[1 + P[n]], D[1 + P[n] - 1], D[1 + P[n] - 2], lam[n][P[n] - 1], l, l2))) {
                bl2 = ExactLLL.swap(n, lArray, P, D, lam, lArray2, n5, bl);
                --n;
                continue;
            }
            bl2 = true;
            ++n;
        }
        long[] lArray3 = new long[n2 + 1];
        System.arraycopy(D, 0, lArray3, 0, n2 + 1);
        return lArray3;
    }

    public static int reduce(long[][] lArray, long[][] lArray2) {
        return ExactLLL.reduce(lArray, lArray2, 3L, 4L, false).length - 1;
    }

    public static int reduce(long[][] lArray, long[][] lArray2, long[] lArray3) {
        long[] lArray4 = ExactLLL.reduce(lArray, lArray2, 3L, 4L, false);
        int n = lArray4.length - 1;
        lArray3[0] = lArray4[n];
        return n;
    }

    public static int reduce(long[][] lArray, long[][] lArray2, long l, long l2, long[] lArray3) {
        if (l <= 0L || l2 <= 0L || l > l2 || l2 / 4L >= l) {
            throw new IllegalArgumentException("wrong constants");
        }
        long[] lArray4 = ExactLLL.reduce(lArray, lArray2, l, l2, false);
        int n = lArray4.length - 1;
        lArray3[0] = lArray4[n];
        return n;
    }

    public static int reduce(long[][] lArray, long l, long l2, long[] lArray2) {
        return ExactLLL.reduce(lArray, (long[][])null, l, l2, lArray2);
    }

    private static long image(long[][] lArray, long[][] lArray2, long[] lArray3, boolean bl) {
        int n;
        int n2;
        int n3 = lArray[0].length;
        int n4 = lArray.length;
        boolean bl2 = true;
        if (P.length < n4) {
            P = new int[n4];
            D = new long[n4 + 1];
        } else {
            for (n2 = 0; n2 < n4; ++n2) {
                ExactLLL.P[n2] = 0;
                ExactLLL.D[n2] = 0L;
                for (n = 0; n < n4; ++n) {
                    ExactLLL.lam[n2][n] = 0L;
                }
            }
        }
        ExactLLL.D[n4] = 0L;
        ExactLLL.D[0] = 1L;
        if (lArray2.length != n4 || lArray2[0].length != n4) {
            throw new IllegalArgumentException("U has wrong length");
        }
        if (lArray2 != null) {
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n4; ++n) {
                    lArray2[n2][n] = n2 == n ? 1L : 0L;
                }
            }
        }
        n2 = 0;
        n = 0;
        int n5 = -1;
        while (n < n4) {
            if (n > n5) {
                ExactLLL.incrementalGS(lArray, P, D, lam, n2, n);
                n5 = n;
            }
            if (n == 0) {
                bl2 = true;
                ++n;
                continue;
            }
            if (bl2) {
                for (int i = n - 1; i >= 0; --i) {
                    ExactLLL.reduce(n, i, lArray, P, D, lam, lArray2);
                }
            }
            if (P[n - 1] != -1 && P[n] == -1) {
                bl2 = ExactLLL.swap(n, lArray, P, D, lam, lArray2, n5, bl);
                --n;
                continue;
            }
            bl2 = true;
            ++n;
        }
        lArray3[0] = D[n2];
        return n2;
    }

    public static long image(long[][] lArray, long[][] lArray2, long[] lArray3) {
        return ExactLLL.image(lArray, lArray2, lArray3, false);
    }

    public static long image(long[][] lArray, long[][] lArray2) {
        return ExactLLL.image(lArray, lArray2, det, false);
    }

    public static long image(long[][] lArray) {
        return ExactLLL.image(lArray, null, det, false);
    }
}

