/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx;

import de.jstacs.fx.Viewer;
import de.jstacs.tools.JstacsTool;
import java.awt.Desktop;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HelpViewer
extends Viewer {
    public HelpViewer(JstacsTool tool) {
        super(tool);
    }

    @Override
    protected String parse(JstacsTool tool) {
        String restruct = tool.getHelpText();
        String[] lines = restruct.split("\n");
        Pattern bold = Pattern.compile("\\*\\*(.+?)\\*\\*");
        Pattern italics = Pattern.compile("\\*(.+?)\\*");
        Pattern tt = Pattern.compile("\\`\\`(.+?)\\`\\`");
        Pattern amp = Pattern.compile("\"");
        Pattern link = Pattern.compile("^\\.\\.\\s+\\_(.*?)\\s*\\:\\s*(.*)$");
        HashMap<Pattern, String> linkTargets = new HashMap<Pattern, String>();
        int i = 0;
        while (i < lines.length) {
            Matcher m = bold.matcher(lines[i]);
            lines[i] = m.replaceAll("<b>$1</b>");
            m = italics.matcher(lines[i]);
            lines[i] = m.replaceAll("<i>$1</i>");
            m = tt.matcher(lines[i]);
            lines[i] = m.replaceAll("<kbd>$1</kbd>");
            m = amp.matcher(lines[i]);
            lines[i] = m.replaceAll("&quot;");
            m = link.matcher(lines[i]);
            if (m.matches()) {
                String key = m.group(1);
                String target = m.group(2);
                linkTargets.put(Pattern.compile("\\`?(" + key + ")\\`?\\_"), target);
                lines[i] = "";
            } else {
                lines[i] = String.valueOf(lines[i]) + "<br>";
            }
            ++i;
        }
        i = 0;
        while (i < lines.length) {
            Set pats = linkTargets.keySet();
            for (Pattern pat : pats) {
                Matcher m = pat.matcher(lines[i]);
                lines[i] = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE) ? m.replaceAll("<a href=\"" + (String)linkTargets.get(pat) + "\">$1</a>") : m.replaceAll("$1 (" + (String)linkTargets.get(pat) + ")");
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<div style=\"font-family:sans-serif;\">");
        int i2 = 0;
        while (i2 < lines.length) {
            sb.append(lines[i2]);
            sb.append("\n");
            ++i2;
        }
        sb.append("</div>");
        return sb.toString();
    }

    @Override
    protected String getTitle(JstacsTool tool) {
        return "Help for " + tool.getToolName();
    }
}

