/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx;

import de.jstacs.utils.Pair;
import javafx.animation.FadeTransition;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.util.Duration;

public class Messages {
    private Label message;
    private HBox box = new HBox();
    private ObservableList<Pair<String, Level>> messages;

    public Messages() {
        this.box.setAlignment(Pos.CENTER);
        this.message = new Label();
        this.message.getStyleClass().add((Object)"overlay");
        this.box.getChildren().add((Object)this.message);
        this.box.setOpacity(0.0);
        this.box.setMouseTransparent(true);
        this.messages = FXCollections.observableArrayList();
        this.messages.addListener((ListChangeListener)new ListChangeListener<Pair<String, Level>>(){

            public void onChanged(ListChangeListener.Change<? extends Pair<String, Level>> arg0) {
                while (arg0.next()) {
                    if (Messages.this.messages.size() != 1 && (arg0.getRemovedSize() <= 0 || Messages.this.messages.size() <= 0)) continue;
                    final Pair first = (Pair)Messages.this.messages.get(0);
                    String text = (String)first.getFirstElement();
                    Level level = (Level)((Object)first.getSecondElement());
                    Messages.this.message.setText(text);
                    if (level == Level.WARNING) {
                        Messages.this.message.setId("errover");
                    } else if (level == Level.SUCCESS) {
                        Messages.this.message.setId("succover");
                    } else {
                        Messages.this.message.setId("");
                    }
                    Messages.this.box.setOpacity(0.5);
                    FadeTransition fade = new FadeTransition(Duration.millis((double)1500.0), (Node)Messages.this.box);
                    fade.setDelay(Duration.millis((double)2500.0));
                    fade.setAutoReverse(false);
                    fade.setFromValue(0.5);
                    fade.setToValue(0.0);
                    fade.play();
                    fade.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent arg0) {
                            Messages.this.box.setOpacity(0.0);
                            Messages.this.messages.remove((Object)first);
                        }
                    });
                }
            }
        });
    }

    public Pane getMessagePane() {
        return this.box;
    }

    public void displayMessage(String text, Level level) {
        this.messages.add(new Pair<String, Level>(text, level));
    }

    public static enum Level {
        SUCCESS,
        INFO,
        WARNING;

    }
}

