/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx;

import de.jstacs.tools.JstacsTool;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;

public abstract class Viewer
extends Stage {
    public Viewer(JstacsTool tool) {
        this.setTitle(this.getTitle(tool));
        String content = tool.getHelpText();
        content = this.parse(tool);
        final WebView view = new WebView();
        view.getEngine().loadContent(content);
        view.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> arg0, Worker.State arg1, Worker.State arg2) {
                if (arg2 == Worker.State.SUCCEEDED) {
                    Document doc = view.getEngine().getDocument();
                    NodeList list = doc.getElementsByTagName("a");
                    int i = 0;
                    while (i < list.getLength()) {
                        EventTarget target = (EventTarget)((Object)list.item(i));
                        target.addEventListener("click", new EventListener(){

                            @Override
                            public void handleEvent(Event evt) {
                                Desktop d;
                                EventTarget target = evt.getCurrentTarget();
                                HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)target);
                                String href = anchorElement.getHref();
                                if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                                    try {
                                        d.browse(new URI(href));
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    catch (URISyntaxException e) {
                                        e.printStackTrace();
                                    }
                                }
                                evt.preventDefault();
                            }
                        }, false);
                        ++i;
                    }
                }
            }
        });
        BorderPane pane = new BorderPane();
        pane.setCenter((Node)view);
        Scene scene = new Scene((Parent)pane, 640.0, 400.0);
        this.setScene(scene);
        KeyCodeCombination kc = new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        Runnable task = () -> {
            if (this.isShowing()) {
                this.getScene().getWindow().hide();
            }
        };
        scene.getAccelerators().put((Object)kc, (Object)task);
    }

    protected abstract String parse(JstacsTool var1);

    protected abstract String getTitle(JstacsTool var1);
}

