/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.renderers.parameters;

import de.jstacs.fx.Application;
import de.jstacs.fx.renderers.parameters.AbstractParameterRenderer;
import de.jstacs.fx.renderers.parameters.FileParameterRenderer;
import de.jstacs.fx.renderers.parameters.ParameterRendererLibrary;
import de.jstacs.fx.renderers.results.TextResultRenderer;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.tools.DataColumnParameter;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;

public class DataColumnParameterRenderer
extends AbstractParameterRenderer<DataColumnParameter> {
    private HashMap<DataColumnParameter, FileParameter> cache = new HashMap();

    public static void register() {
        ParameterRendererLibrary.register(DataColumnParameter.class, new DataColumnParameterRenderer());
    }

    private DataColumnParameterRenderer() {
    }

    @Override
    protected void addInputs(final DataColumnParameter parameter, Pane parent, Label name, Node comment, final Label error, final Application.ToolReady ready) {
        if (!this.cache.containsKey(parameter)) {
            this.updateCache(parameter);
        }
        ObservableList options = FXCollections.observableArrayList();
        final ChoiceBox cb = new ChoiceBox();
        parent.getChildren().add((Object)cb);
        cb.setItems(options);
        this.update((ChoiceBox<String>)cb, parameter);
        cb.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    try {
                        parameter.setValue(newValue.intValue() + 1);
                    }
                    catch (SimpleParameter.IllegalValueException e) {
                        e.printStackTrace();
                        ready.testReady();
                        error.setText(parameter.getErrorMessage());
                    }
                }
                finally {
                    ready.testReady();
                    error.setText(parameter.getErrorMessage());
                }
            }
        });
        ChoiceBox box = FileParameterRenderer.getBox(this.cache.get(parameter));
        box.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                DataColumnParameterRenderer.this.update((ChoiceBox<String>)cb, parameter);
            }
        });
    }

    private void update(ChoiceBox<String> box, DataColumnParameter parameter) {
        FileParameter cols = this.cache.get(parameter);
        if (cols.getFileContents() != null) {
            Object[] opts;
            Integer val = (Integer)parameter.getValue();
            int index = box.getSelectionModel().getSelectedIndex();
            if (val != null) {
                index = val - 1;
            }
            if ((opts = TextResultRenderer.getHeader(cols.getFileContents()))[0] == null) {
                int i = 0;
                while (i < opts.length) {
                    opts[i] = "Column " + (i + 1);
                    ++i;
                }
            }
            box.getItems().setAll(opts);
            if (index >= 0 && index < box.getItems().size()) {
                box.getSelectionModel().select(index);
            }
        } else {
            box.getItems().clear();
        }
    }

    private void updateCache(DataColumnParameter parameter) {
        ParameterSet top = parameter.getParent();
        FileParameter found = DataColumnParameter.find(top, parameter.getDataRef());
        if (found != null) {
            this.cache.put(parameter, found);
        }
    }
}

