/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.renderers.parameters;

import de.jstacs.fx.renderers.parameters.DataColumnParameterRenderer;
import de.jstacs.fx.renderers.parameters.FileParameterRenderer;
import de.jstacs.fx.renderers.parameters.ParameterRenderer;
import de.jstacs.fx.renderers.parameters.ParameterSetContainerRenderer;
import de.jstacs.fx.renderers.parameters.SelectionParameterRenderer;
import de.jstacs.fx.renderers.parameters.SimpleParameterRenderer;
import de.jstacs.parameters.Parameter;
import java.util.HashMap;
import java.util.Set;

public class ParameterRendererLibrary {
    private static HashMap<Class<? extends Parameter>, ParameterRenderer> map;

    static {
        FileParameterRenderer.register();
        SelectionParameterRenderer.register();
        SimpleParameterRenderer.register();
        DataColumnParameterRenderer.register();
        ParameterSetContainerRenderer.register();
    }

    public static <T extends Parameter> void register(Class<T> clazz, ParameterRenderer<T> renderer) {
        if (map == null) {
            map = new HashMap();
        }
        map.put(clazz, renderer);
    }

    public static <T extends Parameter> ParameterRenderer<T> getRenderer(T parameter) {
        ParameterRenderer ren = map.get(parameter.getClass());
        if (ren == null) {
            Set<Class<? extends Parameter>> clazzes = map.keySet();
            for (Class<? extends Parameter> clazz : clazzes) {
                if (!clazz.isAssignableFrom(parameter.getClass())) continue;
                return map.get(clazz);
            }
        }
        if (ren == null) {
            System.err.println("Did not find a renderer for " + parameter.getClass() + ". Custom renderers need to be registered by " + ParameterRendererLibrary.class.getName() + ".register().");
        }
        return ren;
    }
}

