/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.renderers.parameters;

import de.jstacs.fx.Application;
import de.jstacs.fx.renderers.parameters.ParameterRenderer;
import de.jstacs.fx.renderers.parameters.ParameterRendererLibrary;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.Separator;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public class ParameterSetRenderer {
    public Pane render(final ParameterSet parameters, final Application.ToolReady ready) {
        if (parameters.getNumberOfParameters() == 0) {
            return new VBox();
        }
        final VBox box = new VBox();
        box.getStyleClass().add((Object)"vbox");
        int i = 0;
        while (i < parameters.getNumberOfParameters()) {
            VBox temp = new VBox();
            Parameter par = parameters.getParameterAt(i);
            ParameterRenderer<Parameter> renderer = ParameterRendererLibrary.getRenderer(par);
            renderer.render(par, (Pane)temp, ready);
            temp.getChildren().add((Object)new Separator());
            box.getChildren().add((Object)temp);
            ++i;
        }
        if (parameters instanceof ExpandableParameterSet) {
            final HBox hbox = new HBox();
            Button plus = new Button("+");
            final Button minus = new Button("-");
            if (parameters.getNumberOfParameters() == 0) {
                minus.setDisable(true);
            }
            hbox.getChildren().add((Object)minus);
            hbox.getChildren().add((Object)plus);
            hbox.setSpacing(20.0);
            box.getChildren().add((Object)hbox);
            plus.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    try {
                        ((ExpandableParameterSet)parameters).addParameterToSet();
                        Parameter added = ((ExpandableParameterSet)parameters).getParameterAt(((ExpandableParameterSet)parameters).getNumberOfParameters() - 1);
                        ParameterRenderer<Parameter> renderer = ParameterRendererLibrary.getRenderer(added);
                        box.getChildren().remove(box.getChildren().size() - 1);
                        VBox temp = new VBox();
                        renderer.render(added, (Pane)temp, ready);
                        temp.getChildren().add((Object)new Separator());
                        box.getChildren().add((Object)temp);
                        box.getChildren().add((Object)hbox);
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                    if (parameters.getNumberOfParameters() > 0) {
                        minus.setDisable(false);
                    }
                }
            });
            minus.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    ((ExpandableParameterSet)parameters).removeParameterFromSet();
                    box.getChildren().remove(box.getChildren().size() - 2);
                    minus.setDisable(parameters.getNumberOfParameters() == 0);
                }
            });
        }
        return box;
    }
}

