/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.renderers.parameters;

import de.jstacs.DataType;
import de.jstacs.fx.Application;
import de.jstacs.fx.renderers.parameters.AbstractParameterRenderer;
import de.jstacs.fx.renderers.parameters.ParameterRendererLibrary;
import de.jstacs.fx.renderers.parameters.ParameterSetRenderer;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;

public class SelectionParameterRenderer
extends AbstractParameterRenderer<SelectionParameter> {
    public static void register() {
        ParameterRendererLibrary.register(SelectionParameter.class, new SelectionParameterRenderer());
    }

    private SelectionParameterRenderer() {
    }

    @Override
    protected void addInputs(final SelectionParameter parameter, Pane parent, Label name, Node comment, final Label error, final Application.ToolReady ready) {
        Pane pane;
        ParameterSetRenderer renderer;
        ParameterSet ps = parameter.getParametersInCollection();
        Object[] names = new String[ps.getNumberOfParameters()];
        int i = 0;
        while (i < names.length) {
            names[i] = ps.getParameterAt(i).getName();
            ++i;
        }
        ChoiceBox cb = new ChoiceBox();
        cb.setItems(FXCollections.observableArrayList((Object[])names));
        cb.getSelectionModel().select(parameter.getSelected());
        parent.getChildren().add((Object)cb);
        if (parameter.getDatatype() == DataType.PARAMETERSET) {
            renderer = new ParameterSetRenderer();
            pane = renderer.render((ParameterSet)parameter.getValue(), ready);
            parent.getChildren().add((Object)pane);
        } else {
            pane = null;
            renderer = null;
        }
        cb.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>((String[])names, renderer, pane){
            private final /* synthetic */ String[] val$names;
            private final /* synthetic */ ParameterSetRenderer val$renderer;
            private final /* synthetic */ Pane val$pane;
            {
                this.val$names = stringArray;
                this.val$renderer = parameterSetRenderer;
                this.val$pane = pane;
            }

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    try {
                        parameter.setValue(this.val$names[(Integer)newValue]);
                        if (parameter.getDatatype() == DataType.PARAMETERSET) {
                            Pane temp = this.val$renderer.render((ParameterSet)parameter.getValue(), ready);
                            this.val$pane.getChildren().clear();
                            this.val$pane.getChildren().addAll((Collection)temp.getChildren());
                            this.val$pane.getStyleClass().clear();
                            this.val$pane.getStyleClass().addAll((Collection)temp.getStyleClass());
                        }
                    }
                    catch (SimpleParameter.IllegalValueException e) {
                        e.printStackTrace();
                        ready.testReady();
                        error.setText(parameter.getErrorMessage());
                    }
                }
                finally {
                    ready.testReady();
                    error.setText(parameter.getErrorMessage());
                }
            }
        });
    }
}

