/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.renderers.results;

import de.jstacs.fx.renderers.results.ResultRenderer;
import de.jstacs.fx.renderers.results.ResultRendererLibrary;
import de.jstacs.parameters.FileParameter;
import de.jstacs.results.TextResult;
import de.jstacs.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.util.Callback;

public class TextResultRenderer
implements ResultRenderer<TextResult> {
    private LinkedList<Pair<TextResult, Node>> nodeCache = new LinkedList();

    public static void register() {
        ResultRendererLibrary.register(TextResult.class, new TextResultRenderer());
    }

    private TextResultRenderer() {
    }

    private Node getFromCache(TextResult tr) {
        for (Pair pair : this.nodeCache) {
            if (pair.getFirstElement() != tr) continue;
            return (Node)pair.getSecondElement();
        }
        return null;
    }

    private void addToCache(TextResult tr, Node node) {
        if (this.nodeCache.size() > 5) {
            this.nodeCache.removeFirst();
        }
        this.nodeCache.addLast(new Pair<TextResult, Node>(tr, node));
    }

    public static String[] getHeader(FileParameter.FileRepresentation rep) {
        String head = rep.getContent();
        int end = head.indexOf("\n");
        if (end < 0) {
            end = head.length();
        }
        head = head.substring(0, end);
        String[] parts = head.split("\t");
        boolean parsable = false;
        int i = 0;
        while (i < parts.length) {
            if (parts[i].trim().length() > 0) {
                try {
                    Double.parseDouble(parts[i]);
                    parsable = true;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        String[] opts = null;
        opts = !parsable ? parts : new String[parts.length];
        return opts;
    }

    @Override
    public Node render(TextResult result, Pane parent) {
        if (TextResult.equals(result.getMime(), "xml") || "gz".equalsIgnoreCase(result.getValue().getExtension()) || (double)result.getValue().getFilesize() > 2.0E7) {
            return null;
        }
        Node cached = this.getFromCache(result);
        if (cached != null) {
            return cached;
        }
        if (TextResult.equals(result.getMime(), "bed,gff,gff3,tsv,csv,narrowPeak")) {
            String cont;
            String[] lines;
            String sep = "\t";
            if ("csv".equalsIgnoreCase(result.getValue().getExtension())) {
                sep = ",";
            }
            String[] head = TextResultRenderer.getHeader(result.getValue());
            boolean hasHeader = true;
            if (head[0] == null) {
                int i = 0;
                while (i < head.length) {
                    head[i] = "Column " + (i + 1);
                    ++i;
                }
                hasHeader = false;
            }
            if ((lines = (cont = result.getValue().getContent()).split("\n")).length > 0) {
                int i = 0;
                if (hasHeader) {
                    i = 1;
                }
                Object[][] content = new Object[lines.length - i][];
                Class[] types = new Class[head.length];
                int j = 0;
                while (j < content.length) {
                    String[] parts = lines[j + i].split(sep);
                    content[j] = new Object[parts.length];
                    int k = 0;
                    while (k < parts.length) {
                        try {
                            Integer.parseInt(parts[k]);
                            if (types[k] == null || types[k].equals(Integer.class)) {
                                types[k] = Integer.class;
                            }
                        }
                        catch (NumberFormatException e) {
                            try {
                                Double.parseDouble(parts[k]);
                                if (types[k] == null || types[k].equals(Integer.class) || types[k].equals(Double.class)) {
                                    types[k] = Double.class;
                                }
                            }
                            catch (NumberFormatException ex) {
                                types[k] = String.class;
                            }
                        }
                        content[j][k] = parts[k];
                        ++k;
                    }
                    ++j;
                }
                j = 0;
                while (j < content.length) {
                    int k = 0;
                    while (k < content[j].length) {
                        if (types[k].equals(Integer.class)) {
                            content[j][k] = Integer.parseInt((String)content[j][k]);
                        } else if (types[k].equals(Double.class)) {
                            content[j][k] = Double.parseDouble((String)content[j][k]);
                        }
                        ++k;
                    }
                    ++j;
                }
                Object[] cols = new TableColumn[head.length];
                int j2 = 0;
                while (j2 < head.length) {
                    final int col = j2;
                    if (types[j2] != null && Number.class.isAssignableFrom(types[j2])) {
                        TableColumn numCol = new TableColumn(head[j2]);
                        numCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Object[], Number>, ObservableValue<Number>>(){

                            public ObservableValue<Number> call(TableColumn.CellDataFeatures<Object[], Number> arg0) {
                                return new ReadOnlyObjectWrapper((Object)((Number)((Object[])arg0.getValue())[col]));
                            }
                        });
                        cols[j2] = numCol;
                    } else {
                        TableColumn strCol = new TableColumn(head[j2]);
                        strCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Object[], String>, ObservableValue<String>>(){

                            public ObservableValue<String> call(TableColumn.CellDataFeatures<Object[], String> arg0) {
                                return new ReadOnlyStringWrapper(((Object[])arg0.getValue())[col].toString());
                            }
                        });
                        cols[j2] = strCol;
                    }
                    ++j2;
                }
                final TableView tv = new TableView();
                tv.getColumns().addAll(cols);
                tv.setItems(FXCollections.observableArrayList((Object[])content));
                tv.getSelectionModel().selectionModeProperty().set((Object)SelectionMode.MULTIPLE);
                tv.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent event) {
                        KeyCodeCombination copyKeyCodeCombination = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY});
                        if (copyKeyCodeCombination.match(event)) {
                            ObservableList sel = tv.getSelectionModel().getSelectedIndices();
                            HashSet set = new HashSet(sel);
                            ArrayList sorted = new ArrayList(set);
                            Collections.sort(sorted);
                            StringBuffer sb = new StringBuffer();
                            int i = 0;
                            while (i < sorted.size()) {
                                Object[] items = (Object[])tv.getItems().get(((Integer)sorted.get(i)).intValue());
                                int j = 0;
                                while (j < items.length) {
                                    sb.append(items[j]);
                                    if (j < items.length - 1) {
                                        sb.append("\t");
                                    }
                                    ++j;
                                }
                                sb.append("\n");
                                ++i;
                            }
                            ClipboardContent clipboardContent = new ClipboardContent();
                            clipboardContent.putString(sb.toString());
                            Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
                        }
                    }
                });
                this.addToCache(result, (Node)tv);
                return tv;
            }
        }
        final ListView lv = new ListView();
        ObservableList items = FXCollections.observableArrayList((Object[])result.getValue().getContent().split("\n"));
        lv.setItems(items);
        lv.getSelectionModel().selectionModeProperty().set((Object)SelectionMode.MULTIPLE);
        lv.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCodeCombination copyKeyCodeCombination = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY});
                if (copyKeyCodeCombination.match(event)) {
                    ObservableList sel = lv.getSelectionModel().getSelectedIndices();
                    HashSet set = new HashSet(sel);
                    ArrayList sorted = new ArrayList(set);
                    Collections.sort(sorted);
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    while (i < sorted.size()) {
                        sb.append((String)lv.getItems().get(((Integer)sorted.get(i)).intValue()));
                        sb.append("\n");
                        ++i;
                    }
                    ClipboardContent clipboardContent = new ClipboardContent();
                    clipboardContent.putString(sb.toString());
                    Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
                }
            }
        });
        this.addToCache(result, (Node)lv);
        return lv;
    }
}

