/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.repository;

import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.TextResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import de.jstacs.utils.Compression;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ResultRepository {
    public static BooleanProperty autosave = new SimpleBooleanProperty(false);
    public static StringProperty autodir = new SimpleStringProperty(null);
    private static ResultRepository instance;
    private LinkedList<Result> results = new LinkedList();
    private ArrayList<ResultConsumer> consumers = new ArrayList();

    public static ResultRepository getInstance() {
        if (instance == null) {
            instance = new ResultRepository();
        }
        return instance;
    }

    private ResultRepository() {
        File f;
        if (autosave.get() && (f = new File((String)autodir.get())).exists()) {
            try {
                StringBuffer sb = FileManager.readFile(f);
                sb = new StringBuffer(Compression.unzip(sb.toString()));
                this.restoreResultsFromXML(sb);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void notifyAdd(Result result) {
        int i = 0;
        while (i < this.consumers.size()) {
            this.consumers.get(i).notifyAdded(result);
            ++i;
        }
    }

    public void notifyRefresh(Result renamed) {
        int i = 0;
        while (i < this.consumers.size()) {
            this.consumers.get(i).notifyRefresh(renamed);
            ++i;
        }
    }

    public void add(Result result) {
        this.add(result, true);
    }

    public void add(Result result, boolean store) {
        this.results.add(result);
        this.notifyAdd(result);
        if (store) {
            this.autostore();
        }
    }

    public boolean autostore() {
        if (autosave.get()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileManager.writeFile((String)autodir.get(), (CharSequence)Compression.zip(ResultRepository.this.storeResultsToXML().toString()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            return true;
        }
        return false;
    }

    private void notifyRemove(Result result) {
        int i = 0;
        while (i < this.consumers.size()) {
            this.consumers.get(i).notifyRemoved(result);
            ++i;
        }
    }

    public boolean remove(Result result) {
        boolean b = this.results.remove(result);
        if (b) {
            this.notifyRemove(result);
            this.autostore();
        }
        return b;
    }

    public List<Result> getAllResults() {
        List<Result> res = this.getResults();
        int i = 0;
        while (i < this.results.size()) {
            Result temp = this.results.get(i);
            if (temp instanceof ResultSetResult) {
                Result[] temp2 = ((ResultSetResult)temp).getRawResult()[0].getResults();
                this.addAllResults(res, temp2);
            }
            ++i;
        }
        return res;
    }

    private void addAllResults(List<Result> res, Result[] add) {
        int i = 0;
        while (i < add.length) {
            res.add(add[i]);
            if (add[i] instanceof ResultSetResult) {
                Result[] temp2 = ((ResultSetResult)add[i]).getRawResult()[0].getResults();
                this.addAllResults(res, temp2);
            }
            ++i;
        }
    }

    public List<Result> getResults() {
        return new ArrayList<Result>(this.results);
    }

    public List<Result> filterByMimeAndExtendedType(String mime, String extendedType) {
        ArrayList<Result> filtered = new ArrayList<Result>();
        for (Result r : this.getAllResults()) {
            String[] exts;
            if (r instanceof TextResult) {
                if (mime != null && !TextResult.equals(mime, ((TextResult)r).getMime()) || extendedType != null && ((TextResult)r).getExtendedType() != null && !TextResult.equals(extendedType, ((TextResult)r).getExtendedType())) continue;
                filtered.add(r);
                continue;
            }
            ResultSaver<?> saver = ResultSaverLibrary.getSaver(r.getClass());
            if (saver == null || !TextResult.equals(exts = saver.getFileExtensions(r), mime)) continue;
            filtered.add(r);
        }
        return filtered;
    }

    public void register(ResultConsumer resultConsumer) {
        this.consumers.add(resultConsumer);
    }

    public ArrayList<ResultConsumer> getConsumers() {
        return this.consumers;
    }

    public void restoreResultsFromXML(StringBuffer sb) throws NonParsableException {
        Result[] temp = (Result[])XMLParser.extractObjectForTags(sb, "results");
        int i = 0;
        while (i < temp.length) {
            this.add(temp[i], false);
            ++i;
        }
    }

    public StringBuffer storeResultsToXML() {
        StringBuffer sb = new StringBuffer();
        Result[] temp = this.results.toArray(new Result[0]);
        XMLParser.appendObjectWithTags(sb, temp, "results");
        return sb;
    }

    public static interface ResultConsumer {
        public void notifyAdded(Result var1);

        public void notifyRemoved(Result var1);

        public void notifyRefresh(Result var1);
    }
}

