/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.repository;

import de.jstacs.fx.Application;
import de.jstacs.fx.LoadSaveDialogs;
import de.jstacs.fx.renderers.results.ResultRenderer;
import de.jstacs.fx.renderers.results.ResultRendererLibrary;
import de.jstacs.fx.repository.ResultRepository;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.SimpleResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import de.jstacs.tools.ToolResult;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.util.Callback;

public class ResultRepositoryRenderer
implements ResultRepository.ResultConsumer {
    private Control c;
    private TreeItem<Result> root;
    private HashMap<Result, TreeItem<Result>> itemMap = new HashMap();
    private TreeTableView<Result> ttv;
    private BorderPane viewerPane;
    private Application app;

    public ResultRepositoryRenderer(BorderPane viewerPane, Application app) {
        this.c = this.renderRepository();
        ResultRepository.getInstance().register(this);
        this.viewerPane = viewerPane;
        this.app = app;
    }

    public Control getControl() {
        return this.c;
    }

    public void addListener(ListChangeListener listener) {
        this.root.getChildren().addListener(listener);
    }

    private Control renderRepository() {
        TreeTableColumn nameColumn = new TreeTableColumn("Name");
        nameColumn.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Result, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<Result, String> arg0) {
                SimpleObjectProperty prop = new SimpleObjectProperty((Object)((Result)arg0.getValue().getValue()).getName());
                return prop;
            }
        });
        Callback cellFactory = p -> new TreeTableCell<Result, String>(){
            private TextField textField;

            public void startEdit() {
                if (!this.isEmpty()) {
                    super.startEdit();
                    this.createTextField();
                    this.setText(null);
                    this.setGraphic((Node)this.textField);
                    this.textField.selectAll();
                }
            }

            public void cancelEdit() {
                super.cancelEdit();
                this.setGraphic(null);
                this.setText((String)this.getItem());
            }

            public void updateItem(String item, boolean empty) {
                String comment;
                super.updateItem((Object)item, empty);
                if (this.getTreeTableRow().getItem() != null && (comment = ((Result)this.getTreeTableRow().getItem()).getComment()) != null && comment.length() > 0) {
                    Tooltip tt = new Tooltip(comment);
                    tt.setPrefWidth(300.0);
                    tt.setWrapText(true);
                    Tooltip.install((Node)this, (Tooltip)tt);
                }
                if (empty) {
                    this.setGraphic(null);
                    this.setText((String)this.getItem());
                } else if (this.isEditing()) {
                    if (this.textField != null) {
                        this.textField.setText(this.getString());
                    }
                    this.setText(null);
                    this.setGraphic((Node)this.textField);
                } else {
                    this.setGraphic(null);
                    this.setText((String)this.getItem());
                }
            }

            private void createTextField() {
                this.textField = new TextField(this.getString());
                this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
                this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        this.commitEdit(textField.getText());
                    }
                });
            }

            private String getString() {
                return this.getItem() == null ? "" : (String)this.getItem();
            }
        };
        nameColumn.setCellFactory(cellFactory);
        nameColumn.setOnEditCommit((EventHandler)new EventHandler<TreeTableColumn.CellEditEvent<Result, String>>(){

            public void handle(TreeTableColumn.CellEditEvent<Result, String> event) {
                ((Result)event.getRowValue().getValue()).rename((String)event.getNewValue());
                ResultRepository.getInstance().notifyRefresh((Result)event.getRowValue().getValue());
            }
        });
        nameColumn.setEditable(true);
        TreeTableColumn valueColumn = new TreeTableColumn("Value");
        valueColumn.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Result, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<Result, String> arg0) {
                if (arg0.getValue().getValue() instanceof SimpleResult) {
                    return new ReadOnlyStringWrapper(((Result)arg0.getValue().getValue()).getValue().toString());
                }
                return new ReadOnlyStringWrapper(((Result)arg0.getValue().getValue()).getDatatype().toString());
            }
        });
        TreeTableColumn dateCol = new TreeTableColumn("Date");
        dateCol.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Result, Date>, ObservableValue<Date>>(){

            public ObservableValue<Date> call(TreeTableColumn.CellDataFeatures<Result, Date> arg0) {
                if (arg0.getValue().getValue() instanceof ToolResult) {
                    return new ReadOnlyObjectWrapper((Object)((ToolResult)arg0.getValue().getValue()).getFinishedDate());
                }
                return null;
            }
        });
        TreeTableColumn saveColumn = new TreeTableColumn("Save");
        saveColumn.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Result, Button>, ObservableValue<Button>>(){

            public ObservableValue<Button> call(TreeTableColumn.CellDataFeatures<Result, Button> arg0) {
                final Result res = (Result)arg0.getValue().getValue();
                final ResultSaver<?> saver = ResultSaverLibrary.getSaver(res.getClass());
                if (saver != null) {
                    String label = "Save...";
                    if (!saver.isAtomic()) {
                        label = "Save all...";
                    }
                    Button btn = new Button(label);
                    btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent arg1) {
                            if (saver.isAtomic()) {
                                Object[] ft = saver.getFileExtensions(res);
                                String filename = String.valueOf(res.getName().replaceAll("[\\s\\:\\/]", "_")) + (ft != null && ft.length > 0 ? "." + ft[0] : "");
                                int i = 0;
                                while (i < ft.length) {
                                    ft[i] = "*." + (String)ft[i];
                                    ++i;
                                }
                                String name = Arrays.toString(ft).replaceAll("(\\[|\\])", "").toUpperCase();
                                File f = LoadSaveDialogs.showSaveDialog(Application.mainWindow, filename, name, (String[])ft);
                                if (f == null) {
                                    return;
                                }
                                saver.writeOutput(res, f);
                            } else {
                                File directory = LoadSaveDialogs.showDirectoryDialog(Application.mainWindow);
                                if (directory == null) {
                                    return;
                                }
                                saver.writeOutput(res, directory);
                            }
                        }
                    });
                    return new ReadOnlyObjectWrapper((Object)btn);
                }
                return null;
            }
        });
        TreeTableColumn removeColumn = new TreeTableColumn("Remove");
        removeColumn.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Result, Button>, ObservableValue<Button>>(){

            public ObservableValue<Button> call(final TreeTableColumn.CellDataFeatures<Result, Button> arg0) {
                if (arg0.getValue().getParent() == ResultRepositoryRenderer.this.root) {
                    Button btn = new Button("Remove");
                    btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent arg1) {
                            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                            alert.setWidth(300.0);
                            alert.setTitle("Remove \"" + ((Result)arg0.getValue().getValue()).getName() + "\"");
                            alert.setHeaderText("Do you really want to remove \n\"" + ((Result)arg0.getValue().getValue()).getName() + "\"\n from your workspace?");
                            alert.setContentText("This cannot be undone.");
                            ButtonType cancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
                            ButtonType ok = new ButtonType("Remove", ButtonBar.ButtonData.OK_DONE);
                            alert.getButtonTypes().setAll((Object[])new ButtonType[]{cancel, ok});
                            Optional result = alert.showAndWait();
                            if (result.get() == ok) {
                                ResultRepository.getInstance().remove((Result)arg0.getValue().getValue());
                            }
                        }
                    });
                    return new ReadOnlyObjectWrapper((Object)btn);
                }
                return null;
            }
        });
        TreeTableColumn restartColumn = new TreeTableColumn("Parameters");
        restartColumn.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Result, Button>, ObservableValue<Button>>(){

            public ObservableValue<Button> call(final TreeTableColumn.CellDataFeatures<Result, Button> arg0) {
                if (arg0.getValue().getParent() == ResultRepositoryRenderer.this.root && arg0.getValue().getValue() instanceof ToolResult) {
                    Button btn = new Button("Restore");
                    btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent arg1) {
                            ResultRepositoryRenderer.this.app.setParametersFromCopy((ToolResult)arg0.getValue().getValue());
                        }
                    });
                    return new ReadOnlyObjectWrapper((Object)btn);
                }
                return null;
            }
        });
        this.root = new TreeItem((Object)new CategoricalResult("Root", "", ""));
        List<Result> list = ResultRepository.getInstance().getResults();
        this.ttv = new TreeTableView();
        this.ttv.setShowRoot(false);
        this.ttv.getColumns().setAll((Object[])new TreeTableColumn[]{nameColumn, valueColumn, dateCol, saveColumn, removeColumn, restartColumn});
        nameColumn.setPrefWidth(200.0);
        saveColumn.setPrefWidth(100.0);
        removeColumn.setPrefWidth(100.0);
        restartColumn.setPrefWidth(100.0);
        dateCol.setPrefWidth(200.0);
        this.addResults(this.root, list);
        this.ttv.setRoot(this.root);
        this.ttv.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<Result>>(){

            public void changed(ObservableValue<? extends TreeItem<Result>> arg0, TreeItem<Result> arg1, TreeItem<Result> arg2) {
                if (arg2 != null) {
                    Result res = (Result)arg2.getValue();
                    ResultRenderer<Result> renderer = ResultRendererLibrary.getRenderer(res);
                    if (renderer != null) {
                        Node node = renderer.render(res, (Pane)ResultRepositoryRenderer.this.viewerPane);
                        ResultRepositoryRenderer.this.viewerPane.setCenter(node);
                    } else {
                        ResultRepositoryRenderer.this.viewerPane.setCenter(null);
                    }
                }
            }
        });
        this.ttv.setEditable(true);
        return this.ttv;
    }

    public void addResult(Result res) {
        this.addResult(res, this.root);
    }

    private void addResult(Result res, TreeItem<Result> root) {
        if (res instanceof ResultSetResult) {
            TreeItem parent = new TreeItem((Object)res);
            this.itemMap.put(res, (TreeItem<Result>)parent);
            root.getChildren().add((Object)parent);
            ResultSet rs = ((ResultSetResult)res).getRawResult()[0];
            int i = 0;
            while (i < rs.getNumberOfResults()) {
                this.addResult(rs.getResultAt(i), (TreeItem<Result>)parent);
                ++i;
            }
        } else {
            TreeItem item = new TreeItem((Object)res);
            this.itemMap.put(res, (TreeItem<Result>)item);
            root.getChildren().add((Object)item);
        }
        this.ttv.getSelectionModel().clearSelection();
    }

    public boolean removeResult(Result res) {
        return this.removeResult(res, this.root);
    }

    private boolean removeResult(Result res, TreeItem<Result> root) {
        boolean b = root.getChildren().remove(this.itemMap.get(res));
        if (b) {
            this.itemMap.remove(res);
            this.ttv.getSelectionModel().clearSelection();
            return b;
        }
        for (TreeItem item : root.getChildren()) {
            Result r = (Result)item.getValue();
            if (r instanceof ResultSetResult) {
                b = this.removeResult(res, (TreeItem<Result>)item);
            }
            if (!b) continue;
            return true;
        }
        return false;
    }

    private void addResults(TreeItem<Result> root, List<Result> list) {
        int i = 0;
        while (i < list.size()) {
            Result res = list.get(i);
            this.addResult(res, root);
            ++i;
        }
    }

    @Override
    public void notifyAdded(Result added) {
        this.addResult(added);
    }

    @Override
    public void notifyRemoved(Result removed) {
        this.removeResult(removed);
    }

    @Override
    public void notifyRefresh(Result renamed) {
    }
}

