/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results.savers;

import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import de.jstacs.utils.graphics.PDFAdaptor;
import de.jstacs.utils.graphics.RasterizedAdaptor;
import java.io.File;

public class PlotGeneratorResultSaver
implements ResultSaver<PlotGeneratorResult> {
    public static void register() {
        ResultSaverLibrary.register(PlotGeneratorResult.class, new PlotGeneratorResultSaver());
    }

    private PlotGeneratorResultSaver() {
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public String[] getFileExtensions(PlotGeneratorResult result) {
        if (result.getFormat() == Format.PDF) {
            return new String[]{"pdf"};
        }
        return new String[]{"png"};
    }

    @Override
    public boolean writeOutput(PlotGeneratorResult result, File path) {
        GraphicsAdaptor ga = null;
        ga = result.getFormat() == Format.PDF ? new PDFAdaptor() : new RasterizedAdaptor("png");
        try {
            result.getValue().generatePlot(ga);
            ga.generateOutput(path);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    @Deprecated
    public boolean writeOutput(PlotGeneratorResult result, StringBuffer buf) {
        throw new RuntimeException("Impossible for images.");
    }

    public static enum Format {
        PDF,
        PNG;

    }
}

