/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable;

import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.BayesianNetworkTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.FSDAGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.StructureLearner;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.BayesianNetworkTrainSMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.FSDAGModelForGibbsSamplingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.AbstractMixtureTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.MixtureTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.StrandTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.motif.ZOOPSTrainSM;

public class TrainableStatisticalModelFactory {
    public static FSDAGTrainSM createPWM(AlphabetContainer con, int length, double ess) throws Exception {
        FSDAGModelForGibbsSamplingParameterSet ps = new FSDAGModelForGibbsSamplingParameterSet(con, length, ess, "PWM", "");
        return (FSDAGTrainSM)ps.getInstance();
    }

    private static BayesianNetworkTrainSM createBN(AlphabetContainer con, int length, double ess, StructureLearner.ModelType type, byte order) throws Exception {
        BayesianNetworkTrainSMParameterSet ps = new BayesianNetworkTrainSMParameterSet(con, length, ess, null, type, order, StructureLearner.LearningType.ML_OR_MAP);
        return (BayesianNetworkTrainSM)ps.getInstance();
    }

    public static FSDAGTrainSM createInhomogeneousMarkovModel(AlphabetContainer con, int length, double ess, byte order) throws Exception {
        String graph = "";
        if (order < 0) {
            throw new IllegalArgumentException("The order has to be positive");
        }
        if (order > 0) {
            int l = 0;
            while (l < length) {
                graph = String.valueOf(graph) + "<parents node=\"" + l + "\">";
                int p = Math.max(0, l - order);
                while (p < l) {
                    graph = String.valueOf(graph) + p + (p + 1 < l ? "," : "");
                    ++p;
                }
                graph = String.valueOf(graph) + "</parents>";
                ++l;
            }
        }
        FSDAGModelForGibbsSamplingParameterSet ps = new FSDAGModelForGibbsSamplingParameterSet(con, length, ess, "IMM" + order, graph);
        return (FSDAGTrainSM)ps.getInstance();
    }

    public static BayesianNetworkTrainSM createPermutedMarkovModel(AlphabetContainer con, int length, double ess, byte order) throws Exception {
        return TrainableStatisticalModelFactory.createBN(con, length, ess, StructureLearner.ModelType.PMM, order);
    }

    public static BayesianNetworkTrainSM createBayesianNetworkModel(AlphabetContainer con, int length, double ess, byte order) throws Exception {
        return TrainableStatisticalModelFactory.createBN(con, length, ess, StructureLearner.ModelType.BN, order);
    }

    public static HomogeneousMM createHomogeneousMarkovModel(AlphabetContainer con, double ess, byte order) throws Exception {
        HomMMParameterSet ps = new HomMMParameterSet(con, ess, null, order);
        return (HomogeneousMM)ps.getInstance();
    }

    public static StrandTrainSM createStrandModel(TrainableStatisticalModel model) throws Exception {
        return new StrandTrainSM(model, 10, 0.5, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureTrainSM.Parameterization.LAMBDA);
    }

    public static MixtureTrainSM createMixtureModel(double[] hyper, TrainableStatisticalModel[] model) throws Exception {
        int i = 0;
        while (i < model.length && model[i].getLength() == 0) {
            ++i;
        }
        return new MixtureTrainSM(i == model.length ? 0 : model[i].getLength(), model, 10, hyper, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureTrainSM.Parameterization.LAMBDA);
    }

    public static ZOOPSTrainSM createZOOPS(TrainableStatisticalModel motif, TrainableStatisticalModel bg, double[] hyper, boolean trainOnlyMotifModel) throws Exception {
        return new ZOOPSTrainSM(motif, bg, trainOnlyMotifModel, 10, hyper, null, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureTrainSM.Parameterization.LAMBDA);
    }
}

