/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RFileInputStream;
import org.rosuda.REngine.Rserve.RFileOutputStream;

public class RUtils {
    public static void installRScript(String sourcePath, String targetName, RConnection rconnection) throws Exception {
        RUtils.copyFileToServer(sourcePath, targetName, rconnection);
        rconnection.voidEval("source(\"" + targetName + "\")");
    }

    public static void copyFileToServer(File source, String targetName, RConnection rconnection) throws Exception {
        if (!source.exists()) {
            throw new IOException("\"" + source.getAbsolutePath() + "\" does not exit.");
        }
        if (!source.isFile()) {
            throw new IOException("The source has o be a file.");
        }
        if (!source.canRead()) {
            throw new IOException("Can't read the source file.");
        }
        RFileOutputStream os = rconnection.createFile(targetName);
        PrintStream ps = new PrintStream(os);
        FileInputStream fileInputStream = new FileInputStream(source);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String line = bufferedReader.readLine();
        if (line != null) {
            while (line != null) {
                ps.println(line);
                line = bufferedReader.readLine();
            }
        }
        bufferedReader.close();
        fileInputStream.close();
        ps.close();
    }

    public static void copyFileToServer(String sourcePath, String targetName, RConnection rconnection) throws Exception {
        RUtils.copyFileToServer(new File(sourcePath), targetName, rconnection);
    }

    public static int copyFileFromServer(String sourcePath, String targetPath, RConnection c) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetPath));
        int code = RUtils.copyFileFromServer(sourcePath, out, c);
        out.close();
        return code;
    }

    public static int copyFileFromServer(String sourcePath, OutputStream out, RConnection c) throws IOException {
        int n;
        RFileInputStream is = c.openFile(sourcePath);
        int bufSize = 65536;
        int code = 0;
        byte[] buf = new byte[bufSize];
        while ((n = is.read(buf)) > -1) {
            out.write(buf, 0, n);
            code += n;
        }
        return code;
    }

    public static RConnection openRConnection(String rServeHostName, String loginName, String passwd) throws Exception {
        RConnection c = new RConnection(rServeHostName);
        if (c.needLogin()) {
            c.login(loginName, passwd);
        }
        return c;
    }
}

