/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.graphics;

import de.jstacs.utils.graphics.GraphicsAdaptor;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;

public class EPSAdaptor
extends GraphicsAdaptor {
    protected EPSDocumentGraphics2D graphics = new EPSDocumentGraphics2D(true);
    protected ByteArrayOutputStream stream;

    public EPSAdaptor() {
        this.graphics.setGraphicContext(new GraphicContext());
    }

    @Override
    public Graphics2D getGraphics(int width, int height) throws IOException {
        this.stream = new ByteArrayOutputStream();
        this.graphics.setupDocument(this.stream, width, height);
        return this.graphics;
    }

    @Override
    public void generateOutput(File file) throws IOException {
        this.stream.flush();
        this.stream.close();
        FileOutputStream out = new FileOutputStream(file);
        out.write(this.stream.toByteArray());
        this.graphics.finish();
        out.close();
    }

    @Override
    public String getGraphicsExtension() {
        return "eps";
    }
}

