/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.ComparableSamRecordIterator;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.CloseableIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.PriorityQueue;

public class MergingSamRecordIterator
implements CloseableIterator<SAMRecord> {
    private final PriorityQueue<ComparableSamRecordIterator> pq;
    private final SamFileHeaderMerger samHeaderMerger;
    private final Collection<SamReader> readers;
    private final SAMFileHeader.SortOrder sortOrder;
    private final SAMRecordComparator comparator;
    private boolean initialized = false;

    public MergingSamRecordIterator(SamFileHeaderMerger headerMerger, boolean forcePresorted) {
        this(headerMerger, headerMerger.getReaders(), forcePresorted);
    }

    public MergingSamRecordIterator(SamFileHeaderMerger headerMerger, Collection<SamReader> readers, boolean assumeSorted) {
        this.samHeaderMerger = headerMerger;
        this.sortOrder = headerMerger.getMergedHeader().getSortOrder();
        this.comparator = this.getComparator();
        this.readers = readers;
        this.pq = new PriorityQueue(readers.size());
        for (SamReader reader : readers) {
            if (!this.samHeaderMerger.getHeaders().contains(reader.getFileHeader())) {
                throw new SAMException("All iterators to be merged must be accounted for in the SAM header merger");
            }
            if (assumeSorted || this.sortOrder == SAMFileHeader.SortOrder.unsorted || reader.getFileHeader().getSortOrder() == this.sortOrder) continue;
            throw new SAMException("Files are not compatible with sort order");
        }
    }

    public MergingSamRecordIterator(SamFileHeaderMerger headerMerger, Map<SamReader, CloseableIterator<SAMRecord>> iterators, boolean assumeSorted) {
        this(headerMerger, iterators.keySet(), assumeSorted);
        for (Map.Entry<SamReader, CloseableIterator<SAMRecord>> mapping : iterators.entrySet()) {
            this.addIfNotEmpty(new ComparableSamRecordIterator(mapping.getKey(), mapping.getValue(), this.comparator));
        }
        this.initialized = true;
    }

    private void startIterationIfRequired() {
        if (this.initialized) {
            return;
        }
        for (SamReader reader : this.readers) {
            this.addIfNotEmpty(new ComparableSamRecordIterator(reader, reader.iterator(), this.comparator));
        }
        this.initialized = true;
    }

    @Override
    public void close() {
        for (CloseableIterator closeableIterator : this.pq) {
            closeableIterator.close();
        }
    }

    @Override
    public boolean hasNext() {
        this.startIterationIfRequired();
        return !this.pq.isEmpty();
    }

    @Override
    public SAMRecord next() {
        String newGroupId;
        String oldGroupId;
        this.startIterationIfRequired();
        ComparableSamRecordIterator iterator = this.pq.poll();
        SAMRecord record = (SAMRecord)iterator.next();
        this.addIfNotEmpty(iterator);
        record.setHeader(this.samHeaderMerger.getMergedHeader());
        if (this.samHeaderMerger.hasReadGroupCollisions() && (oldGroupId = (String)record.getAttribute(ReservedTagConstants.READ_GROUP_ID)) != null) {
            newGroupId = this.samHeaderMerger.getReadGroupId(iterator.getReader().getFileHeader(), oldGroupId);
            record.setAttribute(ReservedTagConstants.READ_GROUP_ID, (Object)newGroupId);
        }
        if (this.samHeaderMerger.hasProgramGroupCollisions() && (oldGroupId = (String)record.getAttribute(ReservedTagConstants.PROGRAM_GROUP_ID)) != null) {
            newGroupId = this.samHeaderMerger.getProgramGroupId(iterator.getReader().getFileHeader(), oldGroupId);
            record.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)newGroupId);
        }
        return record;
    }

    private void addIfNotEmpty(ComparableSamRecordIterator iterator) {
        if (iterator.hasNext()) {
            this.pq.offer(iterator);
        } else {
            iterator.close();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("MergingSAMRecorderIterator.remove()");
    }

    private SAMRecordComparator getComparator() {
        if (this.sortOrder == SAMFileHeader.SortOrder.unsorted) {
            return new SAMRecordComparator(){

                @Override
                public int fileOrderCompare(SAMRecord lhs, SAMRecord rhs) {
                    return System.identityHashCode(lhs) - System.identityHashCode(rhs);
                }

                @Override
                public int compare(SAMRecord lhs, SAMRecord rhs) {
                    return this.fileOrderCompare(lhs, rhs);
                }
            };
        }
        if (this.samHeaderMerger.hasMergedSequenceDictionary() && this.sortOrder.equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            return new MergedSequenceDictionaryCoordinateOrderComparator();
        }
        return this.sortOrder.getComparatorInstance();
    }

    public SAMFileHeader getMergedHeader() {
        return this.samHeaderMerger.getMergedHeader();
    }

    private class MergedSequenceDictionaryCoordinateOrderComparator
    extends SAMRecordCoordinateComparator
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private MergedSequenceDictionaryCoordinateOrderComparator() {
        }

        @Override
        public int fileOrderCompare(SAMRecord samRecord1, SAMRecord samRecord2) {
            int referenceIndex2;
            int referenceIndex1 = this.getReferenceIndex(samRecord1);
            if (referenceIndex1 != (referenceIndex2 = this.getReferenceIndex(samRecord2))) {
                if (referenceIndex1 == -1) {
                    return 1;
                }
                if (referenceIndex2 == -1) {
                    return -1;
                }
                return referenceIndex1 - referenceIndex2;
            }
            if (referenceIndex1 == -1) {
                return 0;
            }
            return samRecord1.getAlignmentStart() - samRecord2.getAlignmentStart();
        }

        private int getReferenceIndex(SAMRecord samRecord) {
            if (samRecord.getReferenceIndex() != -1) {
                return MergingSamRecordIterator.this.samHeaderMerger.getMergedSequenceIndex(samRecord.getHeader(), samRecord.getReferenceIndex());
            }
            if (samRecord.getMateReferenceIndex() != -1) {
                return MergingSamRecordIterator.this.samHeaderMerger.getMergedSequenceIndex(samRecord.getHeader(), samRecord.getMateReferenceIndex());
            }
            return -1;
        }
    }
}

