/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import gov.nih.nlm.ncbi.ngs.NGS;
import gov.nih.nlm.ncbi.ngs.error.LibraryLoadError;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;

public class SRAAccession
implements Serializable {
    private static final Log log = Log.getInstance(SRAAccession.class);
    private static boolean noLibraryDownload;
    private static boolean initTried;
    private static String appVersionString;
    private static final String defaultAppVersionString = "[unknown software]";
    private static final String htsJdkVersionString = "HTSJDK-NGS";
    private String acc;

    public static void setAppVersionString(String appVersionString) {
        SRAAccession.appVersionString = appVersionString;
    }

    public static boolean isSupported() {
        return SRAAccession.checkIfInitialized() == null;
    }

    public static ExceptionInInitializerError checkIfInitialized() {
        ExceptionInInitializerError ngsInitError;
        if (!initTried) {
            log.debug("Initializing SRA module");
            ngsInitError = NGS.getInitializationError();
            if (ngsInitError != null) {
                log.info("SRA initialization failed. Will not be able to read from SRA");
            } else {
                NGS.setAppVersionString((String)SRAAccession.getFullVersionString());
            }
            initTried = true;
        } else {
            ngsInitError = NGS.getInitializationError();
        }
        return ngsInitError;
    }

    public static boolean isValid(String acc) {
        boolean looksLikeSRA = false;
        File f = new File(acc);
        if (f.isFile()) {
            byte[] buffer = new byte[8];
            byte[] signature1 = "NCBI.sra".getBytes();
            byte[] signature2 = "NCBInenc".getBytes();
            try (FileInputStream is = new FileInputStream(f);){
                int numRead = ((InputStream)is).read(buffer);
                looksLikeSRA = numRead == buffer.length && (Arrays.equals(buffer, signature1) || Arrays.equals(buffer, signature2));
            }
            catch (IOException e) {
                looksLikeSRA = false;
            }
        } else {
            looksLikeSRA = f.exists() ? false : acc.toUpperCase().matches("^[SED]RR[0-9]{6,9}$");
        }
        if (!looksLikeSRA) {
            return false;
        }
        ExceptionInInitializerError initError = SRAAccession.checkIfInitialized();
        if (initError != null) {
            if (noLibraryDownload && initError instanceof LibraryLoadError) {
                throw new LinkageError("Failed to load SRA native libraries and auto-download is disabled. Please re-run with JVM argument -Dsamjdk.sra_libraries_download=true to enable auto-download of native libraries", initError);
            }
            throw initError;
        }
        return NGS.isValid((String)acc);
    }

    public SRAAccession(String acc) {
        this.acc = acc;
    }

    public String toString() {
        return this.acc;
    }

    public boolean isValid() {
        return SRAAccession.isValid(this.acc);
    }

    private static String getFullVersionString() {
        String versionString = appVersionString == null ? defaultAppVersionString : appVersionString;
        versionString = versionString + " through HTSJDK-NGS";
        return versionString;
    }

    static {
        initTried = false;
        appVersionString = null;
        boolean bl = noLibraryDownload = !Defaults.SRA_LIBRARIES_DOWNLOAD;
        if (noLibraryDownload) {
            System.setProperty("vdb.System.noLibraryDownload", "1");
        }
    }
}

