/*
 * Decompiled with CFR 0.152.
 */
package projects.dimont;

import de.jstacs.DataType;
import de.jstacs.io.FileManager;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.File;
import projects.dimont.DimontPredictorTool;
import projects.dimont.DimontTool;
import projects.dimont.ExtractSequencesTool;
import projects.quickscan.QuickBindingSitePredictionTool;
import projects.slim.SlimDimontTool;

public class TestCreator {
    static CLI.SysProtocol protocol = new CLI.QuietSysProtocol();
    static ProgressUpdater progress = new ProgressUpdater();

    public static void main(String[] args) throws Exception {
        switch (args[0]) {
            case "create": {
                File[] fileArray = new File("intermediate/").listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    file.delete();
                    ++n2;
                }
                TestCreator.create(new ExtractSequencesTool(), new String[][]{{"Genome"}, {"Peaks"}, {"Width"}}, new String[]{"test_data/genome.fa", "test_data/peaks.bed", "1000"}, "./", "extract_1000.xml");
                TestCreator.create(new ExtractSequencesTool(), new String[][]{{"Genome"}, {"Peaks"}, {"Width"}}, new String[]{"test_data/genome.fa", "test_data/peaks.bed", "500"}, "./", "extract_500.xml");
                TestCreator.create(new DimontTool(), new String[][]{{"Input file"}, {"Delete BSs from profile"}}, new String[]{"test_data/PBM.fa", "false"}, "./", "dimont.xml");
                TestCreator.create(new DimontPredictorTool(), new String[][]{{"Input file"}, {"Dimont classifier"}}, new String[]{"test_data/PBM.fa", "test_data/Dimont.xml"}, "./", "predictor.xml");
                TestCreator.create(new SlimDimontTool(), new String[][]{{"Input file"}, {"Delete BSs from profile"}, {"Model type"}, {"Model type", "Order"}}, new String[]{"test_data/PBM.fa", "false", "Markov model", "0"}, "./", "slimdimont.xml");
                TestCreator.create(new QuickBindingSitePredictionTool(), new String[][]{{"Dimont model"}, {"Sequences"}, {"Threshold specification", "Significance level"}}, new String[]{"test_data/Dimont_1.xml", "test_data/genome.fa", "1E-3"}, "./", "qbspt.xml");
                break;
            }
            case "test": {
                boolean verbose = true;
                JstacsTool[] jt = new JstacsTool[]{new ExtractSequencesTool(), new DimontTool(), new SlimDimontTool(), new DimontPredictorTool(), new QuickBindingSitePredictionTool()};
                double all = 0.0;
                JstacsTool[] jstacsToolArray = jt;
                int n = jt.length;
                int n3 = 0;
                while (n3 < n) {
                    JstacsTool t = jstacsToolArray[n3];
                    double success = JstacsTool.test(t, "/Users/dev/Desktop/ChIP-seq/Dimont-conda/tests/", verbose);
                    System.out.println("test summary\t" + t.getShortName() + "\t" + success);
                    all += success;
                    ++n3;
                }
                System.out.println("\n\ntest summary\tPROBLEMS\t" + ((double)jt.length - all));
                break;
            }
            default: {
                System.out.println("unknown option: " + args[0]);
            }
        }
    }

    public static void create(JstacsTool t, String[][] key, String[] value, String dir, String fName) throws Exception {
        protocol.append("create test case for " + t.getShortName() + "\n");
        t.clear();
        ToolParameterSet p = t.getToolParameters();
        int i = 0;
        while (i < key.length) {
            Parameter q = null;
            ParameterSet ps = p;
            int j = 0;
            while (j < key[i].length) {
                q = ps.getParameterForName(key[i][j]);
                if (ps instanceof ExpandableParameterSet && q == null) {
                    ExpandableParameterSet e = (ExpandableParameterSet)ps;
                    e.addParameterToSet();
                    q = ps.getParameterForName(key[i][j]);
                }
                if (q instanceof ParameterSetContainer) {
                    ps = ((ParameterSetContainer)q).getValue();
                } else if (q.getDatatype() == DataType.PARAMETERSET) {
                    ps = (ParameterSet)q.getValue();
                }
                ++j;
            }
            if (!q.checkValue(value[i]) && q.getDatatype() == DataType.PARAMETERSET) {
                ps = (ParameterSet)q.getValue();
                q = ps.getParameterAt(0);
            }
            q.setValue(value[i]);
            ++i;
        }
        ToolResult tr = t.run(p, protocol, progress, 1);
        if (tr != null) {
            ResultSaver<?> saver = ResultSaverLibrary.getSaver(tr.getClass());
            saver.writeOutput(tr, new File(String.valueOf(dir) + "intermediate/"));
            FileManager.writeFile(String.valueOf(dir) + "xml/" + fName, (CharSequence)tr.toXML());
            System.out.println(String.valueOf(t.getShortName()) + ": results saved");
        }
    }

    static void getContent(ResultSet rs) {
        int i = 0;
        while (i < rs.getNumberOfResults()) {
            Result r = rs.getResultAt(i);
            if (r instanceof TextResult) {
                TextResult t = (TextResult)r;
                t.getValue().getContent();
            }
            ++i;
        }
    }
}

