/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.utils.Time;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.WigItem;

public class BigWig2Interval {
    public static void main(String[] args) throws IOException {
        String line;
        BigWigAccessor bwa = new BigWigAccessor(args[0]);
        GZIPInputStream stream = new GZIPInputStream(new FileInputStream(args[1]));
        BufferedReader read = new BufferedReader(new InputStreamReader(stream));
        boolean simple = Boolean.parseBoolean(args[3]);
        int anz = simple ? 4 : 5;
        File f = new File(args[2]);
        BufferedReader r = new BufferedReader(new FileReader(f));
        HashMap<String, ArrayList<int[]>> hash = new HashMap<String, ArrayList<int[]>>();
        while ((line = r.readLine()) != null) {
            String[] split = line.split("\t");
            ArrayList<int[]> current = (ArrayList<int[]>)hash.get(split[0]);
            if (current == null) {
                current = new ArrayList<int[]>();
                hash.put(split[0], current);
            }
            current.add(new int[]{Integer.parseInt(split[1]), Integer.parseInt(split[2])});
        }
        r.close();
        String chr = null;
        int s = -100;
        try (FileOutputStream output = new FileOutputStream(String.valueOf(args[0]) + "-interval" + (simple ? "" : "-orange") + ".txt.gz");){
            Time t = Time.getTimeInstance(null);
            try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(output), "UTF-8"));){
                line = read.readLine();
                do {
                    System.out.println(line);
                    chr = line.substring(1, line.length() - 1);
                    ArrayList interval = (ArrayList)hash.get(chr);
                    int i = 0;
                    int[] inter = null;
                    int e = 0;
                    s = 0;
                    if (!simple) {
                        w.append(line);
                        w.newLine();
                    }
                    while ((line = read.readLine()) != null && line.charAt(0) != '[') {
                        e += 50;
                    }
                    double[] profile = bwa.getProfileInRegion(chr, s, e);
                    while (s + 50 <= e) {
                        if (simple) {
                            w.append(String.valueOf(chr) + "\t" + s + "\t");
                        }
                        while (interval != null && i < interval.size() && s >= (inter = (int[])interval.get(i))[1]) {
                            ++i;
                        }
                        if (interval != null && i < interval.size() && s >= inter[0]) {
                            if (simple) {
                                w.append(String.valueOf(ToolBox.min(s, s + 50, profile)) + "\t" + ToolBox.median(s, s + 50, profile) + "\t" + ToolBox.max(s, s + 50, profile) + "\t" + ToolBox.percentile(s, s + 50, profile, 0.25));
                            } else {
                                w.append(String.valueOf(BigWig2Interval.orange(s - 200, s + 250, profile)) + "\t" + BigWig2Interval.mostMonotonSteps(s - 200, s, profile, 1.0) + "\t" + BigWig2Interval.mostMonotonSteps(s - 200, s, profile, -1.0) + "\t" + BigWig2Interval.mostMonotonSteps(s + 50, s + 250, profile, 1.0) + "\t" + BigWig2Interval.mostMonotonSteps(s + 50, s + 250, profile, -1.0));
                            }
                        } else {
                            int j = 0;
                            while (j < anz) {
                                w.append(String.valueOf(j == 0 ? "" : "\t") + 0);
                                ++j;
                            }
                        }
                        w.newLine();
                        s += 50;
                    }
                    System.out.println(t.getElapsedTime());
                } while (line != null);
            }
        }
        read.close();
        stream.close();
    }

    private static int orange(int start, int end, double[] profile) {
        int different = 0;
        start = Math.max(0, start);
        end = Math.min(profile.length, end);
        int s = start + 1;
        while (s < end) {
            if (profile[s - 1] != profile[s]) {
                ++different;
            }
            ++s;
        }
        return different;
    }

    private static int mostMonotonSteps(int start, int end, double[] profile, double vz) {
        int num = 0;
        int max = 0;
        start = Math.max(0, start);
        end = Math.min(profile.length, end);
        int s = start + 1;
        while (s < end) {
            if (vz * profile[s - 1] < vz * profile[s]) {
                ++num;
            } else if (vz * profile[s - 1] > vz * profile[s]) {
                if (num > max) {
                    max = num;
                }
                num = 0;
            }
            ++s;
        }
        return max;
    }

    private static class BigWigAccessor {
        private BBFileReader reader;

        public BigWigAccessor(String bigWigFile) throws IOException {
            this.reader = new BBFileReader(bigWigFile);
            BBFileHeader header = this.reader.getBBFileHeader();
            if (!header.isHeaderOK()) {
                throw new RuntimeException("Header not OK");
            }
            if (!header.isBigWig()) {
                throw new RuntimeException("No Bigwig");
            }
        }

        public double[] getProfileInRegion(String chr, int start, int end) {
            double[] res = new double[end - start];
            this.fillProfileInRegion(chr, start, end, res);
            return res;
        }

        public void fillProfileInRegion(String chr, int start, int end, double[] res) {
            BigWigIterator it = this.reader.getBigWigIterator(chr, start, chr, end, false);
            while (it.hasNext()) {
                WigItem item = it.next();
                Arrays.fill(res, Math.max(0, item.getStartBase() - start), Math.min(item.getEndBase(), end) - start, (double)item.getWigValue());
            }
        }
    }
}

