/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.results.Result;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegionTractScan2 {
    public static void main(String[] args) throws Exception {
        Pair<int[][], DataSet> seqs = null;
        StringBuffer lastHeader = new StringBuffer();
        BufferedReader read = new BufferedReader(new FileReader(args[0]));
        DecimalFormat nf = new DecimalFormat("#.####");
        DecimalFormatSymbols syms = nf.getDecimalFormatSymbols();
        syms.setInfinity("Inf");
        syms.setNaN("NaN");
        nf.setDecimalFormatSymbols(syms);
        PrintWriter wr = new PrintWriter(String.valueOf(args[0]) + "_tracts.txt");
        double[] scoresSing = new double[50];
        Arrays.fill(scoresSing, 0.0);
        double[] scoresBoth = new double[50];
        Arrays.fill(scoresBoth, 0.0);
        int currIdx = 0;
        int lastOff = 0;
        String lastId = null;
        while ((seqs = RegionTractScan2.readNextSequences(read, lastHeader)) != null) {
            DataSet ds = seqs.getSecondElement();
            int[][] idxs = seqs.getFirstElement();
            int i = 0;
            while (i < ds.getNumberOfElements()) {
                Sequence seq = ds.getElementAt(i);
                String id = seq.getSequenceAnnotationByType("id", 0).getIdentifier();
                if (!id.equals(lastId)) {
                    currIdx = 0;
                    lastOff = 0;
                    Arrays.fill(scoresSing, 0.0);
                    Arrays.fill(scoresBoth, 0.0);
                    wr.println("[" + id + "]");
                }
                int off = idxs[0][i];
                int j = lastOff;
                while (j < off) {
                    scoresSing[currIdx] = 0.0;
                    scoresBoth[currIdx] = 0.0;
                    if (++currIdx == scoresSing.length) {
                        RegionTractScan2.print(wr, id, scoresSing, scoresBoth, lastOff, j, currIdx);
                        currIdx = 0;
                        Arrays.fill(scoresSing, 0.0);
                        Arrays.fill(scoresBoth, 0.0);
                    }
                    ++j;
                }
                j = 0;
                while (j < seq.getLength()) {
                    scoresSing[currIdx] = RegionTractScan2.getTractLength(seq, j);
                    scoresBoth[currIdx] = RegionTractScan2.getGCATTractLength(seq, j);
                    if (++currIdx == scoresSing.length) {
                        RegionTractScan2.print(wr, id, scoresSing, scoresBoth, off, j, currIdx);
                        currIdx = 0;
                        Arrays.fill(scoresSing, 0.0);
                        Arrays.fill(scoresBoth, 0.0);
                    }
                    lastOff = off + j + 1;
                    ++j;
                }
                lastId = id;
                ++i;
            }
        }
        read.close();
        wr.close();
    }

    private static int getTractLength(Sequence seq, int j) {
        int len = 0;
        int curr = seq.discreteVal(j);
        int i = j;
        while (i >= 0 && seq.discreteVal(i) == curr) {
            ++len;
            --i;
        }
        i = j + 1;
        while (i < seq.getLength() && seq.discreteVal(i) == curr) {
            ++len;
            ++i;
        }
        if (curr == 0 || curr == 3) {
            return len;
        }
        return -len;
    }

    private static int getGCATTractLength(Sequence seq, int j) {
        int len = 0;
        int curr = seq.discreteVal(j);
        int i = j;
        while (i >= 0 && (seq.discreteVal(i) == curr || seq.discreteVal(i) == 3 - curr)) {
            ++len;
            --i;
        }
        i = j + 1;
        while (i < seq.getLength() && (seq.discreteVal(i) == curr || seq.discreteVal(i) == 3 - curr)) {
            ++len;
            ++i;
        }
        if (curr == 0 || curr == 3) {
            return len;
        }
        return -len;
    }

    private static void print(PrintWriter wr, String id, double[] scoresSing, double[] scoresBoth, int off, int j, int end) {
        int min;
        int max;
        int min1;
        int max1;
        if (scoresSing == null) {
            max1 = 0;
            min1 = 0;
            max = 0;
            min = 0;
        } else {
            max = (int)ToolBox.max(scoresSing);
            min = (int)ToolBox.min(scoresSing);
            max1 = (int)ToolBox.max(scoresBoth);
            min1 = (int)ToolBox.min(scoresBoth);
        }
        if (max < 0) {
            max = 0;
        }
        if (min > 0) {
            min = 0;
        }
        if (max1 < 0) {
            max1 = 0;
        }
        if (min1 > 0) {
            min1 = 0;
        }
        wr.println(String.valueOf(max) + "\t" + -min + "\t" + max1 + "\t" + -min1);
    }

    private static int aboveThreshold(double[] scores1, double t, int end) {
        int n = 0;
        int i = 0;
        while (i < end) {
            if (scores1[i] > t) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static double getConsensusScore(double[][] pwm) {
        double score = 0.0;
        int i = 0;
        while (i < pwm.length) {
            score += ToolBox.max(pwm[i]);
            ++i;
        }
        return score;
    }

    public static Pair<int[][], DataSet> readNextSequences(BufferedReader read, StringBuffer lastHeader) throws Exception {
        String str = null;
        StringBuffer line = new StringBuffer();
        IntList starts = new IntList();
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        Pattern acgt = Pattern.compile("[ACGT]+", 2);
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        int size = 0;
        while ((str = read.readLine()) != null || line.length() > 0) {
            if (str != null) {
                str = str.trim();
            }
            if (str == null || str.startsWith(">")) {
                String header = lastHeader.toString();
                if (str != null) {
                    lastHeader.delete(0, lastHeader.length());
                    lastHeader.append(str.substring(1).trim());
                }
                if (line.length() <= 0) continue;
                String seqStr = line.toString();
                line.delete(0, line.length());
                Matcher match = acgt.matcher(seqStr);
                while (match.find()) {
                    int start = match.start();
                    int end = match.end();
                    SequenceAnnotation annotation = new SequenceAnnotation("id", header, (Result[][])new Result[0][]);
                    Sequence seq = Sequence.create(DNAAlphabetContainer.SINGLETON, seqStr.substring(start, end));
                    seq = seq.annotate(false, annotation);
                    seqs.add(seq);
                    size += end - start;
                    starts.add(start);
                }
                if (!((double)size > 1.0E7) && str != null) continue;
                boolean s = false;
                return new Pair<int[][], DataSet>(new int[][]{starts.toArray()}, new DataSet("", seqs));
            }
            line.append(str);
        }
        return null;
    }
}

