/*
 * Decompiled with CFR 0.152.
 */
package projects.encodedream;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.sequenceScores.QuickScanningSequenceScore;
import de.jstacs.utils.IntList;
import de.jstacs.utils.LargeSequenceReader;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.naming.OperationNotSupportedException;

public class LowMemProfileTool {
    public void run(QuickScanningSequenceScore model2, String genome, PrintStream out2, int bin, String faiFile) throws OperationNotSupportedException, NumberFormatException, IOException {
        BufferedReader faidx = new BufferedReader(new InputStreamReader(new FileInputStream(faiFile)));
        String str = null;
        HashMap<String, Integer> sizes = new HashMap<String, Integer>();
        while ((str = faidx.readLine()) != null) {
            String[] parts = str.split("\t");
            String chr = parts[0];
            int len = Integer.parseInt(parts[1]);
            sizes.put(chr, len);
        }
        faidx.close();
        double[] scores = new double[2 * bin];
        Arrays.fill(scores, Double.NEGATIVE_INFINITY);
        int currIdx = 0;
        int lastOff = 0;
        String lastId = null;
        StringBuffer lastHeader = new StringBuffer();
        BufferedReader read = null;
        read = genome.toLowerCase().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(genome)))) : new BufferedReader(new FileReader(genome));
        Pair<IntList, ArrayList<Sequence>> pair = null;
        while ((pair = LargeSequenceReader.readNextSequences(read, lastHeader, model2.getLength(), model2.getAlphabetContainer())) != null) {
            ArrayList<Sequence> seqs = pair.getSecondElement();
            IntList starts = pair.getFirstElement();
            int i = 0;
            while (i < seqs.size()) {
                Sequence seq = seqs.get(i);
                int off = starts.get(i);
                String id = seq.getSequenceAnnotationByType("id", 0).getIdentifier();
                if (lastId != null && !id.equals(lastId)) {
                    int totLen = (Integer)sizes.get(lastId);
                    int j = lastOff;
                    while (j < totLen) {
                        scores[2 * currIdx] = Double.NEGATIVE_INFINITY;
                        scores[2 * currIdx + 1] = Double.NEGATIVE_INFINITY;
                        if (++currIdx == bin) {
                            this.print(lastId, j - bin, scores, out2);
                            currIdx = 0;
                            Arrays.fill(scores, Double.NEGATIVE_INFINITY);
                        }
                        ++j;
                    }
                    currIdx = 0;
                    lastOff = 0;
                    Arrays.fill(scores, Double.NEGATIVE_INFINITY);
                }
                int j = lastOff;
                while (j < off) {
                    if (++currIdx == bin) {
                        out2.println(String.valueOf(id) + "\t" + (j - bin + 1) + "\tNA\tNA");
                        currIdx = 0;
                    }
                    ++j;
                }
                j = 0;
                while (j < seq.getLength() - model2.getLength() + 1) {
                    float[] compScore = new float[]{(float)model2.getLogScoreFor(seq, j), (float)model2.getLogScoreFor(seq.reverseComplement(), seq.getLength() - j - model2.getLength())};
                    scores[2 * currIdx] = compScore[0];
                    scores[2 * currIdx + 1] = compScore[1];
                    if (++currIdx == bin) {
                        this.print(id, off + j - bin, scores, out2);
                        currIdx = 0;
                        Arrays.fill(scores, Double.NEGATIVE_INFINITY);
                    }
                    lastOff = off + j + 1;
                    ++j;
                }
                lastId = id;
                ++i;
            }
        }
        int totLen = (Integer)sizes.get(lastId);
        int j = lastOff;
        while (j < totLen) {
            scores[2 * currIdx] = Double.NEGATIVE_INFINITY;
            scores[2 * currIdx + 1] = Double.NEGATIVE_INFINITY;
            if (++currIdx == bin) {
                this.print(lastId, j - bin, scores, out2);
                currIdx = 0;
                Arrays.fill(scores, Double.NEGATIVE_INFINITY);
            }
            ++j;
        }
    }

    private void print(String chr, int position, double[] scores, PrintStream out) {
        float max = (float)ToolBox.max(scores);
        double ls = Normalisation.getLogSum(scores);
        String maxS = Double.isInfinite(max) ? "NA" : String.valueOf(max);
        String lsS = Double.isInfinite(ls) ? "NA" : String.valueOf(ls);
        out.println(String.valueOf(chr) + "\t" + (position + 1) + "\t" + maxS + "\t" + lsS);
    }
}

