/*
 * Decompiled with CFR 0.152.
 */
package projects.encodedream;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class ObjectStream<E>
implements Iterator<E> {
    private LinkedList<E> queue = new LinkedList();
    private boolean closed = false;
    private Semaphore limit;

    public ObjectStream() {
        this(Integer.MAX_VALUE);
    }

    public ObjectStream(int limit) {
        this.limit = new Semaphore(limit, true);
    }

    public ObjectStream(String file, Class<E> clazz) throws IOException, ReflectiveOperationException {
        this(Integer.MAX_VALUE);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String str = null;
        while ((str = reader.readLine()) != null) {
            E el = clazz.getConstructor(String.class).newInstance(str);
            this.add(el);
        }
        reader.close();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E pile) {
        LinkedList<E> linkedList;
        if (this.closed) {
            throw new RuntimeException("closed");
        }
        try {
            linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.notify();
            }
            this.limit.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(pile);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (this.closed) {
            LinkedList<E> linkedList = this.queue;
            synchronized (linkedList) {
                return this.queue.size() > 0;
            }
        }
        LinkedList<E> linkedList = this.queue;
        synchronized (linkedList) {
            while (!this.closed && this.queue.size() == 0) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        E pile = null;
        this.limit.release();
        LinkedList<E> linkedList = this.queue;
        synchronized (linkedList) {
            pile = this.queue.removeFirst();
            this.queue.notify();
        }
        return pile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        LinkedList<E> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notify();
        }
    }

    public void print(PrintStream out) {
        while (this.hasNext()) {
            E o = this.next();
            out.println(o.toString());
        }
    }
}

