/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.epigenetic;

import de.jstacs.io.FileManager;
import de.jstacs.parameters.FileParameter;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class BismarkMerge2Files
implements JstacsTool {
    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new BismarkMerge2Files());
        cli.run(args);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        FileParameter bismarkFile1 = new FileParameter("Bismark file 1", "Methylationinformation in bismark format file 1", "cov.gz,cov", true);
        FileParameter bismarkFile2 = new FileParameter("Bismark file 2", "Methylationinformation in bismark format file 2", "cov.gz,cov", true);
        return new ToolParameterSet(this.getShortName(), bismarkFile1, bismarkFile2);
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        String[] splitLine;
        progress.setLast(1.0);
        progress.setCurrent(0.0);
        String bismarkFile1 = parameters.getParameterAt(0).getValue().toString();
        BufferedReader BR = null;
        BR = bismarkFile1.endsWith("gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(bismarkFile1))))) : new BufferedReader(new InputStreamReader(new FileInputStream(new File(bismarkFile1))));
        String bismarkFile2 = parameters.getParameterAt(1).getValue().toString();
        BufferedReader BR2 = null;
        BR2 = bismarkFile2.endsWith("gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(bismarkFile2))))) : new BufferedReader(new InputStreamReader(new FileInputStream(new File(bismarkFile2))));
        File out = File.createTempFile("merged.bismark", ".temp.gz", new File("."));
        out.deleteOnExit();
        GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(out));
        PrintStream os_ps = new PrintStream(os);
        HashMap<String, HashMap> tempBismark = new HashMap<String, HashMap>();
        String line = "";
        while ((line = BR.readLine()) != null) {
            splitLine = line.split("\t");
            HashMap temp = null;
            temp = tempBismark.containsKey(splitLine[0]) ? (HashMap)tempBismark.get(splitLine[0]) : new HashMap();
            temp.put(Integer.parseInt(splitLine[1]), line);
            tempBismark.put(splitLine[0], temp);
        }
        BR.close();
        line = "";
        while ((line = BR2.readLine()) != null) {
            splitLine = line.split("\t");
            HashMap temp = (HashMap)tempBismark.get(splitLine[0]);
            if (!temp.containsKey(Integer.parseInt(splitLine[1]))) {
                temp.put(Integer.parseInt(splitLine[1]), line);
            } else {
                String[] splitLineF1 = ((String)temp.get(Integer.parseInt(splitLine[1]))).split("\t");
                double count_methyl = Integer.parseInt(splitLineF1[4]) + Integer.parseInt(splitLine[4]);
                double count_unmethyl = Integer.parseInt(splitLineF1[5]) + Integer.parseInt(splitLine[5]);
                double methylationLevel = 0.0;
                if (count_methyl > 0.0) {
                    methylationLevel = count_methyl / (count_methyl + count_unmethyl) * 100.0;
                }
                String newLine = String.valueOf(splitLineF1[0]) + "\t" + splitLineF1[1] + "\t" + splitLineF1[2] + "\t" + methylationLevel + "\t" + (int)count_methyl + "\t" + (int)count_unmethyl;
                temp.put(Integer.parseInt(splitLine[1]), newLine);
            }
            tempBismark.put(splitLine[0], temp);
        }
        BR2.close();
        for (String chrom : tempBismark.keySet()) {
            HashMap temp = (HashMap)tempBismark.get(chrom);
            ArrayList sortedByKey = new ArrayList(temp.keySet());
            Collections.sort(sortedByKey);
            for (Integer i : sortedByKey) {
                os_ps.print(String.valueOf((String)temp.get(i)) + "\n");
            }
        }
        os.close();
        TextResult tr = new TextResult("Merged Bismark file", "Merged Bismark file", new FileParameter.FileRepresentation(out.getAbsolutePath()), "cov.gz", this.getToolName(), null, true);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(tr), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "BismarkMerge2Files";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "bismerger";
    }

    @Override
    public String getDescription() {
        return "Merges 2 Files in bismark format";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(BismarkMerge2Files.class.getClassLoader().getResourceAsStream("projects/tals/epigenetic/toolHelpFiles/BismarkMerge2Files.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

